/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.QueryTermExtractor;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.WeightedTerm;

public class QueryScorer
implements Scorer {
    TextFragment currentTextFragment = null;
    HashSet uniqueTermsInFragment;
    float totalScore = 0.0f;
    private HashMap termsToFind = new HashMap();

    public QueryScorer(Query query) {
        this(QueryTermExtractor.getTerms(query));
    }

    public QueryScorer(WeightedTerm[] weightedTerms) {
        for (int i = 0; i < weightedTerms.length; ++i) {
            this.termsToFind.put(weightedTerms[i].term, weightedTerms[i]);
        }
    }

    public void startFragment(TextFragment newFragment) {
        this.uniqueTermsInFragment = new HashSet();
        this.currentTextFragment = newFragment;
        this.totalScore = 0.0f;
    }

    public float getTokenScore(Token token) {
        String termText = token.termText();
        WeightedTerm queryTerm = (WeightedTerm)this.termsToFind.get(termText);
        if (queryTerm == null) {
            return 0.0f;
        }
        if (!this.uniqueTermsInFragment.contains(termText)) {
            this.totalScore += queryTerm.getWeight();
            this.uniqueTermsInFragment.add(termText);
        }
        return queryTerm.getWeight();
    }

    public float getFragmentScore() {
        return this.totalScore;
    }

    public void allFragmentsProcessed() {
    }
}

