/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.highlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.FragmentQueue;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenGroup;

public class Highlighter {
    public static final int DEFAULT_MAX_DOC_BYTES_TO_ANALYZE = 51200;
    private int maxDocBytesToAnalyze = 51200;
    private Formatter formatter;
    private Fragmenter textFragmenter = new SimpleFragmenter();
    private Scorer fragmentScorer = null;

    public Highlighter(Scorer fragmentScorer) {
        this(new SimpleHTMLFormatter(), fragmentScorer);
    }

    public Highlighter(Formatter formatter, Scorer fragmentScorer) {
        this.formatter = formatter;
        this.fragmentScorer = fragmentScorer;
    }

    public final String getBestFragment(TokenStream tokenStream, String text) throws IOException {
        String[] results = this.getBestFragments(tokenStream, text, 1);
        if (results.length > 0) {
            return results[0];
        }
        return null;
    }

    public final String[] getBestFragments(TokenStream tokenStream, String text, int maxNumFragments) throws IOException {
        maxNumFragments = Math.max(1, maxNumFragments);
        TextFragment[] frag = this.getBestTextFragments(tokenStream, text, true, maxNumFragments);
        ArrayList<String> fragTexts = new ArrayList<String>();
        boolean n = false;
        for (int i = 0; i < frag.length; ++i) {
            if (frag[i] == null || !(frag[i].getScore() > 0.0f)) continue;
            fragTexts.add(frag[i].toString());
        }
        return fragTexts.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextFragment[] getBestTextFragments(TokenStream tokenStream, String text, boolean mergeContiguousFragments, int maxNumFragments) throws IOException {
        TextFragment[] textFragmentArray;
        block16: {
            ArrayList<TextFragment> docFrags = new ArrayList<TextFragment>();
            StringBuffer newText = new StringBuffer();
            TextFragment currentFrag = new TextFragment(newText, newText.length(), docFrags.size());
            this.fragmentScorer.startFragment(currentFrag);
            docFrags.add(currentFrag);
            FragmentQueue fragQueue = new FragmentQueue(maxNumFragments);
            try {
                String markedUpText;
                String tokenText;
                int endOffset;
                int startOffset;
                Token token;
                int lastEndOffset = 0;
                this.textFragmenter.start(text);
                TokenGroup tokenGroup = new TokenGroup();
                while ((token = tokenStream.next()) != null) {
                    if (tokenGroup.numTokens > 0 && tokenGroup.isDistinct(token)) {
                        startOffset = tokenGroup.startOffset;
                        endOffset = tokenGroup.endOffset;
                        tokenText = text.substring(startOffset, endOffset);
                        markedUpText = this.formatter.highlightTerm(tokenText, tokenGroup);
                        if (startOffset > lastEndOffset) {
                            newText.append(text.substring(lastEndOffset, startOffset));
                        }
                        newText.append(markedUpText);
                        lastEndOffset = endOffset;
                        tokenGroup.clear();
                        if (this.textFragmenter.isNewFragment(token)) {
                            currentFrag.setScore(this.fragmentScorer.getFragmentScore());
                            currentFrag.textEndPos = newText.length();
                            currentFrag = new TextFragment(newText, newText.length(), docFrags.size());
                            this.fragmentScorer.startFragment(currentFrag);
                            docFrags.add(currentFrag);
                        }
                    }
                    tokenGroup.addToken(token, this.fragmentScorer.getTokenScore(token));
                    if (lastEndOffset <= this.maxDocBytesToAnalyze) continue;
                }
                currentFrag.setScore(this.fragmentScorer.getFragmentScore());
                if (tokenGroup.numTokens > 0) {
                    startOffset = tokenGroup.startOffset;
                    endOffset = tokenGroup.endOffset;
                    tokenText = text.substring(startOffset, endOffset);
                    markedUpText = this.formatter.highlightTerm(tokenText, tokenGroup);
                    if (startOffset > lastEndOffset) {
                        newText.append(text.substring(lastEndOffset, startOffset));
                    }
                    newText.append(markedUpText);
                    lastEndOffset = endOffset;
                }
                if (lastEndOffset < text.length()) {
                    newText.append(text.substring(lastEndOffset));
                }
                currentFrag.textEndPos = newText.length();
                boolean minScore = false;
                Iterator i = docFrags.iterator();
                while (i.hasNext()) {
                    currentFrag = (TextFragment)i.next();
                    fragQueue.insert(currentFrag);
                }
                TextFragment[] frag = new TextFragment[fragQueue.size()];
                for (int i2 = frag.length - 1; i2 >= 0; --i2) {
                    frag[i2] = (TextFragment)fragQueue.pop();
                }
                if (mergeContiguousFragments) {
                    this.mergeContiguousFragments(frag);
                    ArrayList<TextFragment> fragTexts = new ArrayList<TextFragment>();
                    for (int i3 = 0; i3 < frag.length; ++i3) {
                        if (frag[i3] == null || !(frag[i3].getScore() > 0.0f)) continue;
                        fragTexts.add(frag[i3]);
                    }
                    frag = fragTexts.toArray(new TextFragment[0]);
                }
                textFragmentArray = frag;
                Object var20_22 = null;
                if (tokenStream == null) break block16;
            }
            catch (Throwable throwable) {
                block17: {
                    Object var20_23 = null;
                    if (tokenStream == null) break block17;
                    try {
                        tokenStream.close();
                    }
                    catch (Exception e) {}
                }
                throw throwable;
            }
            try {
                tokenStream.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return textFragmentArray;
    }

    private void mergeContiguousFragments(TextFragment[] frag) {
        if (frag.length > 1) {
            boolean mergingStillBeingDone;
            do {
                mergingStillBeingDone = false;
                block1: for (int i = 0; i < frag.length; ++i) {
                    if (frag[i] == null) continue;
                    for (int x = 0; x < frag.length; ++x) {
                        int worstScoringFragNum;
                        int bestScoringFragNum;
                        if (frag[x] == null) continue;
                        if (frag[i] == null) continue block1;
                        TextFragment frag1 = null;
                        TextFragment frag2 = null;
                        int frag1Num = 0;
                        int frag2Num = 0;
                        if (frag[i].follows(frag[x])) {
                            frag1 = frag[x];
                            frag1Num = x;
                            frag2 = frag[i];
                            frag2Num = i;
                        } else if (frag[x].follows(frag[i])) {
                            frag1 = frag[i];
                            frag1Num = i;
                            frag2 = frag[x];
                            frag2Num = x;
                        }
                        if (frag1 == null) continue;
                        if (frag1.getScore() > frag2.getScore()) {
                            bestScoringFragNum = frag1Num;
                            worstScoringFragNum = frag2Num;
                        } else {
                            bestScoringFragNum = frag2Num;
                            worstScoringFragNum = frag1Num;
                        }
                        frag1.merge(frag2);
                        frag[worstScoringFragNum] = null;
                        mergingStillBeingDone = true;
                        frag[bestScoringFragNum] = frag1;
                    }
                }
            } while (mergingStillBeingDone);
        }
    }

    public final String getBestFragments(TokenStream tokenStream, String text, int maxNumFragments, String separator) throws IOException {
        String[] sections = this.getBestFragments(tokenStream, text, maxNumFragments);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < sections.length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(sections[i]);
        }
        return result.toString();
    }

    public int getMaxDocBytesToAnalyze() {
        return this.maxDocBytesToAnalyze;
    }

    public void setMaxDocBytesToAnalyze(int byteCount) {
        this.maxDocBytesToAnalyze = byteCount;
    }

    public Fragmenter getTextFragmenter() {
        return this.textFragmenter;
    }

    public void setTextFragmenter(Fragmenter fragmenter) {
        this.textFragmenter = fragmenter;
    }

    public Scorer getFragmentScorer() {
        return this.fragmentScorer;
    }

    public void setFragmentScorer(Scorer scorer) {
        this.fragmentScorer = scorer;
    }
}

