/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.jacl;

import java.lang.reflect.Array;
import java.util.Vector;
import org.apache.bsf.BSFDeclaredBean;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.bsf.engines.jacl.BSFCommand;
import org.apache.bsf.util.BSFEngineImpl;
import tcl.lang.Command;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclObject;
import tcl.lang.TclString;

public class JaclEngine
extends BSFEngineImpl {
    private Interp interp;

    public Object call(Object obj, String method, Object[] args) throws BSFException {
        StringBuffer tclScript = new StringBuffer(method);
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (args[i].getClass().isArray()) {
                    tclScript.append(" {");
                    int array_length = Array.getLength(args[i]);
                    int j = 0;
                    while (j < array_length) {
                        tclScript.append("\"" + Array.get(args[i], j).toString() + "\"");
                        if (j + 1 < array_length) {
                            tclScript.append(" ");
                        }
                        ++j;
                    }
                    tclScript.append("}");
                } else {
                    tclScript.append(" \"");
                    tclScript.append(args[i].toString());
                    tclScript.append("\"");
                }
                ++i;
            }
        }
        return this.eval("<function call>", 0, 0, tclScript.toString());
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        String expr = "set " + bean.name + " [bsf lookupBean \"" + bean.name + "\"]";
        this.eval("<declare bean>", 0, 0, expr);
    }

    public Object eval(String source, int lineNo, int columnNo, Object oscript) throws BSFException {
        String script = oscript.toString();
        try {
            this.interp.eval(script);
            TclObject result = this.interp.getResult();
            InternalRep internalRep = result.getInternalRep();
            if (internalRep instanceof ReflectObject) {
                return ReflectObject.get((Interp)this.interp, (TclObject)result);
            }
            if (internalRep instanceof TclString) {
                return result.toString();
            }
            if (internalRep instanceof TclDouble) {
                return new Double(TclDouble.get((Interp)this.interp, (TclObject)result));
            }
            if (internalRep instanceof TclInteger) {
                return new Integer(TclInteger.get((Interp)this.interp, (TclObject)result));
            }
            return result;
        }
        catch (TclException e) {
            throw new BSFException(BSFException.REASON_EXECUTION_ERROR, "error while eval'ing Jacl expression: " + this.interp.getResult(), (Throwable)e);
        }
    }

    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        this.interp = new Interp();
        this.interp.createCommand("bsf", (Command)new BSFCommand(mgr, (BSFEngine)this));
        try {
            this.interp.eval("jaclloadjava");
        }
        catch (TclException e) {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "error while loading java package: " + this.interp.getResult(), (Throwable)e);
        }
        int size = declaredBeans.size();
        int i = 0;
        while (i < size) {
            this.declareBean((BSFDeclaredBean)declaredBeans.elementAt(i));
            ++i;
        }
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        this.eval("<undeclare bean>", 0, 0, "set " + bean.name + " \"\"");
    }
}

