/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.xml;

import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.xml.exceptions.CantFindResourceException;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.InputSource;

public class XmlInputSource
extends InputSource {
    private String mXmlPath = null;
    private URL mResource = null;

    public XmlInputSource(String xmlPath, ResourceFinder resourceFinder) {
        if (xmlPath == null) {
            throw new IllegalArgumentException("xmlPath can't be null.");
        }
        if (xmlPath.length() == 0) {
            throw new IllegalArgumentException("xmlPath can't be empty.");
        }
        if (resourceFinder == null) {
            throw new IllegalArgumentException("resourceFinder can't be null.");
        }
        this.mXmlPath = xmlPath;
        URL resource = resourceFinder.getResource(xmlPath);
        if (resource == null) {
            throw new CantFindResourceException(xmlPath, null);
        }
        this.setResource(resource);
    }

    public XmlInputSource(URL resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource can't be null.");
        }
        this.setResource(resource);
    }

    public void setResource(URL resource) {
        this.mResource = resource;
        this.setSystemId(this.mResource.toExternalForm());
        try {
            if (resource.getProtocol().equals("classloader")) {
                this.setByteStream(resource.openStream());
            } else {
                String sax_driver = System.getProperty("org.xml.sax.driver");
                if (sax_driver != null && sax_driver.equals("com.caucho.xml.Xml")) {
                    this.setByteStream(resource.openStream());
                }
            }
        }
        catch (IOException e) {
            this.setByteStream(null);
        }
    }

    public String toString() {
        return this.mResource.toExternalForm();
    }
}

