/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.xml;

import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.xml.XmlInputSource;
import com.uwyn.rife.xml.exceptions.CantFindEntityException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class XmlEntityResolver
implements EntityResolver {
    private ResourceFinder mResourceFinder = null;
    private HashMap<String, String> mEntityAliases = null;
    private boolean mRestrictToAliases = false;
    private static /* synthetic */ boolean $assertionsDisabled;

    public XmlEntityResolver(ResourceFinder resourcefinder) {
        this.mResourceFinder = resourcefinder;
    }

    public XmlEntityResolver addAlias(String original, String alias) {
        if (this.mEntityAliases == null) {
            this.mEntityAliases = new HashMap();
        }
        this.mEntityAliases.put(original, alias);
        return this;
    }

    public XmlEntityResolver restrictToAliases(boolean restrict) {
        this.mRestrictToAliases = restrict;
        return this;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        if (!$assertionsDisabled && systemId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && systemId.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mEntityAliases != null) {
            String alias = this.mEntityAliases.get(systemId);
            if (alias != null) {
                systemId = alias;
            } else if (this.mRestrictToAliases) {
                throw new CantFindEntityException(systemId, null);
            }
        } else if (this.mRestrictToAliases) {
            throw new CantFindEntityException(systemId, null);
        }
        URL resource = null;
        if (systemId.startsWith("http://")) {
            try {
                resource = new URL(systemId);
                return new XmlInputSource(resource);
            }
            catch (MalformedURLException e) {
                resource = null;
            }
        }
        if ((resource = this.mResourceFinder.getResource(systemId)) != null) {
            return new XmlInputSource(resource);
        }
        if (systemId.startsWith("classloader:/")) {
            systemId = systemId.substring("classloader:/".length());
        }
        if (systemId.startsWith("zip:/")) {
            systemId = systemId.substring("zip:/".length());
        }
        if (systemId.startsWith("jar:/")) {
            systemId = systemId.substring("jar:/".length());
        }
        if (systemId.startsWith("file:/")) {
            systemId = systemId.substring("file:/".length());
        }
        if (systemId.startsWith("//")) {
            systemId = systemId.substring("//".length());
        }
        if ((resource = this.mResourceFinder.getResource(systemId)) == null) {
            throw new CantFindEntityException(systemId, null);
        }
        return new XmlInputSource(resource);
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.xml.XmlEntityResolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

