/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.pcj.map.CharKeyOpenHashMap;
import com.uwyn.rife.tools.Base64;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringUtils {
    public static String ENCODING_US_ASCII = "US-ASCII";
    public static String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static String ENCODING_ISO_8859_2 = "ISO-8859-2";
    public static String ENCODING_ISO_8859_5 = "ISO-8859-5";
    public static String ENCODING_UTF_8 = "UTF-8";
    public static String ENCODING_UTF_16BE = "UTF-16BE";
    public static String ENCODING_UTF_16LE = "UTF-16LE";
    public static String ENCODING_UTF_16 = "UTF-16";
    public static Charset CHARSET_US_ASCII = Charset.forName(ENCODING_US_ASCII);
    public static final BbcodeOption SHORTEN_URL = new BbcodeOption("SHORTEN_URL");
    public static final BbcodeOption SANITIZE_URL = new BbcodeOption("SANITIZE_URL");
    public static final BbcodeOption CONVERT_BARE_URLS = new BbcodeOption("CONVERT_BARE_URLS");
    public static final BbcodeOption NO_FOLLOW_LINKS = new BbcodeOption("NO_FOLLOW_LINKS");
    private static final Pattern BBCODE_COLOR = Pattern.compile("\\[color\\s*=\\s*([#\\w]*)\\s*\\]", 2);
    private static final Pattern BBCODE_SIZE = Pattern.compile("\\[size\\s*=\\s*([+\\-]?[0-9]*)\\s*\\]", 2);
    private static final Pattern BBCODE_URL_SHORT = Pattern.compile("\\[url\\]\\s*([^\\s]*)\\s*\\[\\/url\\]", 2);
    private static final Pattern BBCODE_URL_LONG = Pattern.compile("\\[url=([^\\[]*)\\]([^\\[]*)\\[/url\\]", 2);
    private static final Pattern BBCODE_IMG = Pattern.compile("\\[img\\]\\s*([^\\s]*)\\s*\\[\\/img\\]", 2);
    private static final Pattern BBCODE_QUOTE_LONG = Pattern.compile("\\[quote=([^\\]]+\\]*)\\]", 10);
    private static final Pattern BBCODE_BAREURL = Pattern.compile("(?:[^\"'=>\\]]|^)((?:http|ftp)s?://(?:%[\\p{Digit}A-Fa-f][\\p{Digit}A-Fa-f]|[\\-_\\.!~*';\\|/?:@#&=\\+$,\\p{Alnum}])+)", 10);
    private static final CharKeyOpenHashMap<String> mAggressiveHtmlEncodeMap = new CharKeyOpenHashMap();
    private static final CharKeyOpenHashMap<String> mDefensiveHtmlEncodeMap = new CharKeyOpenHashMap();
    private static final CharKeyOpenHashMap<String> mXmlEncodeMap = new CharKeyOpenHashMap();
    private static final CharKeyOpenHashMap<String> mStringEncodeMap = new CharKeyOpenHashMap();
    private static final CharKeyOpenHashMap<String> mSqlEncodeMap = new CharKeyOpenHashMap();
    private static final CharKeyOpenHashMap<String> mLatexEncodeMap = new CharKeyOpenHashMap();

    public static String encodeClassname(String name) {
        if (name == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("[^\\w]");
        Matcher matcher = pattern.matcher(name);
        String result = matcher.replaceAll("_");
        return result;
    }

    private static boolean needsUrlEncoding(String source) {
        if (source == null) {
            return false;
        }
        boolean encode = false;
        int i = 0;
        while (i < source.length()) {
            char ch = source.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == '.' || ch == '*')) {
                encode = true;
                break;
            }
            ++i;
        }
        return encode;
    }

    public static String encodeUrl(String source) {
        if (!StringUtils.needsUrlEncoding(source)) {
            return source;
        }
        try {
            return URLEncoder.encode(source, ENCODING_ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encodeUrlValue(String source) {
        if (!StringUtils.needsUrlEncoding(source)) {
            return source;
        }
        boolean valid = true;
        CharsetEncoder encoder = CHARSET_US_ASCII.newEncoder();
        try {
            encoder.encode(CharBuffer.wrap(source));
        }
        catch (CharacterCodingException e) {
            valid = false;
        }
        try {
            StringBuffer encoded;
            if (valid) {
                return URLEncoder.encode(source, ENCODING_US_ASCII);
            }
            StringBuffer stringBuffer = encoded = new StringBuffer("%02%02");
            synchronized (stringBuffer) {
                String base64 = Base64.encodeToString(source.getBytes(ENCODING_UTF_8), false);
                String base64_urlsafe = StringUtils.replace(base64, "=", "%3D");
                encoded.append(base64_urlsafe);
                return encoded.toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String decodeUrlValue(String source) {
        try {
            byte[] decoded = Base64.decode(source.substring(2));
            if (decoded == null) {
                return null;
            }
            return new String(decoded, ENCODING_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean doesUrlValueNeedDecoding(String source) {
        return source != null && source.length() > 2 && source.startsWith("\u0002\u0002");
    }

    public static String encodeHtml(String source) {
        return StringUtils.encode(source, new CharKeyOpenHashMap[]{mAggressiveHtmlEncodeMap, mDefensiveHtmlEncodeMap});
    }

    public static String encodeHtmlDefensive(String source) {
        return StringUtils.encode(source, new CharKeyOpenHashMap[]{mDefensiveHtmlEncodeMap});
    }

    public static String encodeXml(String source) {
        return StringUtils.encode(source, new CharKeyOpenHashMap[]{mXmlEncodeMap});
    }

    public static String encodeString(String source) {
        return StringUtils.encode(source, new CharKeyOpenHashMap[]{mStringEncodeMap});
    }

    public static String encodeUnicode(String source) {
        if (source == null) {
            return null;
        }
        StringBuffer encoded = new StringBuffer();
        String hexstring = null;
        StringBuffer stringBuffer = encoded;
        synchronized (stringBuffer) {
            int i = 0;
            while (i < source.length()) {
                hexstring = Integer.toHexString(source.charAt(i)).toUpperCase();
                encoded.append("\\u");
                int j = hexstring.length();
                while (j < 4) {
                    encoded.append("0");
                    ++j;
                }
                encoded.append(hexstring);
                ++i;
            }
            return encoded.toString();
        }
    }

    public static String encodeSql(String source) {
        return StringUtils.encode(source, new CharKeyOpenHashMap[]{mSqlEncodeMap});
    }

    public static String encodeLatex(String source) {
        if (source == null) {
            return null;
        }
        source = StringUtils.encode(source, new CharKeyOpenHashMap[]{mLatexEncodeMap});
        source = StringUtils.replace(source, "latex", "\\LaTeX", false);
        return source;
    }

    private static String encode(String source, CharKeyOpenHashMap[] encodingTables) {
        if (source == null) {
            return null;
        }
        if (encodingTables == null || 0 == encodingTables.length) {
            return source;
        }
        StringBuffer encoded_string = null;
        char[] string_to_encode_array = source.toCharArray();
        int last_match = -1;
        int difference = 0;
        int i = 0;
        while (i < string_to_encode_array.length) {
            char char_to_encode = string_to_encode_array[i];
            CharKeyOpenHashMap[] charKeyOpenHashMapArray = encodingTables;
            int n = 0;
            while (n < charKeyOpenHashMapArray.length) {
                CharKeyOpenHashMap encoding_table = charKeyOpenHashMapArray[n];
                if (encoding_table.containsKey(char_to_encode)) {
                    if (encoded_string == null) {
                        encoded_string = new StringBuffer(source.length());
                    }
                    if ((difference = i - (last_match + 1)) > 0) {
                        encoded_string.append(string_to_encode_array, last_match + 1, difference);
                    }
                    encoded_string.append(encoding_table.get(char_to_encode));
                    last_match = i;
                }
                ++n;
            }
            ++i;
        }
        if (encoded_string == null) {
            return source;
        }
        difference = string_to_encode_array.length - (last_match + 1);
        if (difference > 0) {
            encoded_string.append(string_to_encode_array, last_match + 1, difference);
        }
        return encoded_string.toString();
    }

    public static int count(String source, String substring) {
        return StringUtils.count(source, substring, true);
    }

    public static int count(String source, String substring, boolean matchCase) {
        if (source == null) {
            return 0;
        }
        if (substring == null) {
            return 0;
        }
        int current_index = 0;
        int substring_index = 0;
        int count = 0;
        if (!matchCase) {
            source = source.toLowerCase();
            substring = substring.toLowerCase();
        }
        while (current_index < source.length() - 1) {
            substring_index = source.indexOf(substring, current_index);
            if (-1 == substring_index) break;
            current_index = substring_index + substring.length();
            ++count;
        }
        return count;
    }

    public static ArrayList<String> split(String source, String seperator) {
        return StringUtils.split(source, seperator, true);
    }

    public static ArrayList<String> split(String source, String seperator, boolean matchCase) {
        ArrayList<String> substrings = new ArrayList<String>();
        if (source == null) {
            return substrings;
        }
        if (seperator == null) {
            substrings.add(source);
            return substrings;
        }
        int current_index = 0;
        int delimiter_index = 0;
        String element = null;
        String source_lookup_reference = null;
        if (!matchCase) {
            source_lookup_reference = source.toLowerCase();
            seperator = seperator.toLowerCase();
        } else {
            source_lookup_reference = source;
        }
        while (current_index <= source_lookup_reference.length()) {
            delimiter_index = source_lookup_reference.indexOf(seperator, current_index);
            if (-1 == delimiter_index) {
                element = new String(source.substring(current_index, source.length()));
                substrings.add(element);
                current_index = source.length() + 1;
                continue;
            }
            element = new String(source.substring(current_index, delimiter_index));
            substrings.add(element);
            current_index = delimiter_index + seperator.length();
        }
        return substrings;
    }

    public static String[] splitToArray(String source, String seperator) {
        return StringUtils.splitToArray(source, seperator, true);
    }

    public static String[] splitToArray(String source, String seperator, boolean matchCase) {
        ArrayList<String> substrings = StringUtils.split(source, seperator, matchCase);
        String[] substrings_array = new String[substrings.size()];
        substrings_array = substrings.toArray(substrings_array);
        return substrings_array;
    }

    public static int[] splitToIntArray(String source, String seperator) {
        return StringUtils.splitToIntArray(source, seperator, true);
    }

    public static int[] splitToIntArray(String source, String seperator, boolean matchCase) {
        ArrayList<String> string_parts = StringUtils.split(source, seperator, matchCase);
        int number_of_valid_parts = 0;
        for (String string_part : (Collection)string_parts) {
            try {
                Integer.parseInt(string_part);
                ++number_of_valid_parts;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int[] string_parts_int = (int[])Array.newInstance(Integer.TYPE, number_of_valid_parts);
        int added_parts = 0;
        for (String string_part : (Collection)string_parts) {
            try {
                string_parts_int[added_parts] = Integer.parseInt(string_part);
                ++added_parts;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return string_parts_int;
    }

    public static byte[] splitToByteArray(String source, String seperator) {
        return StringUtils.splitToByteArray(source, seperator, true);
    }

    public static byte[] splitToByteArray(String source, String seperator, boolean matchCase) {
        ArrayList<String> string_parts = StringUtils.split(source, seperator, matchCase);
        int number_of_valid_parts = 0;
        for (String string_part : (Collection)string_parts) {
            try {
                Byte.parseByte(string_part);
                ++number_of_valid_parts;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        byte[] string_parts_byte = (byte[])Array.newInstance(Byte.TYPE, number_of_valid_parts);
        int added_parts = 0;
        for (String string_part : (Collection)string_parts) {
            try {
                string_parts_byte[added_parts] = Byte.parseByte(string_part);
                ++added_parts;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return string_parts_byte;
    }

    public static String stripFromFront(String source, String stringToStrip) {
        return StringUtils.stripFromFront(source, stringToStrip, true);
    }

    public static String stripFromFront(String source, String stringToStrip, boolean matchCase) {
        if (source == null) {
            return null;
        }
        if (stringToStrip == null) {
            return source;
        }
        int strip_length = stringToStrip.length();
        int new_index = 0;
        int last_index = 0;
        String source_lookup_reference = null;
        if (!matchCase) {
            source_lookup_reference = source.toLowerCase();
            stringToStrip = stringToStrip.toLowerCase();
        } else {
            source_lookup_reference = source;
        }
        new_index = source_lookup_reference.indexOf(stringToStrip);
        if (0 == new_index) {
            do {
                last_index = new_index;
            } while ((new_index = source_lookup_reference.indexOf(stringToStrip, new_index + strip_length)) != -1 && new_index == last_index + strip_length);
            return source.substring(last_index + strip_length);
        }
        return source;
    }

    public static String stripFromEnd(String source, String stringToStrip) {
        return StringUtils.stripFromEnd(source, stringToStrip, true);
    }

    public static String stripFromEnd(String source, String stringToStrip, boolean matchCase) {
        if (source == null) {
            return null;
        }
        if (stringToStrip == null) {
            return source;
        }
        int strip_length = stringToStrip.length();
        int new_index = 0;
        int last_index = 0;
        String source_lookup_reference = null;
        if (!matchCase) {
            source_lookup_reference = source.toLowerCase();
            stringToStrip = stringToStrip.toLowerCase();
        } else {
            source_lookup_reference = source;
        }
        new_index = source_lookup_reference.lastIndexOf(stringToStrip);
        if (new_index != -1 && source.length() == new_index + strip_length) {
            while ((new_index = source_lookup_reference.lastIndexOf(stringToStrip, (last_index = new_index) - 1)) != -1 && new_index == last_index - strip_length) {
            }
            return source.substring(0, last_index);
        }
        return source;
    }

    public static String replace(String source, String stringToReplace, String replacementString) {
        return StringUtils.replace(source, stringToReplace, replacementString, true);
    }

    public static String replace(String source, String stringToReplace, String replacementString, boolean matchCase) {
        StringBuffer new_string;
        if (source == null) {
            return null;
        }
        if (stringToReplace == null) {
            return source;
        }
        if (replacementString == null) {
            return source;
        }
        Iterator<String> string_parts = StringUtils.split(source, stringToReplace, matchCase).iterator();
        StringBuffer stringBuffer = new_string = new StringBuffer();
        synchronized (stringBuffer) {
            while (string_parts.hasNext()) {
                String string_part = string_parts.next();
                new_string.append(string_part);
                if (!string_parts.hasNext()) continue;
                new_string.append(replacementString);
            }
            return new_string.toString();
        }
    }

    public static String repeat(String source, int count) {
        StringBuffer new_string;
        if (source == null) {
            return null;
        }
        StringBuffer stringBuffer = new_string = new StringBuffer();
        synchronized (stringBuffer) {
            while (count > 0) {
                new_string.append(source);
                --count;
            }
            return new_string.toString();
        }
    }

    public static String[] toStringArray(Iterator<String> iterator) {
        if (iterator == null) {
            return new String[0];
        }
        ArrayList<String> strings = new ArrayList<String>();
        while (iterator.hasNext()) {
            strings.add(iterator.next());
        }
        String[] string_array = new String[strings.size()];
        strings.toArray(string_array);
        return string_array;
    }

    public static ArrayList<String> toArrayList(String[] stringArray) {
        ArrayList<String> strings = new ArrayList<String>();
        if (stringArray == null) {
            return strings;
        }
        String[] stringArray2 = stringArray;
        int n = 0;
        while (n < stringArray2.length) {
            String element = stringArray2[n];
            strings.add(element);
            ++n;
        }
        return strings;
    }

    public static String join(Collection collection, String seperator) {
        StringBuffer result;
        if (collection == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (0 == collection.size()) {
            return "";
        }
        StringBuffer stringBuffer = result = new StringBuffer();
        synchronized (stringBuffer) {
            for (Object element : collection) {
                result.append(String.valueOf(element));
                result.append(seperator);
            }
            result.setLength(result.length() - seperator.length());
            return result.toString();
        }
    }

    public static String join(Object[] array, String seperator) {
        return StringUtils.join(array, seperator, null, false);
    }

    public static String join(Object[] array, String seperator, String delimiter) {
        return StringUtils.join(array, seperator, delimiter, false);
    }

    public static String join(Object[] array, String seperator, String delimiter, boolean encodeStrings) {
        StringBuffer result;
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        String array_value = null;
        StringBuffer stringBuffer = result = new StringBuffer();
        synchronized (stringBuffer) {
            while (current_index < array.length - 1) {
                if (array[current_index] == null) {
                    result.append("null");
                } else {
                    array_value = String.valueOf(array[current_index]);
                    if (encodeStrings) {
                        array_value = StringUtils.encodeString(array_value);
                    }
                    result.append(delimiter);
                    result.append(array_value);
                    result.append(delimiter);
                }
                result.append(seperator);
                ++current_index;
            }
            if (array[current_index] == null) {
                result.append("null");
            } else {
                array_value = String.valueOf(array[current_index]);
                if (encodeStrings) {
                    array_value = StringUtils.encodeString(array_value);
                }
                result.append(delimiter);
                result.append(array_value);
                result.append(delimiter);
            }
            return result.toString();
        }
    }

    public static String join(boolean[] array, String seperator) {
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        String result = "";
        while (current_index < array.length - 1) {
            result = new StringBuffer().append(new StringBuffer().append(result).append(array[current_index]).toString()).append(seperator).toString();
            ++current_index;
        }
        result = new StringBuffer().append(result).append(array[current_index]).toString();
        return result;
    }

    public static String join(byte[] array, String seperator) {
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        String result = "";
        while (current_index < array.length - 1) {
            result = new StringBuffer().append(new StringBuffer().append(result).append(array[current_index]).toString()).append(seperator).toString();
            ++current_index;
        }
        result = new StringBuffer().append(result).append(array[current_index]).toString();
        return result;
    }

    public static String join(double[] array, String seperator) {
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        String result = "";
        while (current_index < array.length - 1) {
            result = new StringBuffer().append(new StringBuffer().append(result).append(array[current_index]).toString()).append(seperator).toString();
            ++current_index;
        }
        result = new StringBuffer().append(result).append(array[current_index]).toString();
        return result;
    }

    public static String join(float[] array, String seperator) {
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        String result = "";
        while (current_index < array.length - 1) {
            result = new StringBuffer().append(new StringBuffer().append(result).append(array[current_index]).toString()).append(seperator).toString();
            ++current_index;
        }
        result = new StringBuffer().append(result).append(array[current_index]).toString();
        return result;
    }

    public static String join(int[] array, String seperator) {
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        String result = "";
        while (current_index < array.length - 1) {
            result = new StringBuffer().append(new StringBuffer().append(result).append(array[current_index]).toString()).append(seperator).toString();
            ++current_index;
        }
        result = new StringBuffer().append(result).append(array[current_index]).toString();
        return result;
    }

    public static String join(long[] array, String seperator) {
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        String result = "";
        while (current_index < array.length - 1) {
            result = new StringBuffer().append(new StringBuffer().append(result).append(array[current_index]).toString()).append(seperator).toString();
            ++current_index;
        }
        result = new StringBuffer().append(result).append(array[current_index]).toString();
        return result;
    }

    public static String join(short[] array, String seperator) {
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        String result = "";
        while (current_index < array.length - 1) {
            result = new StringBuffer().append(new StringBuffer().append(result).append(array[current_index]).toString()).append(seperator).toString();
            ++current_index;
        }
        result = new StringBuffer().append(result).append(array[current_index]).toString();
        return result;
    }

    public static String join(char[] array, String seperator) {
        return StringUtils.join(array, seperator, null);
    }

    public static String join(char[] array, String seperator, String delimiter) {
        StringBuffer result;
        if (array == null) {
            return null;
        }
        if (seperator == null) {
            seperator = "";
        }
        if (delimiter == null) {
            delimiter = "";
        }
        if (0 == array.length) {
            return "";
        }
        int current_index = 0;
        StringBuffer stringBuffer = result = new StringBuffer();
        synchronized (stringBuffer) {
            while (current_index < array.length - 1) {
                result.append(delimiter);
                result.append(array[current_index]);
                result.append(delimiter);
                result.append(seperator);
                ++current_index;
            }
            result.append(delimiter);
            result.append(String.valueOf(array[current_index]));
            result.append(delimiter);
            return result.toString();
        }
    }

    public static int[] indicesOf(String source, String substring) {
        return StringUtils.indicesOf(source, substring, true);
    }

    public static int[] indicesOf(String source, String substring, boolean matchCase) {
        if (source == null || substring == null) {
            return new int[0];
        }
        String source_lookup_reference = null;
        if (!matchCase) {
            source_lookup_reference = source.toLowerCase();
            substring = substring.toLowerCase();
        } else {
            source_lookup_reference = source;
        }
        int current_index = 0;
        int substring_index = 0;
        int count = StringUtils.count(source_lookup_reference, substring);
        int[] indices = new int[count];
        int counter = 0;
        while (current_index < source.length() - 1) {
            substring_index = source_lookup_reference.indexOf(substring, current_index);
            if (-1 == substring_index) break;
            current_index = substring_index + substring.length();
            indices[counter] = substring_index;
            ++counter;
        }
        return indices;
    }

    public static Matcher getMatchingRegexp(String value, Collection<Pattern> regexps) {
        if (value != null && value.length() > 0 && regexps != null && regexps.size() > 0) {
            Matcher matcher = null;
            for (Pattern regexp : regexps) {
                matcher = regexp.matcher(value);
                if (!matcher.matches()) continue;
                return matcher;
            }
        }
        return null;
    }

    public static Matcher getRegexpMatch(Collection<String> values, Pattern regexp) {
        if (values != null && values.size() > 0 && regexp != null) {
            Matcher matcher = null;
            for (String value : values) {
                matcher = regexp.matcher(value);
                if (!matcher.matches()) continue;
                return matcher;
            }
        }
        return null;
    }

    public static boolean filter(String name, Pattern included, Pattern excluded) {
        Pattern[] included_array = null;
        if (included != null) {
            included_array = new Pattern[]{included};
        }
        Pattern[] excluded_array = null;
        if (excluded != null) {
            excluded_array = new Pattern[]{excluded};
        }
        return StringUtils.filter(name, included_array, excluded_array);
    }

    public static boolean filter(String name, Pattern[] included, Pattern[] excluded) {
        Pattern pattern;
        int n;
        Pattern[] patternArray;
        if (name == null) {
            return false;
        }
        boolean accepted = false;
        if (included == null) {
            accepted = true;
        } else {
            patternArray = included;
            n = 0;
            while (n < patternArray.length) {
                pattern = patternArray[n];
                if (pattern != null && pattern.matcher(name).matches()) {
                    accepted = true;
                    break;
                }
                ++n;
            }
        }
        if (accepted && excluded != null) {
            patternArray = excluded;
            n = 0;
            while (n < patternArray.length) {
                pattern = patternArray[n];
                if (pattern != null && pattern.matcher(name).matches()) {
                    accepted = false;
                    break;
                }
                ++n;
            }
        }
        return accepted;
    }

    public static String capitalize(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        if (source.length() > 1 && Character.isUpperCase(source.charAt(0))) {
            return source;
        }
        char[] chars = source.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private static String convertUrl(String source, Pattern pattern, boolean shorten, boolean sanitize, boolean no_follow) {
        int max_length = RifeConfig.Tools.getMaxVisualUrlLength();
        String result = source;
        Matcher url_matcher = pattern.matcher(source);
        boolean found = url_matcher.find();
        if (found) {
            StringBuffer sb;
            String visual_url = null;
            String actual_url = null;
            int last = 0;
            StringBuffer stringBuffer = sb = new StringBuffer();
            synchronized (stringBuffer) {
                do {
                    actual_url = url_matcher.group(1);
                    visual_url = url_matcher.groupCount() > 1 ? url_matcher.group(2) : actual_url;
                    if (sanitize && (actual_url = StringUtils.replace(actual_url, "javascript:", "")).indexOf("://") == -1 && !actual_url.startsWith("/")) {
                        actual_url = new StringBuffer().append("http://").append(actual_url).toString();
                    }
                    if (pattern.equals(BBCODE_BAREURL)) {
                        sb.append(source.substring(last, url_matcher.start(1)));
                    } else {
                        sb.append(source.substring(last, url_matcher.start(0)));
                    }
                    sb.append("<a href=\"");
                    sb.append(actual_url);
                    sb.append("\"");
                    if (actual_url.startsWith("http://") || actual_url.startsWith("https://")) {
                        sb.append(" target=\"_blank\"");
                    }
                    if (no_follow) {
                        sb.append(" rel=\"nofollow\"");
                    }
                    sb.append(">");
                    if (visual_url.length() <= max_length || !shorten) {
                        sb.append(visual_url);
                    } else {
                        int start_slash;
                        int last_slash;
                        String ellipsis = "...";
                        int query_index = visual_url.indexOf("?");
                        if (query_index != -1) {
                            visual_url = new StringBuffer().append(visual_url.substring(0, query_index + 1)).append(ellipsis).toString();
                        }
                        if (visual_url.length() >= max_length && (last_slash = visual_url.lastIndexOf("/")) != (start_slash = visual_url.indexOf("/", visual_url.indexOf("://") + 3))) {
                            visual_url = new StringBuffer().append(new StringBuffer().append(visual_url.substring(0, start_slash + 1)).append(ellipsis).toString()).append(visual_url.substring(last_slash)).toString();
                        }
                        sb.append(visual_url);
                    }
                    sb.append("</a>");
                    last = pattern.equals(BBCODE_BAREURL) ? url_matcher.end(1) : url_matcher.end(0);
                } while (found = url_matcher.find());
                sb.append(source.substring(last));
                result = sb.toString();
            }
        }
        return result;
    }

    public static String convertBbcode(String source) {
        if (source == null) {
            return null;
        }
        return StringUtils.convertBbcode(source, null);
    }

    /*
     * WARNING - void declaration
     */
    public static String convertBbcode(String source, BbcodeOption[] options) {
        int startindex;
        if (source == null) {
            return null;
        }
        boolean shorten = false;
        boolean sanitize = false;
        boolean convert_bare = false;
        boolean no_follow_links = false;
        if (options != null) {
            BbcodeOption[] bbcodeOptionArray = options;
            int n = 0;
            while (n < bbcodeOptionArray.length) {
                BbcodeOption option = bbcodeOptionArray[n];
                if (option.equals(SHORTEN_URL)) {
                    shorten = true;
                } else if (option.equals(SANITIZE_URL)) {
                    sanitize = true;
                } else if (option.equals(CONVERT_BARE_URLS)) {
                    convert_bare = true;
                } else if (option.equals(NO_FOLLOW_LINKS)) {
                    no_follow_links = true;
                }
                ++n;
            }
        }
        String sourcecopy = source;
        StringBuffer result = new StringBuffer(source.length());
        while (-1 != (startindex = sourcecopy.indexOf("[code]"))) {
            void option;
            String parsed = sourcecopy.substring(0, (int)option);
            int endIndex = sourcecopy.indexOf("[/code]") + 7;
            String code = sourcecopy.substring((int)option, endIndex);
            parsed = StringUtils.parseBBCode(parsed, shorten, sanitize, convert_bare, no_follow_links);
            code = StringUtils.replace(code, "[code]", "<div class=\"codebody\"><pre>", false);
            code = StringUtils.replace(code, "[/code]", "</pre></div>", false);
            result.append(parsed).append(code);
            sourcecopy = sourcecopy.substring(endIndex);
        }
        result.append(StringUtils.parseBBCode(sourcecopy, shorten, sanitize, convert_bare, no_follow_links));
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String parseBBCode(String source, boolean shorten, boolean sanitize, boolean convert_bare, boolean no_follow) {
        StringBuffer buffer;
        String result = source;
        result = StringUtils.replace(result, "[b]", "<b>", false);
        result = StringUtils.replace(result, "[/b]", "</b>", false);
        result = StringUtils.replace(result, "[u]", "<u>", false);
        result = StringUtils.replace(result, "[/u]", "</u>", false);
        result = StringUtils.replace(result, "[i]", "<i>", false);
        String resultCopy = result = StringUtils.replace(result, "[/i]", "</i>", false);
        String resultLowerCopy = result.toLowerCase();
        StringBuffer stringBuffer = buffer = new StringBuffer();
        synchronized (stringBuffer) {
            int startIndex;
            while (-1 != (startIndex = resultLowerCopy.indexOf("[*]"))) {
                void var11_10;
                int begin = resultLowerCopy.indexOf("[list]", (int)(var11_10 + 3));
                int end = resultLowerCopy.indexOf("[/list]", (int)(var11_10 + 3));
                int next = resultLowerCopy.indexOf("[*]", (int)(var11_10 + 3));
                if (begin == -1) {
                    begin = Integer.MAX_VALUE;
                }
                if (end == -1) {
                    end = Integer.MAX_VALUE;
                }
                if (next == -1) {
                    next = Integer.MAX_VALUE;
                }
                int endIndex = next < begin && next < end ? next : (begin < next && begin < end ? begin : (end < next && end < begin ? end : resultLowerCopy.length()));
                buffer.append(resultCopy.substring(0, (int)var11_10)).append("<li>").append(resultCopy.substring((int)(var11_10 + 3), endIndex)).append("</li>");
                resultCopy = resultCopy.substring(endIndex);
                resultLowerCopy = resultLowerCopy.substring(endIndex);
            }
            buffer.append(resultCopy.substring(0));
            result = buffer.toString();
        }
        result = StringUtils.replace(result, "[list]", "<ul>", false);
        result = StringUtils.replace(result, "[/list]", "</ul>", false);
        Matcher color_matcher = BBCODE_COLOR.matcher(result);
        result = color_matcher.replaceAll("<font color=\"$1\">");
        result = StringUtils.replace(result, "[/color]", "</font>", false);
        Matcher size_matcher = BBCODE_SIZE.matcher(result);
        result = size_matcher.replaceAll("<font size=\"$1\">");
        result = StringUtils.replace(result, "[/size]", "</font>", false);
        result = StringUtils.convertUrl(result, BBCODE_URL_SHORT, shorten, sanitize, no_follow);
        result = StringUtils.convertUrl(result, BBCODE_URL_LONG, shorten, sanitize, no_follow);
        if (convert_bare) {
            result = StringUtils.convertUrl(result, BBCODE_BAREURL, shorten, sanitize, no_follow);
        }
        Matcher img_matcher = BBCODE_IMG.matcher(result);
        result = img_matcher.replaceAll("<div class=\"bbcode_img\"><img src=\"$1\" border=\"0\" /></div>");
        Matcher quote_matcher_long = BBCODE_QUOTE_LONG.matcher(result);
        result = quote_matcher_long.replaceAll("<div class=\"quoteaccount\">$1:</div><div class=\"quotebody\">");
        result = StringUtils.replace(result, "[quote]", "<div class=\"quotebody\">", false);
        result = StringUtils.replace(result, "[/quote]", "</div>", false);
        result = StringUtils.replace(result, "\r\n", "<br />\r");
        result = StringUtils.replace(result, "\n", "<br />\n");
        result = StringUtils.replace(result, "\r", "\r\n");
        result = StringUtils.replace(result, "ul><br />\r\n", "ul>\r\n");
        result = StringUtils.replace(result, "ul><br />\n", "ul>\n");
        return result;
    }

    public static boolean convertToBoolean(String value) {
        if (value == null) {
            return false;
        }
        return value.equals("1") || value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("y") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on");
    }

    public static String convertTabsToSpaces(String line, int tabWidth) {
        StringBuffer result;
        StringBuffer stringBuffer = result = new StringBuffer();
        synchronized (stringBuffer) {
            int tab_index = -1;
            int last_tab_index = 0;
            int added_chars = 0;
            while ((tab_index = line.indexOf("\t", last_tab_index)) != -1) {
                int tab_size = tabWidth - (tab_index + added_chars) % tabWidth;
                if (0 == tab_size) {
                    tab_size = tabWidth;
                }
                added_chars += tab_size - 1;
                result.append(line.substring(last_tab_index, tab_index));
                result.append(StringUtils.repeat(" ", tab_size));
                last_tab_index = tab_index + 1;
            }
            if (0 == last_tab_index) {
                return line;
            }
            result.append(line.substring(last_tab_index));
        }
        return result.toString();
    }

    public static String trim(String source) {
        if (source == null || source.length() == 0) {
            return source;
        }
        return source.trim();
    }

    static {
        mAggressiveHtmlEncodeMap.put('&', "&amp;");
        mAggressiveHtmlEncodeMap.put('<', "&lt;");
        mAggressiveHtmlEncodeMap.put('>', "&gt;");
        mAggressiveHtmlEncodeMap.put('\"', "&quot;");
        mDefensiveHtmlEncodeMap.put('\u0152', "&OElig;");
        mDefensiveHtmlEncodeMap.put('\u0153', "&oelig;");
        mDefensiveHtmlEncodeMap.put('\u0160', "&Scaron;");
        mDefensiveHtmlEncodeMap.put('\u0161', "&scaron;");
        mDefensiveHtmlEncodeMap.put('\u0178', "&Yuml;");
        mDefensiveHtmlEncodeMap.put('\u02c6', "&circ;");
        mDefensiveHtmlEncodeMap.put('\u02dc', "&tilde;");
        mDefensiveHtmlEncodeMap.put('\u2002', "&ensp;");
        mDefensiveHtmlEncodeMap.put('\u2003', "&emsp;");
        mDefensiveHtmlEncodeMap.put('\u2009', "&thinsp;");
        mDefensiveHtmlEncodeMap.put('\u200c', "&zwnj;");
        mDefensiveHtmlEncodeMap.put('\u200d', "&zwj;");
        mDefensiveHtmlEncodeMap.put('\u200e', "&lrm;");
        mDefensiveHtmlEncodeMap.put('\u200f', "&rlm;");
        mDefensiveHtmlEncodeMap.put('\u2013', "&ndash;");
        mDefensiveHtmlEncodeMap.put('\u2014', "&mdash;");
        mDefensiveHtmlEncodeMap.put('\u2018', "&lsquo;");
        mDefensiveHtmlEncodeMap.put('\u2019', "&rsquo;");
        mDefensiveHtmlEncodeMap.put('\u201a', "&sbquo;");
        mDefensiveHtmlEncodeMap.put('\u201c', "&ldquo;");
        mDefensiveHtmlEncodeMap.put('\u201d', "&rdquo;");
        mDefensiveHtmlEncodeMap.put('\u201e', "&bdquo;");
        mDefensiveHtmlEncodeMap.put('\u2020', "&dagger;");
        mDefensiveHtmlEncodeMap.put('\u2021', "&Dagger;");
        mDefensiveHtmlEncodeMap.put('\u2030', "&permil;");
        mDefensiveHtmlEncodeMap.put('\u2039', "&lsaquo;");
        mDefensiveHtmlEncodeMap.put('\u203a', "&rsaquo;");
        mDefensiveHtmlEncodeMap.put('\u20ac', "&euro;");
        mDefensiveHtmlEncodeMap.put('\u00a0', "&nbsp;");
        mDefensiveHtmlEncodeMap.put('\u00a1', "&iexcl;");
        mDefensiveHtmlEncodeMap.put('\u00a2', "&cent;");
        mDefensiveHtmlEncodeMap.put('\u00a3', "&pound;");
        mDefensiveHtmlEncodeMap.put('\u00a4', "&curren;");
        mDefensiveHtmlEncodeMap.put('\u00a5', "&yen;");
        mDefensiveHtmlEncodeMap.put('\u00a6', "&brvbar;");
        mDefensiveHtmlEncodeMap.put('\u00a7', "&sect;");
        mDefensiveHtmlEncodeMap.put('\u00a8', "&uml;");
        mDefensiveHtmlEncodeMap.put('\u00a9', "&copy;");
        mDefensiveHtmlEncodeMap.put('\u00aa', "&ordf;");
        mDefensiveHtmlEncodeMap.put('\u00ab', "&laquo;");
        mDefensiveHtmlEncodeMap.put('\u00ac', "&not;");
        mDefensiveHtmlEncodeMap.put('\u00ad', "&shy;");
        mDefensiveHtmlEncodeMap.put('\u00ae', "&reg;");
        mDefensiveHtmlEncodeMap.put('\u00af', "&macr;");
        mDefensiveHtmlEncodeMap.put('\u00b0', "&deg;");
        mDefensiveHtmlEncodeMap.put('\u00b1', "&plusmn;");
        mDefensiveHtmlEncodeMap.put('\u00b2', "&sup2;");
        mDefensiveHtmlEncodeMap.put('\u00b3', "&sup3;");
        mDefensiveHtmlEncodeMap.put('\u00b4', "&acute;");
        mDefensiveHtmlEncodeMap.put('\u00b5', "&micro;");
        mDefensiveHtmlEncodeMap.put('\u00b6', "&para;");
        mDefensiveHtmlEncodeMap.put('\u00b7', "&middot;");
        mDefensiveHtmlEncodeMap.put('\u00b8', "&cedil;");
        mDefensiveHtmlEncodeMap.put('\u00b9', "&sup1;");
        mDefensiveHtmlEncodeMap.put('\u00ba', "&ordm;");
        mDefensiveHtmlEncodeMap.put('\u00bb', "&raquo;");
        mDefensiveHtmlEncodeMap.put('\u00bc', "&frac14;");
        mDefensiveHtmlEncodeMap.put('\u00bd', "&frac12;");
        mDefensiveHtmlEncodeMap.put('\u00be', "&frac34;");
        mDefensiveHtmlEncodeMap.put('\u00bf', "&iquest;");
        mDefensiveHtmlEncodeMap.put('\u00c0', "&Agrave;");
        mDefensiveHtmlEncodeMap.put('\u00c1', "&Aacute;");
        mDefensiveHtmlEncodeMap.put('\u00c2', "&Acirc;");
        mDefensiveHtmlEncodeMap.put('\u00c3', "&Atilde;");
        mDefensiveHtmlEncodeMap.put('\u00c4', "&Auml;");
        mDefensiveHtmlEncodeMap.put('\u00c5', "&Aring;");
        mDefensiveHtmlEncodeMap.put('\u00c6', "&AElig;");
        mDefensiveHtmlEncodeMap.put('\u00c7', "&Ccedil;");
        mDefensiveHtmlEncodeMap.put('\u00c8', "&Egrave;");
        mDefensiveHtmlEncodeMap.put('\u00c9', "&Eacute;");
        mDefensiveHtmlEncodeMap.put('\u00ca', "&Ecirc;");
        mDefensiveHtmlEncodeMap.put('\u00cb', "&Euml;");
        mDefensiveHtmlEncodeMap.put('\u00cc', "&Igrave;");
        mDefensiveHtmlEncodeMap.put('\u00cd', "&Iacute;");
        mDefensiveHtmlEncodeMap.put('\u00ce', "&Icirc;");
        mDefensiveHtmlEncodeMap.put('\u00cf', "&Iuml;");
        mDefensiveHtmlEncodeMap.put('\u00d0', "&ETH;");
        mDefensiveHtmlEncodeMap.put('\u00d1', "&Ntilde;");
        mDefensiveHtmlEncodeMap.put('\u00d2', "&Ograve;");
        mDefensiveHtmlEncodeMap.put('\u00d3', "&Oacute;");
        mDefensiveHtmlEncodeMap.put('\u00d4', "&Ocirc;");
        mDefensiveHtmlEncodeMap.put('\u00d5', "&Otilde;");
        mDefensiveHtmlEncodeMap.put('\u00d6', "&Ouml;");
        mDefensiveHtmlEncodeMap.put('\u00d7', "&times;");
        mDefensiveHtmlEncodeMap.put('\u00d8', "&Oslash;");
        mDefensiveHtmlEncodeMap.put('\u00d9', "&Ugrave;");
        mDefensiveHtmlEncodeMap.put('\u00da', "&Uacute;");
        mDefensiveHtmlEncodeMap.put('\u00db', "&Ucirc;");
        mDefensiveHtmlEncodeMap.put('\u00dc', "&Uuml;");
        mDefensiveHtmlEncodeMap.put('\u00dd', "&Yacute;");
        mDefensiveHtmlEncodeMap.put('\u00de', "&THORN;");
        mDefensiveHtmlEncodeMap.put('\u00df', "&szlig;");
        mDefensiveHtmlEncodeMap.put('\u00e0', "&agrave;");
        mDefensiveHtmlEncodeMap.put('\u00e1', "&aacute;");
        mDefensiveHtmlEncodeMap.put('\u00e2', "&acirc;");
        mDefensiveHtmlEncodeMap.put('\u00e3', "&atilde;");
        mDefensiveHtmlEncodeMap.put('\u00e4', "&auml;");
        mDefensiveHtmlEncodeMap.put('\u00e5', "&aring;");
        mDefensiveHtmlEncodeMap.put('\u00e6', "&aelig;");
        mDefensiveHtmlEncodeMap.put('\u00e7', "&ccedil;");
        mDefensiveHtmlEncodeMap.put('\u00e8', "&egrave;");
        mDefensiveHtmlEncodeMap.put('\u00e9', "&eacute;");
        mDefensiveHtmlEncodeMap.put('\u00ea', "&ecirc;");
        mDefensiveHtmlEncodeMap.put('\u00eb', "&euml;");
        mDefensiveHtmlEncodeMap.put('\u00ec', "&igrave;");
        mDefensiveHtmlEncodeMap.put('\u00ed', "&iacute;");
        mDefensiveHtmlEncodeMap.put('\u00ee', "&icirc;");
        mDefensiveHtmlEncodeMap.put('\u00ef', "&iuml;");
        mDefensiveHtmlEncodeMap.put('\u00f0', "&eth;");
        mDefensiveHtmlEncodeMap.put('\u00f1', "&ntilde;");
        mDefensiveHtmlEncodeMap.put('\u00f2', "&ograve;");
        mDefensiveHtmlEncodeMap.put('\u00f3', "&oacute;");
        mDefensiveHtmlEncodeMap.put('\u00f4', "&ocirc;");
        mDefensiveHtmlEncodeMap.put('\u00f5', "&otilde;");
        mDefensiveHtmlEncodeMap.put('\u00f6', "&ouml;");
        mDefensiveHtmlEncodeMap.put('\u00f7', "&divide;");
        mDefensiveHtmlEncodeMap.put('\u00f8', "&oslash;");
        mDefensiveHtmlEncodeMap.put('\u00f9', "&ugrave;");
        mDefensiveHtmlEncodeMap.put('\u00fa', "&uacute;");
        mDefensiveHtmlEncodeMap.put('\u00fb', "&ucirc;");
        mDefensiveHtmlEncodeMap.put('\u00fc', "&uuml;");
        mDefensiveHtmlEncodeMap.put('\u00fd', "&yacute;");
        mDefensiveHtmlEncodeMap.put('\u00fe', "&thorn;");
        mDefensiveHtmlEncodeMap.put('\u00ff', "&yuml;");
        mDefensiveHtmlEncodeMap.put('\u0192', "&fnof;");
        mDefensiveHtmlEncodeMap.put('\u0391', "&Alpha;");
        mDefensiveHtmlEncodeMap.put('\u0392', "&Beta;");
        mDefensiveHtmlEncodeMap.put('\u0393', "&Gamma;");
        mDefensiveHtmlEncodeMap.put('\u0394', "&Delta;");
        mDefensiveHtmlEncodeMap.put('\u0395', "&Epsilon;");
        mDefensiveHtmlEncodeMap.put('\u0396', "&Zeta;");
        mDefensiveHtmlEncodeMap.put('\u0397', "&Eta;");
        mDefensiveHtmlEncodeMap.put('\u0398', "&Theta;");
        mDefensiveHtmlEncodeMap.put('\u0399', "&Iota;");
        mDefensiveHtmlEncodeMap.put('\u039a', "&Kappa;");
        mDefensiveHtmlEncodeMap.put('\u039b', "&Lambda;");
        mDefensiveHtmlEncodeMap.put('\u039c', "&Mu;");
        mDefensiveHtmlEncodeMap.put('\u039d', "&Nu;");
        mDefensiveHtmlEncodeMap.put('\u039e', "&Xi;");
        mDefensiveHtmlEncodeMap.put('\u039f', "&Omicron;");
        mDefensiveHtmlEncodeMap.put('\u03a0', "&Pi;");
        mDefensiveHtmlEncodeMap.put('\u03a1', "&Rho;");
        mDefensiveHtmlEncodeMap.put('\u03a3', "&Sigma;");
        mDefensiveHtmlEncodeMap.put('\u03a4', "&Tau;");
        mDefensiveHtmlEncodeMap.put('\u03a5', "&Upsilon;");
        mDefensiveHtmlEncodeMap.put('\u03a6', "&Phi;");
        mDefensiveHtmlEncodeMap.put('\u03a7', "&Chi;");
        mDefensiveHtmlEncodeMap.put('\u03a8', "&Psi;");
        mDefensiveHtmlEncodeMap.put('\u03a9', "&Omega;");
        mDefensiveHtmlEncodeMap.put('\u03b1', "&alpha;");
        mDefensiveHtmlEncodeMap.put('\u03b2', "&beta;");
        mDefensiveHtmlEncodeMap.put('\u03b3', "&gamma;");
        mDefensiveHtmlEncodeMap.put('\u03b4', "&delta;");
        mDefensiveHtmlEncodeMap.put('\u03b5', "&epsilon;");
        mDefensiveHtmlEncodeMap.put('\u03b6', "&zeta;");
        mDefensiveHtmlEncodeMap.put('\u03b7', "&eta;");
        mDefensiveHtmlEncodeMap.put('\u03b8', "&theta;");
        mDefensiveHtmlEncodeMap.put('\u03b9', "&iota;");
        mDefensiveHtmlEncodeMap.put('\u03ba', "&kappa;");
        mDefensiveHtmlEncodeMap.put('\u03bb', "&lambda;");
        mDefensiveHtmlEncodeMap.put('\u03bc', "&mu;");
        mDefensiveHtmlEncodeMap.put('\u03bd', "&nu;");
        mDefensiveHtmlEncodeMap.put('\u03be', "&xi;");
        mDefensiveHtmlEncodeMap.put('\u03bf', "&omicron;");
        mDefensiveHtmlEncodeMap.put('\u03c0', "&pi;");
        mDefensiveHtmlEncodeMap.put('\u03c1', "&rho;");
        mDefensiveHtmlEncodeMap.put('\u03c2', "&sigmaf;");
        mDefensiveHtmlEncodeMap.put('\u03c3', "&sigma;");
        mDefensiveHtmlEncodeMap.put('\u03c4', "&tau;");
        mDefensiveHtmlEncodeMap.put('\u03c5', "&upsilon;");
        mDefensiveHtmlEncodeMap.put('\u03c6', "&phi;");
        mDefensiveHtmlEncodeMap.put('\u03c7', "&chi;");
        mDefensiveHtmlEncodeMap.put('\u03c8', "&psi;");
        mDefensiveHtmlEncodeMap.put('\u03c9', "&omega;");
        mDefensiveHtmlEncodeMap.put('\u03d1', "&thetasym;");
        mDefensiveHtmlEncodeMap.put('\u03d2', "&upsih;");
        mDefensiveHtmlEncodeMap.put('\u03d6', "&piv;");
        mDefensiveHtmlEncodeMap.put('\u2022', "&bull;");
        mDefensiveHtmlEncodeMap.put('\u2026', "&hellip;");
        mDefensiveHtmlEncodeMap.put('\u2032', "&prime;");
        mDefensiveHtmlEncodeMap.put('\u2033', "&Prime;");
        mDefensiveHtmlEncodeMap.put('\u203e', "&oline;");
        mDefensiveHtmlEncodeMap.put('\u2044', "&frasl;");
        mDefensiveHtmlEncodeMap.put('\u2118', "&weierp;");
        mDefensiveHtmlEncodeMap.put('\u2111', "&image;");
        mDefensiveHtmlEncodeMap.put('\u211c', "&real;");
        mDefensiveHtmlEncodeMap.put('\u2122', "&trade;");
        mDefensiveHtmlEncodeMap.put('\u2135', "&alefsym;");
        mDefensiveHtmlEncodeMap.put('\u2190', "&larr;");
        mDefensiveHtmlEncodeMap.put('\u2191', "&uarr;");
        mDefensiveHtmlEncodeMap.put('\u2192', "&rarr;");
        mDefensiveHtmlEncodeMap.put('\u2193', "&darr;");
        mDefensiveHtmlEncodeMap.put('\u2194', "&harr;");
        mDefensiveHtmlEncodeMap.put('\u21b5', "&crarr;");
        mDefensiveHtmlEncodeMap.put('\u21d0', "&lArr;");
        mDefensiveHtmlEncodeMap.put('\u21d1', "&uArr;");
        mDefensiveHtmlEncodeMap.put('\u21d2', "&rArr;");
        mDefensiveHtmlEncodeMap.put('\u21d3', "&dArr;");
        mDefensiveHtmlEncodeMap.put('\u21d4', "&hArr;");
        mDefensiveHtmlEncodeMap.put('\u2200', "&forall;");
        mDefensiveHtmlEncodeMap.put('\u2202', "&part;");
        mDefensiveHtmlEncodeMap.put('\u2203', "&exist;");
        mDefensiveHtmlEncodeMap.put('\u2205', "&empty;");
        mDefensiveHtmlEncodeMap.put('\u2207', "&nabla;");
        mDefensiveHtmlEncodeMap.put('\u2208', "&isin;");
        mDefensiveHtmlEncodeMap.put('\u2209', "&notin;");
        mDefensiveHtmlEncodeMap.put('\u220b', "&ni;");
        mDefensiveHtmlEncodeMap.put('\u220f', "&prod;");
        mDefensiveHtmlEncodeMap.put('\u2211', "&sum;");
        mDefensiveHtmlEncodeMap.put('\u2212', "&minus;");
        mDefensiveHtmlEncodeMap.put('\u2217', "&lowast;");
        mDefensiveHtmlEncodeMap.put('\u221a', "&radic;");
        mDefensiveHtmlEncodeMap.put('\u221d', "&prop;");
        mDefensiveHtmlEncodeMap.put('\u221e', "&infin;");
        mDefensiveHtmlEncodeMap.put('\u2220', "&ang;");
        mDefensiveHtmlEncodeMap.put('\u2227', "&and;");
        mDefensiveHtmlEncodeMap.put('\u2228', "&or;");
        mDefensiveHtmlEncodeMap.put('\u2229', "&cap;");
        mDefensiveHtmlEncodeMap.put('\u222a', "&cup;");
        mDefensiveHtmlEncodeMap.put('\u222b', "&int;");
        mDefensiveHtmlEncodeMap.put('\u2234', "&there4;");
        mDefensiveHtmlEncodeMap.put('\u223c', "&sim;");
        mDefensiveHtmlEncodeMap.put('\u2245', "&cong;");
        mDefensiveHtmlEncodeMap.put('\u2248', "&asymp;");
        mDefensiveHtmlEncodeMap.put('\u2260', "&ne;");
        mDefensiveHtmlEncodeMap.put('\u2261', "&equiv;");
        mDefensiveHtmlEncodeMap.put('\u2264', "&le;");
        mDefensiveHtmlEncodeMap.put('\u2265', "&ge;");
        mDefensiveHtmlEncodeMap.put('\u2282', "&sub;");
        mDefensiveHtmlEncodeMap.put('\u2283', "&sup;");
        mDefensiveHtmlEncodeMap.put('\u2284', "&nsub;");
        mDefensiveHtmlEncodeMap.put('\u2286', "&sube;");
        mDefensiveHtmlEncodeMap.put('\u2287', "&supe;");
        mDefensiveHtmlEncodeMap.put('\u2295', "&oplus;");
        mDefensiveHtmlEncodeMap.put('\u2297', "&otimes;");
        mDefensiveHtmlEncodeMap.put('\u22a5', "&perp;");
        mDefensiveHtmlEncodeMap.put('\u22c5', "&sdot;");
        mDefensiveHtmlEncodeMap.put('\u2308', "&lceil;");
        mDefensiveHtmlEncodeMap.put('\u2309', "&rceil;");
        mDefensiveHtmlEncodeMap.put('\u230a', "&lfloor;");
        mDefensiveHtmlEncodeMap.put('\u230b', "&rfloor;");
        mDefensiveHtmlEncodeMap.put('\u2329', "&lang;");
        mDefensiveHtmlEncodeMap.put('\u232a', "&rang;");
        mDefensiveHtmlEncodeMap.put('\u25ca', "&loz;");
        mDefensiveHtmlEncodeMap.put('\u2660', "&spades;");
        mDefensiveHtmlEncodeMap.put('\u2663', "&clubs;");
        mDefensiveHtmlEncodeMap.put('\u2665', "&hearts;");
        mDefensiveHtmlEncodeMap.put('\u2666', "&diams;");
        mXmlEncodeMap.put('&', "&amp;");
        mXmlEncodeMap.put('\'', "&apos;");
        mXmlEncodeMap.put('\"', "&quot;");
        mXmlEncodeMap.put('<', "&lt;");
        mXmlEncodeMap.put('>', "&gt;");
        mSqlEncodeMap.put('\'', "''");
        mStringEncodeMap.put('\\', "\\\\");
        mStringEncodeMap.put('\n', "\\n");
        mStringEncodeMap.put('\r', "\\r");
        mStringEncodeMap.put('\t', "\\t");
        mStringEncodeMap.put('\"', "\\\"");
        mLatexEncodeMap.put('\\', "\\\\");
        mLatexEncodeMap.put('#', "\\#");
        mLatexEncodeMap.put('$', "\\$");
        mLatexEncodeMap.put('%', "\\%");
        mLatexEncodeMap.put('&', "\\&");
        mLatexEncodeMap.put('~', "\\~");
        mLatexEncodeMap.put('_', "\\_");
        mLatexEncodeMap.put('^', "\\^");
        mLatexEncodeMap.put('{', "\\{");
        mLatexEncodeMap.put('}', "\\}");
        mLatexEncodeMap.put('\u00a1', "!'");
        mLatexEncodeMap.put('\u00bf', "?'");
        mLatexEncodeMap.put('\u00c0', "\\`{A}");
        mLatexEncodeMap.put('\u00c1', "\\'{A}");
        mLatexEncodeMap.put('\u00c2', "\\^{A}");
        mLatexEncodeMap.put('\u00c3', "\\H{A}");
        mLatexEncodeMap.put('\u00c4', "\\\"{A}");
        mLatexEncodeMap.put('\u00c5', "\\AA");
        mLatexEncodeMap.put('\u00c6', "\\AE");
        mLatexEncodeMap.put('\u00c7', "\\c{C}");
        mLatexEncodeMap.put('\u00c8', "\\`{E}");
        mLatexEncodeMap.put('\u00c9', "\\'{E}");
        mLatexEncodeMap.put('\u00ca', "\\^{E}");
        mLatexEncodeMap.put('\u00cb', "\\\"{E}");
        mLatexEncodeMap.put('\u00cc', "\\`{I}");
        mLatexEncodeMap.put('\u00cd', "\\'{I}");
        mLatexEncodeMap.put('\u00ce', "\\^{I}");
        mLatexEncodeMap.put('\u00cf', "\\\"{I}");
        mLatexEncodeMap.put('\u00d1', "\\H{N}");
        mLatexEncodeMap.put('\u00d2', "\\`{O}");
        mLatexEncodeMap.put('\u00d3', "\\'{O}");
        mLatexEncodeMap.put('\u00d4', "\\^{O}");
        mLatexEncodeMap.put('\u00d5', "\\H{O}");
        mLatexEncodeMap.put('\u00d6', "\\\"{O}");
        mLatexEncodeMap.put('\u00d8', "\\O");
        mLatexEncodeMap.put('\u00d9', "\\`{U}");
        mLatexEncodeMap.put('\u00da', "\\'{U}");
        mLatexEncodeMap.put('\u00db', "\\^{U}");
        mLatexEncodeMap.put('\u00dc', "\\\"{U}");
        mLatexEncodeMap.put('\u00dd', "\\'{Y}");
        mLatexEncodeMap.put('\u00df', "\\ss");
        mLatexEncodeMap.put('\u00e0', "\\`{a}");
        mLatexEncodeMap.put('\u00e1', "\\'{a}");
        mLatexEncodeMap.put('\u00e2', "\\^{a}");
        mLatexEncodeMap.put('\u00e3', "\\H{a}");
        mLatexEncodeMap.put('\u00e4', "\\\"{a}");
        mLatexEncodeMap.put('\u00e5', "\\aa");
        mLatexEncodeMap.put('\u00e6', "\\ae");
        mLatexEncodeMap.put('\u00e7', "\\c{c}");
        mLatexEncodeMap.put('\u00e8', "\\`{e}");
        mLatexEncodeMap.put('\u00e9', "\\'{e}");
        mLatexEncodeMap.put('\u00ea', "\\^{e}");
        mLatexEncodeMap.put('\u00eb', "\\\"{e}");
        mLatexEncodeMap.put('\u00ec', "\\`{i}");
        mLatexEncodeMap.put('\u00ed', "\\'{i}");
        mLatexEncodeMap.put('\u00ee', "\\^{i}");
        mLatexEncodeMap.put('\u00ef', "\\\"{i}");
        mLatexEncodeMap.put('\u00f1', "\\H{n}");
        mLatexEncodeMap.put('\u00f2', "\\`{o}");
        mLatexEncodeMap.put('\u00f3', "\\'{o}");
        mLatexEncodeMap.put('\u00f4', "\\^{o}");
        mLatexEncodeMap.put('\u00f5', "\\H{o}");
        mLatexEncodeMap.put('\u00f6', "\\\"{o}");
        mLatexEncodeMap.put('\u00f8', "\\o");
        mLatexEncodeMap.put('\u00f9', "\\`{u}");
        mLatexEncodeMap.put('\u00fa', "\\'{u}");
        mLatexEncodeMap.put('\u00fb', "\\^{u}");
        mLatexEncodeMap.put('\u00fc', "\\\"{u}");
        mLatexEncodeMap.put('\u00fd', "\\'{y}");
        mLatexEncodeMap.put('\u00ff', "\\\"{y}");
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BbcodeOption
    extends EnumClass<String> {
        protected BbcodeOption(String identifier) {
            super(identifier);
        }
    }
}

