/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.uwyn.rife.datastructures.EnumClass;
import com.uwyn.rife.tools.Base64;
import com.uwyn.rife.tools.Whirlpool;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEncryptor
extends EnumClass<String> {
    public static final String IDENTIFIER_OBF = "OBF";
    public static final String IDENTIFIER_MD5 = "MD5";
    public static final String IDENTIFIER_SHA = "SHA";
    public static final String IDENTIFIER_WHIRLPOOL = "WRP";
    private static final String PREFIX_SUFFIX = ":";
    private static final String PREFIX_OBF = "OBF:";
    private static final String PREFIX_MD5 = "MD5:";
    private static final String PREFIX_SHA = "SHA:";
    private static final String PREFIX_WHIRLPOOL = "WRP:";
    public static final StringEncryptor OBF;
    public static final StringEncryptor MD5;
    public static final StringEncryptor SHA;
    public static final StringEncryptor WHIRLPOOL;
    private static /* synthetic */ boolean $assertionsDisabled;

    StringEncryptor(String identifier) {
        super(identifier);
    }

    public static StringEncryptor getEncryptor(String identifier) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.tools.StringEncryptor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (StringEncryptor)EnumClass.getMember(clazz, new StringBuffer().append(identifier).append(PREFIX_SUFFIX).toString());
    }

    public String encrypt(String value) throws NoSuchAlgorithmException {
        if (value == null) {
            throw new IllegalArgumentException("value can't be null");
        }
        return StringEncryptor.autoEncrypt(new StringBuffer().append((String)this.mIdentifier).append(value).toString());
    }

    public static String autoEncrypt(String value) throws NoSuchAlgorithmException {
        if (value == null) {
            throw new IllegalArgumentException("value can't be null");
        }
        if (value.startsWith(PREFIX_SHA)) {
            MessageDigest digest = MessageDigest.getInstance(IDENTIFIER_SHA);
            digest.update(value.substring(PREFIX_SHA.length()).getBytes());
            return new StringBuffer().append(PREFIX_SHA).append(Base64.encodeToString(digest.digest(), false)).toString();
        }
        if (value.startsWith(PREFIX_WHIRLPOOL)) {
            Whirlpool whirlpool = new Whirlpool();
            whirlpool.NESSIEinit();
            whirlpool.NESSIEadd(value.substring(PREFIX_WHIRLPOOL.length()));
            byte[] digest = new byte[64];
            whirlpool.NESSIEfinalize(digest);
            return new StringBuffer().append(PREFIX_WHIRLPOOL).append(Base64.encodeToString(digest, false)).toString();
        }
        if (value.startsWith(PREFIX_MD5)) {
            MessageDigest digest = MessageDigest.getInstance(IDENTIFIER_MD5);
            digest.update(value.substring(PREFIX_MD5.length()).getBytes());
            return new StringBuffer().append(PREFIX_MD5).append(Base64.encodeToString(digest.digest(), false)).toString();
        }
        if (value.startsWith(PREFIX_OBF)) {
            return new StringBuffer().append(PREFIX_OBF).append(StringEncryptor.obfuscate(value.substring(PREFIX_OBF.length()))).toString();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        return value;
    }

    public static boolean matches(String checkedValue, String encryptedValue) throws NoSuchAlgorithmException {
        if (checkedValue == null) {
            throw new IllegalArgumentException("checkedValue can't be null");
        }
        if (encryptedValue == null) {
            throw new IllegalArgumentException("encryptedValue can't be null");
        }
        return encryptedValue.equals(StringEncryptor.adaptiveEncrypt(checkedValue, encryptedValue));
    }

    public static String adaptiveEncrypt(String clearValue, String encryptedValue) throws NoSuchAlgorithmException {
        if (clearValue == null) {
            throw new IllegalArgumentException("clearValue can't be null");
        }
        if (encryptedValue == null) {
            throw new IllegalArgumentException("encryptedValue can't be null");
        }
        if (encryptedValue.startsWith(PREFIX_OBF)) {
            clearValue = new StringBuffer().append(PREFIX_OBF).append(clearValue).toString();
        } else if (encryptedValue.startsWith(PREFIX_WHIRLPOOL)) {
            clearValue = new StringBuffer().append(PREFIX_WHIRLPOOL).append(clearValue).toString();
        } else if (encryptedValue.startsWith(PREFIX_MD5)) {
            clearValue = new StringBuffer().append(PREFIX_MD5).append(clearValue).toString();
        } else if (encryptedValue.startsWith(PREFIX_SHA)) {
            clearValue = new StringBuffer().append(PREFIX_SHA).append(clearValue).toString();
        }
        return StringEncryptor.autoEncrypt(clearValue);
    }

    public static String obfuscate(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value can't be null");
        }
        StringBuffer buffer = new StringBuffer();
        byte[] bytes = value.getBytes();
        StringBuffer stringBuffer = buffer;
        synchronized (stringBuffer) {
            int i = 0;
            while (i < bytes.length) {
                byte b1 = bytes[i];
                byte b2 = bytes[value.length() - (i + 1)];
                int i1 = b1 + b2 + 127;
                int i2 = b1 - b2 + 127;
                int i0 = i1 * 256 + i2;
                String x = Integer.toString(i0, 36);
                switch (x.length()) {
                    case 1: {
                        buffer.append('0');
                    }
                    case 2: {
                        buffer.append('0');
                    }
                    case 3: {
                        buffer.append('0');
                    }
                }
                buffer.append(x);
                ++i;
            }
            return buffer.toString();
        }
    }

    public static String deobfuscate(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value can't be null");
        }
        if (value.startsWith(PREFIX_OBF)) {
            value = value.substring(PREFIX_OBF.length());
        }
        byte[] bytes = new byte[value.length() / 2];
        int l = 0;
        int i = 0;
        while (i < value.length()) {
            String x = value.substring(i, i + 4);
            int i0 = Integer.parseInt(x, 36);
            int i1 = i0 / 256;
            int i2 = i0 % 256;
            bytes[l++] = (byte)((i1 + i2 - 254) / 2);
            i += 4;
        }
        return new String(bytes, 0, l);
    }

    public static void main(String[] arguments) {
        boolean valid_arguments = true;
        if (arguments.length < 1 || arguments.length > 3) {
            valid_arguments = false;
        } else if (!arguments[0].startsWith("-")) {
            if (arguments.length > 1) {
                valid_arguments = false;
            }
        } else if (!(arguments[0].equals("-e") || arguments[0].equals("-d") || arguments[0].equals("-c"))) {
            valid_arguments = false;
        } else if (!arguments[0].equals("-c") && 3 == arguments.length) {
            valid_arguments = false;
        }
        if (!valid_arguments) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.tools.StringEncryptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            System.err.println(new StringBuffer().append(new StringBuffer().append("Usage : java ").append(clazz.getName()).toString()).append(" [-edc] string {encrypted}").toString());
            System.err.println("Encrypts strings for usage with RIFE.");
            System.err.println("  -e  encrypt a string (default)");
            System.err.println("  -d  decrypt a string if the algorithm support it");
            System.err.println("  -c  check the validity of the string against an encrypted version");
            System.exit(1);
        }
        try {
            if (1 == arguments.length) {
                System.err.println(StringEncryptor.autoEncrypt(arguments[0]));
                System.exit(0);
            } else if (arguments[0].equals("-e")) {
                System.err.println(StringEncryptor.autoEncrypt(arguments[1]));
                System.exit(0);
            }
            if (arguments[0].equals("-d")) {
                if (arguments[1].startsWith(PREFIX_OBF)) {
                    System.err.println(StringEncryptor.deobfuscate(arguments[1]));
                } else {
                    System.err.println("ERROR: the algorithm doesn't support decoding.");
                }
                System.exit(0);
            }
            if (arguments[0].equals("-c")) {
                if (StringEncryptor.matches(arguments[1], arguments[2])) {
                    System.err.println("VALID: the strings match.");
                } else {
                    System.err.println("INVALID: the strings don't match.");
                }
                System.exit(0);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.tools.StringEncryptor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        OBF = new StringEncryptor(PREFIX_OBF);
        MD5 = new StringEncryptor(PREFIX_MD5);
        SHA = new StringEncryptor(PREFIX_SHA);
        WHIRLPOOL = new StringEncryptor(PREFIX_WHIRLPOOL);
    }

    static /* synthetic */ Object access$Lcom$uwyn$rife$datastructures$EnumClass$2(StringEncryptor stringEncryptor) {
        return stringEncryptor.mIdentifier;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$datastructures$EnumClass$2(StringEncryptor stringEncryptor, Object object) {
        stringEncryptor.mIdentifier = object;
    }
}

