/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import java.util.Random;

public abstract class PasswordGenerator {
    public static final int DIGITS_ONLY = 0;
    public static final int LETTERS_ONLY = 1;
    public static final int MIXED = 2;
    private static final String LETTERS = "qwertyuiopzxcvbnmasdfghjklAZERTYUIOPMLKJHGFDSQWXCVBN";
    private static final int LETTERS_LENGTH = LETTERS.length();
    private static final String NUMBERS = "1357924680";
    private static final int NUMBERS_LENGTH = NUMBERS.length();

    public static String get(int length) {
        return PasswordGenerator.get(new Random(System.currentTimeMillis()), length, 2);
    }

    public static String get(int length, int type) {
        return PasswordGenerator.get(new Random(System.currentTimeMillis()), length, type);
    }

    public static String get(Random random, int length, int type) {
        StringBuffer generated_password;
        if (length <= 0) {
            throw new IllegalArgumentException("length has to be bigger zero");
        }
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("invalid type");
        }
        StringBuffer stringBuffer = generated_password = new StringBuffer("");
        synchronized (stringBuffer) {
            boolean type_selector = false;
            int i = 0;
            while (i < length) {
                type_selector = random.nextBoolean();
                if (1 == type || type != 0 && type_selector) {
                    char c = LETTERS.charAt((int)((double)LETTERS_LENGTH * random.nextDouble()));
                    if (random.nextDouble() > 0.5) {
                        c = Character.toUpperCase(c);
                    }
                    generated_password.append(c);
                } else {
                    generated_password.append(NUMBERS.charAt((int)((double)NUMBERS_LENGTH * random.nextDouble())));
                }
                ++i;
            }
            return generated_password.toString();
        }
    }
}

