/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectUtils {
    public static <T> T genericClone(T object) {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        if (object == null) {
            return null;
        }
        try {
            clazz3 = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz3 == object.getClass()) {
            return object;
        }
        try {
            clazz2 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz2 == object.getClass()) {
            return object;
        }
        if (object instanceof Throwable) {
            return object;
        }
        try {
            clazz = Class.forName("java.lang.StringBuffer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (clazz == object.getClass()) {
            return (T)new StringBuffer(object.toString());
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof Character) {
            return object;
        }
        if (!(object instanceof Cloneable)) {
            return null;
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            method.setAccessible(true);
            return (T)method.invoke(object, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T deepClone(T object) throws CloneNotSupportedException {
        if (object == null) {
            return null;
        }
        String classname = object.getClass().getName();
        if ('[' == classname.charAt(0)) {
            if (classname.charAt(1) != '[' && classname.charAt(1) != 'L') {
                switch (classname.charAt(1)) {
                    case 'B': {
                        return (T)((byte[])((byte[])object).clone());
                    }
                    case 'Z': {
                        return (T)((boolean[])((boolean[])object).clone());
                    }
                    case 'C': {
                        return (T)((char[])((char[])object).clone());
                    }
                    case 'S': {
                        return (T)((short[])((short[])object).clone());
                    }
                    case 'I': {
                        return (T)((int[])((int[])object).clone());
                    }
                    case 'J': {
                        return (T)((long[])((long[])object).clone());
                    }
                    case 'F': {
                        return (T)((float[])((float[])object).clone());
                    }
                    case 'D': {
                        return (T)((double[])((double[])object).clone());
                    }
                }
                Logger.getLogger("com.uwyn.rife.tools").severe(new StringBuffer().append("Unknown primitive array class: ").append(classname).toString());
                return null;
            }
            int dimension_count = 1;
            while (classname.charAt(dimension_count) == '[') {
                ++dimension_count;
            }
            Class<?> baseClass = null;
            if (classname.charAt(dimension_count) != 'L') {
                baseClass = ObjectUtils.getBaseClass(object);
            } else {
                try {
                    baseClass = Class.forName(classname.substring(dimension_count + 1, classname.length() - 1));
                }
                catch (ClassNotFoundException e) {
                    Logger.getLogger("com.uwyn.rife.tools").severe(new StringBuffer().append("Internal error: class definition inconsistency: ").append(classname).toString());
                    return null;
                }
            }
            int[] dimensions = new int[dimension_count];
            dimensions[0] = Array.getLength(object);
            int i = 1;
            while (i < dimension_count) {
                dimensions[i] = 0;
                ++i;
            }
            Object copy = Array.newInstance(baseClass, dimensions);
            int i2 = 0;
            while (i2 < dimensions[0]) {
                Array.set(copy, i2, ObjectUtils.deepClone(Array.get(object, i2)));
                ++i2;
            }
            return (T)copy;
        }
        if (object instanceof Collection && object instanceof Cloneable) {
            Collection collection = (Collection)object;
            Collection copy = (Collection)ObjectUtils.genericClone(object);
            copy.clear();
            Iterator collection_it = collection.iterator();
            while (collection_it.hasNext()) {
                copy.add(ObjectUtils.deepClone(collection_it.next()));
            }
            return (T)copy;
        }
        if (object instanceof Map && object instanceof Cloneable) {
            Map map = (Map)object;
            Map copy = (Map)ObjectUtils.genericClone(object);
            copy.clear();
            Iterator collection_it = map.entrySet().iterator();
            Map.Entry entry = null;
            while (collection_it.hasNext()) {
                entry = collection_it.next();
                copy.put(ObjectUtils.deepClone(entry.getKey()), ObjectUtils.deepClone(entry.getValue()));
            }
            return (T)copy;
        }
        T copy = ObjectUtils.genericClone(object);
        if (copy == null) {
            throw new CloneNotSupportedException(object.getClass().getName());
        }
        return copy;
    }

    public static Class getBaseClass(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        String className = object.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return object.getClass();
        }
        switch (className.charAt(dims)) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                try {
                    return Class.forName(className.substring(dims + 1, className.length() - 1));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

