/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.tools;

import com.sun.tools.javac.Main;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.tools.ExecUtils;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.CompilationFailedException;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class CompilationUtils {
    public static File compile(String filenameJava, File fileClass, String generationPath, String classpath) throws CompilationFailedException {
        block28: {
            try {
                StringBuffer command_buffer;
                if ((!RifeConfig.Global.isJavaCompilerPathSet() || RifeConfig.Global.getJavaCompilerInternal()) && RifeConfig.Global.isInternalJavaCompilerAvailable()) {
                    int status;
                    String[] args = new String[]{"-g", "-classpath", classpath, "-d", generationPath, filenameJava};
                    Method compile_method = null;
                    ByteArrayOutputStream errors_outputstream = new ByteArrayOutputStream();
                    PrintWriter errors_printwriter = new PrintWriter(errors_outputstream);
                    try {
                        Class<?> clazz;
                        Class<?> clazz2;
                        Class<?> clazz3;
                        try {
                            clazz3 = Class.forName("com.sun.tools.javac.Main");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        Class[] classArray = new Class[2];
                        try {
                            clazz2 = Class.forName("[Ljava.lang.String;");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        classArray[0] = clazz2;
                        try {
                            clazz = Class.forName("java.io.PrintWriter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        classArray[1] = clazz;
                        compile_method = clazz3.getDeclaredMethod("compile", classArray);
                    }
                    catch (Throwable e) {
                        compile_method = null;
                    }
                    if (compile_method != null) {
                        try {
                            Object status2 = compile_method.invoke(null, args, errors_printwriter);
                            if (Integer.parseInt(String.valueOf(status2)) != 0) {
                                throw new CompilationFailedException(filenameJava, errors_outputstream.toString(), null);
                            }
                        }
                        catch (IllegalAccessException e) {
                            compile_method = null;
                        }
                        catch (InvocationTargetException e) {
                            compile_method = null;
                        }
                        catch (IllegalArgumentException e) {
                            compile_method = null;
                        }
                    }
                    if (compile_method == null && (status = Main.compile(args)) != 0) {
                        throw new CompilationFailedException(filenameJava, "<unknown error>", null);
                    }
                    break block28;
                }
                StringBuffer compile_method = command_buffer = new StringBuffer(RifeConfig.Global.getJavaCompilerPath());
                synchronized (compile_method) {
                    if (RifeConfig.Global.areJavaCompilerArgsSet()) {
                        command_buffer.append(" ");
                        command_buffer.append(StringUtils.join(RifeConfig.Global.getJavaCompilerArgs(), " "));
                    }
                    command_buffer.append(" -g -d ");
                    command_buffer.append(generationPath);
                    command_buffer.append(" ");
                    command_buffer.append(filenameJava);
                }
                String command = command_buffer.toString();
                Process javac = ExecUtils.exec(command, new String[]{"CLASSPATH=" + classpath});
                if (javac.exitValue() == 0 && fileClass.exists()) break block28;
                String error_message = null;
                try {
                    error_message = FileUtils.readString(javac.getErrorStream());
                }
                catch (FileUtilsErrorException e) {
                    error_message = "<unknown error>";
                }
                if (fileClass.exists()) {
                    fileClass.delete();
                }
                throw new CompilationFailedException(filenameJava, error_message, null);
            }
            catch (IOException e) {
                if (fileClass.exists()) {
                    fileClass.delete();
                }
                throw new CompilationFailedException(filenameJava, null, e);
            }
            catch (InterruptedException e) {
                if (fileClass.exists()) {
                    fileClass.delete();
                }
                throw new CompilationFailedException(filenameJava, null, e);
            }
        }
        return fileClass;
    }
}

