/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.template;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.template.Parsed;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.template.TemplateTransformer;
import com.uwyn.rife.template.exceptions.TemplateException;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

class TemplateClassLoader
extends ClassLoader {
    private TemplateFactory mTemplateFactory = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    TemplateClassLoader(TemplateFactory templateFactory, ClassLoader initiating) {
        super(initiating);
        if (!$assertionsDisabled && templateFactory == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && initiating == null) {
            throw new AssertionError();
        }
        this.mTemplateFactory = templateFactory;
    }

    protected Class loadClass(String classname, boolean resolve, String encoding, TemplateTransformer transformer) throws ClassNotFoundException {
        if (!$assertionsDisabled && classname == null) {
            throw new AssertionError();
        }
        Class<?> c = this.findLoadedClass(classname);
        if (c != null) {
            if (RifeConfig.Template.getAutoReload() && this.isTemplateModified(c, transformer)) {
                TemplateClassLoader new_classloader = new TemplateClassLoader(this.mTemplateFactory, this.getParent());
                this.mTemplateFactory.setClassLoader(new_classloader);
                return new_classloader.loadClass(classname, resolve, encoding, transformer);
            }
        } else {
            block24: {
                ClassLoader parent = this.getParent();
                if (parent != null) {
                    try {
                        URL resource;
                        c = parent.loadClass(classname);
                        if (c != null && RifeConfig.Template.getAutoReload() && (resource = parent.getResource(classname.replace('.', '/') + ".class")).getPath().indexOf(33) != -1) {
                            if (resolve) {
                                this.resolveClass(c);
                            }
                            return c;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        c = null;
                    }
                }
                if (c == null) {
                    try {
                        c = this.findSystemClass(classname);
                    }
                    catch (ClassNotFoundException e) {
                        c = null;
                    }
                }
                try {
                    Class<?> clazz;
                    if (c == null || classname.startsWith("java.") || classname.startsWith("javax.") || classname.startsWith("sun.")) break block24;
                    try {
                        clazz = Class.forName("com.uwyn.rife.template.Template");
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.getMessage());
                    }
                    if (clazz.isAssignableFrom(c) && RifeConfig.Template.getAutoReload() && this.isTemplateModified(c, transformer)) {
                        c = null;
                    }
                }
                catch (ClassNotFoundException e) {
                    c = null;
                }
            }
            if (c == null) {
                String string = classname = classname.intern();
                synchronized (string) {
                    c = this.findLoadedClass(classname);
                    if (c == null) {
                        byte[] raw = this.compileTemplate(classname, encoding, transformer);
                        c = this.defineClass(classname, raw, 0, raw.length);
                    }
                }
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (!$assertionsDisabled && c == null) {
            throw new AssertionError();
        }
        return c;
    }

    private byte[] compileTemplate(String classname, String encoding, TemplateTransformer transformer) throws ClassNotFoundException {
        if (!$assertionsDisabled && classname == null) {
            throw new AssertionError();
        }
        URL template_url = this.mTemplateFactory.getParser().resolve(classname);
        if (template_url == null) {
            throw new ClassNotFoundException("Couldn't resolve template: '" + classname + "'.");
        }
        Parsed template_parsed = this.mTemplateFactory.getParser().prepare(classname, template_url);
        try {
            this.mTemplateFactory.getParser().parse(template_parsed, encoding, transformer);
        }
        catch (TemplateException e) {
            throw new ClassNotFoundException("Error while parsing template: '" + classname + "'.", e);
        }
        byte[] byte_code = template_parsed.getByteCode();
        if (RifeConfig.Template.getGenerateClasses()) {
            String template_package = template_parsed.getPackage();
            template_package = template_package.replace('.', File.separatorChar);
            String template_classname = template_parsed.getClassName();
            String generation_path = RifeConfig.Template.getGenerationPath() + File.separatorChar;
            String packagedir = generation_path + template_package;
            String filename_class = packagedir + File.separator + template_classname + ".class";
            File file_packagedir = new File(packagedir);
            File file_class = new File(filename_class);
            if (!file_packagedir.exists()) {
                if (!file_packagedir.mkdirs()) {
                    throw new ClassNotFoundException("Couldn't create the template package directory : '" + packagedir + "'.");
                }
            } else {
                if (!file_packagedir.isDirectory()) {
                    throw new ClassNotFoundException("The template package directory '" + packagedir + "' exists but is not a directory.");
                }
                if (!file_packagedir.canWrite()) {
                    throw new ClassNotFoundException("The template package directory '" + packagedir + "' is not writable.");
                }
            }
            try {
                FileUtils.writeBytes(byte_code, file_class);
            }
            catch (FileUtilsErrorException e) {
                throw new ClassNotFoundException("Error while writing the contents of the template class file '" + classname + "'.", e);
            }
        }
        return byte_code;
    }

    private boolean isTemplateModified(Class c, TemplateTransformer transformer) throws ClassNotFoundException {
        if (!$assertionsDisabled && c == null) {
            throw new AssertionError();
        }
        boolean is_modified = true;
        Method is_modified_method = null;
        String modification_state = null;
        if (transformer != null) {
            modification_state = transformer.getState();
        }
        try {
            Class<?> clazz;
            Class<?> clazz2;
            Class[] classArray = new Class[2];
            try {
                clazz2 = Class.forName("com.uwyn.rife.resources.ResourceFinder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[0] = clazz2;
            try {
                clazz = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            classArray[1] = clazz;
            is_modified_method = c.getMethod("isModified", classArray);
            is_modified = (Boolean)is_modified_method.invoke(null, this.mTemplateFactory.getResourceFinder(), modification_state);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {}
        return is_modified;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.TemplateClassLoader");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

