/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.template;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.template.FilteredTagsMap;
import com.uwyn.rife.template.Parsed;
import com.uwyn.rife.template.ParsedBlockData;
import com.uwyn.rife.template.ParsedBlockText;
import com.uwyn.rife.template.ParsedBlockValue;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.template.TemplateTransformer;
import com.uwyn.rife.template.exceptions.AmbiguousTemplateNameException;
import com.uwyn.rife.template.exceptions.AttributeNotEndedException;
import com.uwyn.rife.template.exceptions.BeginTagNotEndedException;
import com.uwyn.rife.template.exceptions.CircularIncludesException;
import com.uwyn.rife.template.exceptions.GetContentErrorException;
import com.uwyn.rife.template.exceptions.IncludeNotFoundException;
import com.uwyn.rife.template.exceptions.InvalidBlockFilterException;
import com.uwyn.rife.template.exceptions.InvalidValueFilterException;
import com.uwyn.rife.template.exceptions.MismatchedTerminationTagException;
import com.uwyn.rife.template.exceptions.MissingTerminationTagsException;
import com.uwyn.rife.template.exceptions.ModificationTimeErrorException;
import com.uwyn.rife.template.exceptions.TagNotTerminatedException;
import com.uwyn.rife.template.exceptions.TemplateNotFoundException;
import com.uwyn.rife.template.exceptions.TerminatingUnopenedTagException;
import com.uwyn.rife.template.exceptions.TransformedResultConversionException;
import com.uwyn.rife.template.exceptions.UnsupportedNestedTagException;
import com.uwyn.rife.tools.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements Cloneable {
    public static final String DEFAULT_TEMPLATES_PATH = "templates/";
    public static final String TEMPLATE_PACKAGE = "com.uwyn.rife.template.";
    private TemplateFactory mTemplateFactory = null;
    private String mIdentifier = null;
    private String mPackageName = null;
    private Config[] mConfigs = null;
    private String mAmbiguousName = null;
    private String mExtension = null;
    private int mExtensionLength = -1;
    private Pattern[] mBlockFilters = null;
    private Pattern[] mValueFilters = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    Parser(TemplateFactory templateFactory, String identifier, Config[] configs, String extension, String[] blockFilters, String[] valueFilters) {
        this.init(templateFactory, identifier, configs, extension, blockFilters, valueFilters);
    }

    Parser(TemplateFactory templateFactory, String identifier, Config[] configs, String extension, Pattern[] blockFilters, Pattern[] valueFilters) {
        this.init(templateFactory, identifier, configs, extension, blockFilters, valueFilters);
    }

    Config[] getConfigs() {
        return this.mConfigs;
    }

    String getExtension() {
        return this.mExtension;
    }

    Pattern[] getBlockFilters() {
        return this.mBlockFilters;
    }

    Pattern[] getValueFilters() {
        return this.mValueFilters;
    }

    TemplateFactory getTemplateFactory() {
        return this.mTemplateFactory;
    }

    private void init(TemplateFactory templateFactory, String identifier, Config[] configs, String extension, String[] blockFilters, String[] valueFilters) {
        Pattern[] block_filter_patterns = null;
        Pattern[] value_filter_patterns = null;
        if (blockFilters != null) {
            block_filter_patterns = new Pattern[blockFilters.length];
            try {
                this.compileFilters(blockFilters, block_filter_patterns);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidBlockFilterException(e.getPattern());
            }
        }
        if (valueFilters != null) {
            value_filter_patterns = new Pattern[valueFilters.length];
            try {
                this.compileFilters(valueFilters, value_filter_patterns);
            }
            catch (PatternSyntaxException e) {
                throw new InvalidValueFilterException(e.getPattern());
            }
        }
        this.init(templateFactory, identifier, configs, extension, block_filter_patterns, value_filter_patterns);
    }

    private void compileFilters(String[] valueFilters, Pattern[] value_filter_patterns) {
        int i = 0;
        while (i < valueFilters.length) {
            value_filter_patterns[i] = Pattern.compile(valueFilters[i]);
            ++i;
        }
    }

    private void init(TemplateFactory templateFactory, String identifier, Config[] configs, String extension, Pattern[] blockFilters, Pattern[] valueFilters) {
        if (!$assertionsDisabled && templateFactory == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && identifier == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && configs == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && configs.length <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && extension == null) {
            throw new AssertionError();
        }
        this.mTemplateFactory = templateFactory;
        this.mIdentifier = identifier;
        this.mPackageName = new StringBuffer().append(new StringBuffer().append(TEMPLATE_PACKAGE).append(this.mIdentifier).toString()).append(".").toString();
        this.mConfigs = configs;
        this.mExtension = extension;
        this.mExtensionLength = this.mExtension.length();
        this.mAmbiguousName = new StringBuffer().append(this.mExtension).append(this.mExtension).toString().substring(1);
        this.mBlockFilters = blockFilters;
        this.mValueFilters = valueFilters;
        if (!$assertionsDisabled && this.mExtensionLength <= 0) {
            throw new AssertionError();
        }
    }

    public Parser clone() {
        Parser new_parser = null;
        try {
            new_parser = (Parser)super.clone();
        }
        catch (CloneNotSupportedException e) {
            new_parser = null;
        }
        Pattern[] new_blockfilters = null;
        if (this.mBlockFilters != null) {
            new_blockfilters = (Pattern[])this.mBlockFilters.clone();
        }
        Pattern[] new_valuefilters = null;
        if (this.mValueFilters != null) {
            new_valuefilters = (Pattern[])this.mValueFilters.clone();
        }
        new_parser.init(this.mTemplateFactory, this.mIdentifier, this.mConfigs, this.mExtension, new_blockfilters, new_valuefilters);
        return new_parser;
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }

    public boolean equals(Object object) {
        int i;
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Parser)) {
            return false;
        }
        Parser other_parser = (Parser)object;
        if (!Arrays.equals(other_parser.mConfigs, this.mConfigs)) {
            return false;
        }
        if (!other_parser.mIdentifier.equals(this.mIdentifier)) {
            return false;
        }
        if (!other_parser.mExtension.equals(this.mExtension)) {
            return false;
        }
        if (other_parser.mBlockFilters == null && this.mBlockFilters != null || other_parser.mBlockFilters != null && this.mBlockFilters == null) {
            return false;
        }
        if (other_parser.mBlockFilters != null && this.mBlockFilters != null) {
            if (other_parser.mBlockFilters.length != this.mBlockFilters.length) {
                return false;
            }
            i = 0;
            while (i < other_parser.mBlockFilters.length) {
                if (!other_parser.mBlockFilters[i].pattern().equals(this.mBlockFilters[i].pattern())) {
                    return false;
                }
                ++i;
            }
        }
        if (other_parser.mValueFilters == null && this.mValueFilters != null || other_parser.mValueFilters != null && this.mValueFilters == null) {
            return false;
        }
        if (other_parser.mValueFilters != null && this.mValueFilters != null) {
            if (other_parser.mValueFilters.length != this.mValueFilters.length) {
                return false;
            }
            i = 0;
            while (i < other_parser.mValueFilters.length) {
                if (!other_parser.mValueFilters[i].pattern().equals(this.mValueFilters[i].pattern())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public Parsed parse(String name, String encoding, TemplateTransformer transformer) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        URL resource = this.resolve(name);
        if (resource == null) {
            throw new TemplateNotFoundException(name, null);
        }
        return this.parse(this.prepare(name, resource), encoding, transformer);
    }

    public URL resolve(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.indexOf(this.getPackage())) {
            name = name.substring(this.getPackage().length());
        }
        name = new StringBuffer().append(name.replace('.', '/')).append(this.mExtension).toString();
        URL resource = this.mTemplateFactory.getResourceFinder().getResource(name);
        if (resource == null) {
            resource = this.mTemplateFactory.getResourceFinder().getResource(new StringBuffer().append(DEFAULT_TEMPLATES_PATH).append(name).toString());
        }
        return resource;
    }

    public String getPackage() {
        return this.mPackageName;
    }

    String escapeClassname(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (name.equals(this.mAmbiguousName)) {
            throw new AmbiguousTemplateNameException(name);
        }
        if (name.endsWith(this.mExtension)) {
            name = name.substring(0, name.length() - this.mExtensionLength);
        }
        char[] name_chars = name.toCharArray();
        int i = 0;
        while (i < name_chars.length) {
            char char_code = name_chars[i];
            if (!(char_code >= '0' && char_code <= '9' || char_code >= 'A' && char_code <= 'Z' || char_code >= 'a' && char_code <= 'z' || char_code == '.')) {
                name_chars[i] = char_code == '/' || char_code == '\\' ? 46 : 95;
            }
            ++i;
        }
        return new String(name_chars);
    }

    public Parsed prepare(String name, URL resource) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (resource == null) {
            throw new IllegalArgumentException("resource can't be null.");
        }
        String template_name = name;
        Parsed template_parsed = new Parsed(this);
        if (0 == template_name.indexOf(this.getPackage())) {
            template_name = name.substring(this.getPackage().length());
        }
        String class_name = template_name;
        String subpackage = "";
        int package_seperator = template_name.lastIndexOf(".");
        if (package_seperator != -1) {
            subpackage = new StringBuffer().append(".").append(template_name.substring(0, package_seperator)).toString();
            class_name = template_name.substring(package_seperator + 1);
        }
        template_parsed.setTemplateName(template_name);
        template_parsed.setPackage(new StringBuffer().append(this.getPackage().substring(0, this.getPackage().length() - 1)).append(subpackage).toString());
        template_parsed.setClassName(this.escapeClassname(class_name));
        template_parsed.setResource(resource);
        return template_parsed;
    }

    Parsed parse(Parsed parsed, String encoding, TemplateTransformer transformer) {
        if (!$assertionsDisabled && parsed == null) {
            throw new AssertionError();
        }
        if (encoding == null) {
            encoding = RifeConfig.Template.getDefaultEncoding();
        }
        URL resource = parsed.getResource();
        StringBuffer content_buffer = this.getContent(parsed.getTemplateName(), parsed, resource, encoding, transformer);
        Stack<String> previous_includes = new Stack<String>();
        previous_includes.push(parsed.getFullClassName());
        this.replaceIncludeTags(parsed, content_buffer, previous_includes, encoding, transformer);
        previous_includes.pop();
        String content = content_buffer.toString();
        this.parseBlocks(parsed, content);
        parsed.setFilteredBlocks(this.filterTags(this.mBlockFilters, parsed.getBlockIds()));
        parsed.setFilteredValues(this.filterTags(this.mValueFilters, parsed.getValueIds()));
        if (!$assertionsDisabled && parsed.getBlocks().size() < 1) {
            throw new AssertionError();
        }
        return parsed;
    }

    private StringBuffer getContent(String templateName, Parsed parsed, URL resource, String encoding, TemplateTransformer transformer) {
        if (transformer == null) {
            return this.getFileContent(resource, encoding);
        }
        return this.getTransformedContent(templateName, parsed, resource, encoding, transformer);
    }

    private StringBuffer getFileContent(URL resource, String encoding) {
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError();
        }
        String content = null;
        try {
            content = this.mTemplateFactory.getResourceFinder().getContent(resource, encoding);
        }
        catch (ResourceFinderErrorException e) {
            throw new GetContentErrorException(resource.toExternalForm(), e);
        }
        return new StringBuffer(content);
    }

    private StringBuffer getTransformedContent(String templateName, Parsed parsed, URL resource, String encoding, TemplateTransformer transformer) {
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError();
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        transformer.setResourceFinder(this.mTemplateFactory.getResourceFinder());
        Collection<URL> dependencies = transformer.transform(templateName, resource, result, encoding);
        if (dependencies != null && dependencies.size() > 0) {
            long modification_time = 0;
            for (URL dependency_resource : dependencies) {
                try {
                    modification_time = transformer.getResourceFinder().getModificationTime(dependency_resource);
                }
                catch (ResourceFinderErrorException e) {
                    modification_time = 0;
                }
                if (modification_time <= (long)0) continue;
                parsed.addDependency(dependency_resource, new Long(modification_time));
            }
        }
        parsed.setModificationState(transformer.getState());
        try {
            if (encoding == null) {
                if (transformer.getEncoding() == null) {
                    return new StringBuffer(result.toString());
                }
                return new StringBuffer(result.toString(transformer.getEncoding()));
            }
            return new StringBuffer(result.toString(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformedResultConversionException(resource.toExternalForm(), e);
        }
    }

    public static long getModificationTime(ResourceFinder resourceFinder, URL resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource can't be null.");
        }
        long modification_time = -1;
        try {
            modification_time = resourceFinder.getModificationTime(resource);
        }
        catch (ResourceFinderErrorException e) {
            throw new ModificationTimeErrorException(resource.toExternalForm(), e);
        }
        return modification_time;
    }

    private int getEscapedIndex(String content, String search, int start, TagMatch match, String delimiter) {
        int begin_index = content.indexOf(search, start);
        if (begin_index != -1) {
            int delimiter_index = -1;
            int last_match = begin_index;
            while (begin_index != -1) {
                if (begin_index > 0 && '\\' == content.charAt(begin_index - 1) && (begin_index < 2 || content.charAt(begin_index - 2) != '\\')) {
                    begin_index = -1;
                } else if (delimiter != null) {
                    delimiter_index = content.indexOf(delimiter, begin_index + search.length());
                    if (-1 == delimiter_index) {
                        begin_index = -1;
                    } else if (content.substring(begin_index + search.length(), delimiter_index).trim().length() != 0) {
                        begin_index = -1;
                    }
                }
                if (-1 == begin_index) {
                    last_match = begin_index = content.indexOf(search, last_match + 1);
                    continue;
                }
                if (match != null) {
                    match.setSearchStartIndex(begin_index);
                    match.setDelimiterEndIndex(delimiter_index + 1);
                }
                return begin_index;
            }
        }
        if (match != null) {
            match.setSearchStartIndex(-1);
            match.setDelimiterEndIndex(-1);
        }
        return -1;
    }

    private String unescapePart(String part) {
        Config[] configArray = this.mConfigs;
        int n = 0;
        while (n < configArray.length) {
            Config config = configArray[n];
            part = StringUtils.replace(part, new StringBuffer().append('\\').append(config.mTagBlockValueBeginStart).toString(), config.mTagBlockValueBeginStart);
            part = StringUtils.replace(part, new StringBuffer().append('\\').append(config.mTagBlockBeginStart).toString(), config.mTagBlockBeginStart);
            part = StringUtils.replace(part, new StringBuffer().append('\\').append(config.mTagBlockValueTerm).toString(), config.mTagBlockValueTerm);
            part = StringUtils.replace(part, new StringBuffer().append('\\').append(config.mTagBlockTerm).toString(), config.mTagBlockTerm);
            part = StringUtils.replace(part, new StringBuffer().append('\\').append(config.mTagValueBeginStart).toString(), config.mTagValueBeginStart);
            part = StringUtils.replace(part, new StringBuffer().append('\\').append(config.mTagValueTermLong).toString(), config.mTagValueTermLong);
            part = StringUtils.replace(part, new StringBuffer().append('\\').append(config.mTagIncludeBegin).toString(), config.mTagIncludeBegin);
            ++n;
        }
        part = this.removeTrailingDoubleEscape(part, 0, part.length());
        return part;
    }

    private String removeTrailingDoubleEscape(String content, int begin, int end) {
        if (end >= 2 && '\\' == content.charAt(end - 1) && '\\' == content.charAt(end - 2)) {
            return content.substring(begin, end - 1);
        }
        return content.substring(begin, end);
    }

    private void replaceIncludeTags(Parsed parsed, StringBuffer content, Stack<String> previousIncludes, String encoding, TemplateTransformer transformer) {
        if (!$assertionsDisabled && parsed == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && previousIncludes == null) {
            throw new AssertionError();
        }
        TagMatch match = new TagMatch();
        int previous_index = 0;
        int begin_start_index = 0;
        int term_start_index = 0;
        int tag_end_index = 0;
        int includename_begin_index = 0;
        String included_template_name = null;
        URL included_template_resource = null;
        Parsed included_template_parsed = null;
        StringBuffer included_template_content = null;
        Config[] configArray = this.mConfigs;
        int n = 0;
        while (n < configArray.length) {
            Config config = configArray[n];
            do {
                if (-1 == (begin_start_index = this.getEscapedIndex(content.toString(), config.mTagIncludeBegin, previous_index, match, config.mStringDelimiter))) continue;
                term_start_index = content.indexOf(config.mTagIncludeTerm, begin_start_index);
                tag_end_index = term_start_index + config.mTagIncludeTermLength;
                includename_begin_index = content.indexOf(config.mStringDelimiter, begin_start_index) + 1;
                included_template_name = content.substring(includename_begin_index, term_start_index);
                included_template_resource = this.resolve(included_template_name);
                if (included_template_resource == null) {
                    throw new IncludeNotFoundException(parsed.getClassName(), included_template_name);
                }
                included_template_parsed = this.prepare(included_template_name, included_template_resource);
                if (previousIncludes.contains(included_template_parsed.getFullClassName())) {
                    throw new CircularIncludesException(included_template_name, previousIncludes);
                }
                included_template_content = this.getContent(included_template_name, parsed, included_template_parsed.getResource(), encoding, transformer);
                previousIncludes.push(included_template_parsed.getFullClassName());
                this.replaceIncludeTags(included_template_parsed, included_template_content, previousIncludes, encoding, transformer);
                previousIncludes.pop();
                if (begin_start_index >= 2 && '\\' == content.charAt(begin_start_index - 1) && '\\' == content.charAt(begin_start_index - 2)) {
                    content.replace(begin_start_index - 1, tag_end_index, included_template_content.toString());
                } else {
                    content.replace(begin_start_index, tag_end_index, included_template_content.toString());
                }
                parsed.addDependency(included_template_parsed);
                HashMap<URL, Long> included_dependencies = included_template_parsed.getDependencies();
                for (Map.Entry included_dependency : (Collection)included_dependencies.entrySet()) {
                    parsed.addDependency((URL)included_dependency.getKey(), (Long)included_dependency.getValue());
                }
                previous_index = begin_start_index;
            } while (begin_start_index > -1);
            ++n;
        }
    }

    private TagMatch getFirstMatch(TagMatch match1, TagMatch match2) {
        int candidate1 = match1.getSearchStartIndex();
        int candidate2 = match2.getSearchStartIndex();
        if (-1 == candidate1 && -1 == candidate2) {
            return null;
        }
        if (-1 == candidate1) {
            return match2;
        }
        if (-1 == candidate2) {
            return match1;
        }
        if (candidate1 < candidate2) {
            return match1;
        }
        return match2;
    }

    private int getFirstMatch(int candidate1, int candidate2) {
        if (-1 == candidate1 && -1 == candidate2) {
            return -1;
        }
        if (-1 == candidate1) {
            return candidate2;
        }
        if (-1 == candidate2) {
            return candidate1;
        }
        if (candidate1 < candidate2) {
            return candidate1;
        }
        return candidate2;
    }

    private void parseBlocks(Parsed parsed, String content) {
        if (!$assertionsDisabled && parsed == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        LinkedHashMap<String, StringBuffer> blocks = new LinkedHashMap<String, StringBuffer>();
        Stack<String> block_ids = new Stack<String>();
        block_ids.push("");
        blocks.put("", new StringBuffer(""));
        TagMatch match1 = new TagMatch();
        TagMatch match2 = new TagMatch();
        TagMatch first_match = null;
        int previous_index = 0;
        int begin_start_index = 0;
        int delimiter_end_index = 0;
        int begin_end_index = 0;
        int term_index = 0;
        int blockid_begin_index = 0;
        int blockid_end_index = 0;
        int[] begin_start_indices = new int[this.mConfigs.length];
        int[] delimiter_end_indices = new int[this.mConfigs.length];
        int[] term_indices = new int[this.mConfigs.length];
        String leftover_content = null;
        String blockid = null;
        Config config_begin = null;
        Config config_term = null;
        boolean is_blockvalue_tag = false;
        do {
            String blockvalue_tag_check;
            int index_block = -1;
            int index_blockvalue = -1;
            int index_blockvalue_term_end = -1;
            int i = 0;
            while (i < this.mConfigs.length) {
                index_block = this.getEscapedIndex(content, this.mConfigs[i].mTagBlockBeginStart, previous_index, match1, this.mConfigs[i].mStringDelimiter);
                index_blockvalue = this.getEscapedIndex(content, this.mConfigs[i].mTagBlockValueBeginStart, previous_index, match2, this.mConfigs[i].mStringDelimiter);
                first_match = this.getFirstMatch(match1, match2);
                if (first_match == null) {
                    begin_start_indices[i] = -1;
                    delimiter_end_indices[i] = -1;
                } else {
                    begin_start_indices[i] = first_match.getSearchStartIndex();
                    delimiter_end_indices[i] = first_match.getDelimiterEndIndex();
                }
                ++i;
            }
            i = 0;
            while (i < this.mConfigs.length) {
                index_block = this.getEscapedIndex(content, this.mConfigs[i].mTagBlockTerm, previous_index, null, null);
                index_blockvalue = this.getEscapedIndex(content, this.mConfigs[i].mTagBlockValueTerm, previous_index, null, null);
                term_indices[i] = this.getFirstMatch(index_block, index_blockvalue);
                ++i;
            }
            config_begin = null;
            begin_start_index = -1;
            i = 0;
            while (i < begin_start_indices.length) {
                if (begin_start_indices[i] != -1 && (-1 == begin_start_index || begin_start_indices[i] < begin_start_index)) {
                    begin_start_index = begin_start_indices[i];
                    delimiter_end_index = delimiter_end_indices[i];
                    config_begin = this.mConfigs[i];
                }
                ++i;
            }
            config_term = null;
            term_index = -1;
            i = 0;
            while (i < term_indices.length) {
                if (term_indices[i] != -1 && (-1 == term_index || term_indices[i] < term_index)) {
                    term_index = term_indices[i];
                    config_term = this.mConfigs[i];
                }
                ++i;
            }
            if (begin_start_index != -1 && (begin_start_index < term_index || -1 == term_index)) {
                leftover_content = this.removeTrailingDoubleEscape(content, previous_index, begin_start_index);
                blockid = (String)block_ids.peek();
                ((StringBuffer)blocks.get(blockid)).append(leftover_content);
                String blockvalue_tag_check2 = content.substring(begin_start_index, begin_start_index + config_begin.mTagBlockValueBeginStart.length());
                is_blockvalue_tag = blockvalue_tag_check2.equals(config_begin.mTagBlockValueBeginStart);
                blockid_begin_index = delimiter_end_index;
                blockid_end_index = content.indexOf(config_begin.mStringDelimiter, blockid_begin_index);
                if (-1 == blockid_end_index) {
                    throw new AttributeNotEndedException(parsed.getClassName(), "B", "ID");
                }
                blockid = content.substring(blockid_begin_index, blockid_end_index);
                begin_end_index = content.indexOf(config_begin.mTagBlockBeginEnd, blockid_end_index);
                if (-1 == begin_end_index) {
                    throw new BeginTagNotEndedException(parsed.getClassName(), "B", blockid);
                }
                block_ids.push(blockid);
                blocks.put(blockid, new StringBuffer(""));
                if (is_blockvalue_tag) {
                    parsed.setBlockDefaultValue(blockid);
                    previous_index = begin_end_index + config_begin.mTagBlockValueBeginEndLength;
                    continue;
                }
                previous_index = begin_end_index + config_begin.mTagBlockBeginEndLength;
                continue;
            }
            if (term_index <= -1) continue;
            leftover_content = this.removeTrailingDoubleEscape(content, previous_index, term_index);
            index_blockvalue_term_end = term_index + config_term.mTagBlockValueTermLength;
            is_blockvalue_tag = content.length() < index_blockvalue_term_end ? false : (blockvalue_tag_check = content.substring(term_index, index_blockvalue_term_end)).equals(config_term.mTagBlockValueTerm);
            if (1 == block_ids.size()) {
                if (is_blockvalue_tag) {
                    throw new TerminatingUnopenedTagException(parsed.getClassName(), "BV");
                }
                throw new TerminatingUnopenedTagException(parsed.getClassName(), "B");
            }
            blockid = (String)block_ids.peek();
            ((StringBuffer)blocks.get(blockid)).append(leftover_content);
            block_ids.pop();
            if (parsed.hasBlockDefaultValue(blockid)) {
                if (!is_blockvalue_tag) {
                    throw new MismatchedTerminationTagException(parsed.getClassName(), blockid, "BV", "B");
                }
            } else if (is_blockvalue_tag) {
                throw new MismatchedTerminationTagException(parsed.getClassName(), blockid, "B", "BV");
            }
            previous_index = is_blockvalue_tag ? term_index + config_term.mTagBlockValueTermLength : term_index + config_term.mTagBlockTermLength;
        } while (begin_start_index > -1 || term_index > -1);
        if (block_ids.size() > 1) {
            throw new MissingTerminationTagsException(parsed.getClassName(), "B");
        }
        ((StringBuffer)blocks.get("")).append(content.substring(previous_index));
        for (String block_key : (Collection)blocks.keySet()) {
            parsed.setBlock(block_key, this.parseBlockParts(parsed, ((StringBuffer)blocks.get(block_key)).toString()));
        }
    }

    private ParsedBlockData parseBlockParts(Parsed parsed, String content) {
        if (!$assertionsDisabled && parsed == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && content == null) {
            throw new AssertionError();
        }
        ParsedBlockData block_data = new ParsedBlockData();
        TagMatch match = new TagMatch();
        int previous_index = 0;
        int begin_start_index = 0;
        boolean delimiter_end_index = false;
        int begin_start_index_next = 0;
        int term_index = 0;
        int valueid_begin_index = 0;
        int valueid_end_index = 0;
        int[] begin_start_indices = new int[this.mConfigs.length];
        int[] delimiter_end_indices = new int[this.mConfigs.length];
        int[] term_indices = new int[this.mConfigs.length];
        String valueid = null;
        String valuetag_start = null;
        Config config_begin = null;
        Config config_term = null;
        Config config_tmp = null;
        do {
            int i = 0;
            while (i < this.mConfigs.length) {
                this.getEscapedIndex(content, this.mConfigs[i].mTagValueBeginStart, previous_index, match, this.mConfigs[i].mStringDelimiter);
                begin_start_indices[i] = match.getSearchStartIndex();
                delimiter_end_indices[i] = match.getDelimiterEndIndex();
                ++i;
            }
            config_begin = null;
            begin_start_index = -1;
            i = 0;
            while (i < begin_start_indices.length) {
                if (begin_start_indices[i] != -1 && (-1 == begin_start_index || begin_start_indices[i] < begin_start_index)) {
                    begin_start_index = begin_start_indices[i];
                    valueid_begin_index = delimiter_end_indices[i];
                    config_begin = this.mConfigs[i];
                }
                ++i;
            }
            if (-1 == begin_start_index) continue;
            if (previous_index < begin_start_index) {
                String part = this.unescapePart(content.substring(previous_index, begin_start_index));
                block_data.addPart(new ParsedBlockText(part));
            }
            if (-1 == (valueid_end_index = content.indexOf(config_begin.mStringDelimiter, valueid_begin_index))) {
                throw new AttributeNotEndedException(parsed.getClassName(), "V", "ID");
            }
            valuetag_start = content.substring(begin_start_index, valueid_begin_index);
            valueid = content.substring(valueid_begin_index, valueid_end_index);
            parsed.addValue(valueid);
            if (config_begin.mTagValueBeginEndLong.equals(content.substring(valueid_end_index, valueid_end_index + config_begin.mTagValueBeginEndLongLength))) {
                i = 0;
                while (i < this.mConfigs.length) {
                    term_indices[i] = this.getEscapedIndex(content, this.mConfigs[i].mTagValueTermLong, previous_index, null, null);
                    ++i;
                }
                config_term = null;
                term_index = -1;
                i = 0;
                while (i < term_indices.length) {
                    if (term_indices[i] != -1 && (-1 == term_index || term_indices[i] < term_index)) {
                        term_index = term_indices[i];
                        config_term = this.mConfigs[i];
                    }
                    ++i;
                }
                if (-1 == term_index) {
                    throw new TagNotTerminatedException(parsed.getClassName(), "V", valueid);
                }
                int j = 0;
                while (j < this.mConfigs.length) {
                    config_tmp = this.mConfigs[j];
                    begin_start_index_next = this.getEscapedIndex(content, config_tmp.mTagValueBeginStart, begin_start_index + config_tmp.mTagValueBeginStart.length(), match, config_tmp.mStringDelimiter);
                    if (-1 != begin_start_index_next && begin_start_index_next < term_index) {
                        throw new UnsupportedNestedTagException(parsed.getClassName(), "V", valueid);
                    }
                    ++j;
                }
                parsed.setDefaultValue(valueid, this.unescapePart(content.substring(valueid_end_index + config_begin.mTagValueBeginEndLongLength, term_index)));
                block_data.addPart(new ParsedBlockValue(valueid, new StringBuffer().append(new StringBuffer().append(valuetag_start).append(valueid).toString()).append(config_term.mTagValueTermShort).toString()));
                previous_index = term_index + config_term.mTagValueTermLongLength;
                continue;
            }
            if (config_begin.mTagValueTermShort.equals(content.substring(valueid_end_index, valueid_end_index + config_begin.mTagValueTermShortLength))) {
                term_index = valueid_end_index;
                block_data.addPart(new ParsedBlockValue(valueid, new StringBuffer().append(new StringBuffer().append(valuetag_start).append(valueid).toString()).append(config_begin.mTagValueTermShort).toString()));
                previous_index = term_index + config_begin.mTagValueTermShortLength;
                continue;
            }
            throw new BeginTagNotEndedException(parsed.getClassName(), "V", valueid);
        } while (begin_start_index > -1 && term_index > -1);
        if (previous_index < content.length()) {
            block_data.addPart(new ParsedBlockText(this.unescapePart(content.substring(previous_index))));
        }
        return block_data;
    }

    private FilteredTagsMap filterTags(Pattern[] filters, Collection<String> tags) {
        FilteredTagsMap result = null;
        if (filters != null) {
            result = new FilteredTagsMap();
            Matcher filter_matcher = null;
            ArrayList<String> captured_groups = null;
            String pattern = null;
            String[] captured_groups_array = null;
            ArrayList<String> filtered_tags = new ArrayList<String>();
            Pattern[] patternArray = filters;
            int n = 0;
            while (n < patternArray.length) {
                Pattern filter_pattern = patternArray[n];
                for (String tag : tags) {
                    if (filtered_tags.contains(tag)) continue;
                    filter_matcher = filter_pattern.matcher(tag);
                    while (filter_matcher.find()) {
                        if (captured_groups == null) {
                            captured_groups = new ArrayList<String>();
                            captured_groups.add(tag);
                        }
                        if (filter_matcher.groupCount() <= 0) continue;
                        int j = 1;
                        while (j <= filter_matcher.groupCount()) {
                            captured_groups.add(filter_matcher.group(j));
                            ++j;
                        }
                    }
                    if (captured_groups == null) continue;
                    pattern = filter_pattern.pattern();
                    captured_groups_array = new String[captured_groups.size()];
                    captured_groups.toArray(captured_groups_array);
                    result.addFilteredTag(pattern, captured_groups_array);
                    filtered_tags.add(tag);
                    captured_groups_array = null;
                    captured_groups = null;
                }
                ++n;
            }
        }
        return result;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.Parser");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    static class Config
    implements Cloneable {
        private String mTagStart = null;
        private String mTagEnd = null;
        private String mEndTagIdentifier = null;
        private String mStringDelimiter = null;
        private String mTagIncludeBegin = null;
        private String mTagIncludeTerm = null;
        private String mTagBlockBeginStart = null;
        private String mTagBlockBeginEnd = null;
        private String mTagBlockTerm = null;
        private String mTagBlockValueBeginStart = null;
        private String mTagBlockValueBeginEnd = null;
        private String mTagBlockValueTerm = null;
        private String mTagValueBeginStart = null;
        private String mTagValueBeginEndLong = null;
        private String mTagValueTermShort = null;
        private String mTagValueTermLong = null;
        private int mStringDelimiterLength = -1;
        private int mTagIncludeTermLength = -1;
        private int mTagBlockBeginEndLength = -1;
        private int mTagBlockTermLength = -1;
        private int mTagBlockValueBeginEndLength = -1;
        private int mTagBlockValueTermLength = -1;
        private int mTagValueBeginEndLongLength = -1;
        private int mTagValueTermShortLength = -1;
        private int mTagValueTermLongLength = -1;
        private static /* synthetic */ boolean $assertionsDisabled;

        static /* synthetic */ void access$S1000027(Config config, String string) {
            config.mStringDelimiter = string;
        }

        static /* synthetic */ void access$S1000028(Config config, String string) {
            config.mTagIncludeBegin = string;
        }

        static /* synthetic */ void access$S1000029(Config config, String string) {
            config.mTagIncludeTerm = string;
        }

        static /* synthetic */ void access$S1000030(Config config, String string) {
            config.mTagBlockBeginStart = string;
        }

        static /* synthetic */ void access$S1000031(Config config, String string) {
            config.mTagBlockBeginEnd = string;
        }

        static /* synthetic */ void access$S1000032(Config config, String string) {
            config.mTagBlockTerm = string;
        }

        static /* synthetic */ void access$S1000033(Config config, String string) {
            config.mTagBlockValueBeginStart = string;
        }

        static /* synthetic */ void access$S1000035(Config config, String string) {
            config.mTagBlockValueTerm = string;
        }

        static /* synthetic */ void access$S1000036(Config config, String string) {
            config.mTagValueBeginStart = string;
        }

        static /* synthetic */ void access$S1000037(Config config, String string) {
            config.mTagValueBeginEndLong = string;
        }

        static /* synthetic */ void access$S1000038(Config config, String string) {
            config.mTagValueTermShort = string;
        }

        static /* synthetic */ void access$S1000039(Config config, String string) {
            config.mTagValueTermLong = string;
        }

        static /* synthetic */ void access$S1000041(Config config, int n) {
            config.mTagIncludeTermLength = n;
        }

        static /* synthetic */ void access$S1000042(Config config, int n) {
            config.mTagBlockBeginEndLength = n;
        }

        static /* synthetic */ void access$S1000043(Config config, int n) {
            config.mTagBlockTermLength = n;
        }

        static /* synthetic */ void access$S1000044(Config config, int n) {
            config.mTagBlockValueBeginEndLength = n;
        }

        static /* synthetic */ void access$S1000045(Config config, int n) {
            config.mTagBlockValueTermLength = n;
        }

        static /* synthetic */ void access$S1000046(Config config, int n) {
            config.mTagValueBeginEndLongLength = n;
        }

        static /* synthetic */ void access$S1000047(Config config, int n) {
            config.mTagValueTermShortLength = n;
        }

        static /* synthetic */ void access$S1000048(Config config, int n) {
            config.mTagValueTermLongLength = n;
        }

        Config(String tagStart, String tagEnd, String endTagIndentifier, String stringDelimiter) {
            this.init(tagStart, tagEnd, endTagIndentifier, stringDelimiter);
        }

        private void init(String tagStart, String tagEnd, String endTagIndentifier, String stringDelimiter) {
            if (!$assertionsDisabled && tagStart == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && tagEnd == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && endTagIndentifier == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && stringDelimiter == null) {
                throw new AssertionError();
            }
            this.mTagStart = tagStart;
            this.mTagEnd = tagEnd;
            this.mEndTagIdentifier = endTagIndentifier;
            this.mStringDelimiter = stringDelimiter;
            this.mTagIncludeBegin = this.mTagStart + "I";
            this.mTagIncludeTerm = this.mStringDelimiter + this.mEndTagIdentifier + this.mTagEnd;
            this.mTagBlockBeginStart = this.mTagStart + "B";
            this.mTagBlockBeginEnd = this.mStringDelimiter + this.mTagEnd;
            this.mTagBlockTerm = this.mTagStart + this.mEndTagIdentifier + "B" + this.mTagEnd;
            this.mTagBlockValueBeginStart = this.mTagStart + "BV";
            this.mTagBlockValueBeginEnd = this.mStringDelimiter + this.mTagEnd;
            this.mTagBlockValueTerm = this.mTagStart + this.mEndTagIdentifier + "BV" + this.mTagEnd;
            this.mTagValueBeginStart = this.mTagStart + "V";
            this.mTagValueBeginEndLong = this.mStringDelimiter + this.mTagEnd;
            this.mTagValueTermShort = this.mStringDelimiter + this.mEndTagIdentifier + this.mTagEnd;
            this.mTagValueTermLong = this.mTagStart + this.mEndTagIdentifier + "V" + this.mTagEnd;
            this.mStringDelimiterLength = this.mStringDelimiter.length();
            this.mTagIncludeTermLength = this.mTagIncludeTerm.length();
            this.mTagBlockBeginEndLength = this.mTagBlockBeginEnd.length();
            this.mTagBlockTermLength = this.mTagBlockTerm.length();
            this.mTagBlockValueBeginEndLength = this.mTagBlockValueBeginEnd.length();
            this.mTagBlockValueTermLength = this.mTagBlockValueTerm.length();
            this.mTagValueBeginEndLongLength = this.mTagValueBeginEndLong.length();
            this.mTagValueTermShortLength = this.mTagValueTermShort.length();
            this.mTagValueTermLongLength = this.mTagValueTermLong.length();
            if (!$assertionsDisabled && this.mStringDelimiter == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagIncludeBegin == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagIncludeTerm == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockBeginStart == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockBeginEnd == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockTerm == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockValueBeginStart == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockValueBeginEnd == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockValueTerm == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagValueBeginStart == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagValueBeginEndLong == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagValueTermShort == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagValueTermLong == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mStringDelimiterLength <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagIncludeTermLength <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockBeginEndLength <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockTermLength <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockValueBeginEndLength <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagBlockValueTermLength <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagValueBeginEndLongLength <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagValueTermShortLength <= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.mTagValueTermLongLength <= 0) {
                throw new AssertionError();
            }
        }

        public Config clone() {
            Config new_parserconfig = null;
            try {
                new_parserconfig = (Config)super.clone();
            }
            catch (CloneNotSupportedException e) {
                new_parserconfig = null;
            }
            return new_parserconfig;
        }

        public /* synthetic */ Object clone() {
            return this.clone();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof Config)) {
                return false;
            }
            Config other_parserconfig = (Config)object;
            return other_parserconfig.mTagStart.equals(this.mTagStart) && other_parserconfig.mTagEnd.equals(this.mTagEnd) && other_parserconfig.mEndTagIdentifier.equals(this.mEndTagIdentifier) && other_parserconfig.mStringDelimiter.equals(this.mStringDelimiter);
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.template.Parser$Config");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }

    class TagMatch {
        public int mSearchStartIndex = -1;
        public int mDelimiterEndIndex = -1;

        public void setSearchStartIndex(int beginIndex) {
            this.mSearchStartIndex = beginIndex;
        }

        public int getSearchStartIndex() {
            return this.mSearchStartIndex;
        }

        public void setDelimiterEndIndex(int delimiterIndex) {
            this.mDelimiterEndIndex = delimiterIndex;
        }

        public int getDelimiterEndIndex() {
            return this.mDelimiterEndIndex;
        }

        static /* synthetic */ Parser access$0(TagMatch tagMatch) {
            return tagMatch.Parser.this;
        }
    }
}

