/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.template;

import com.uwyn.rife.asm.ClassWriter;
import com.uwyn.rife.asm.Label;
import com.uwyn.rife.asm.MethodVisitor;
import com.uwyn.rife.asm.Opcodes;
import com.uwyn.rife.pcj.map.IntKeyOpenHashMap;
import com.uwyn.rife.template.FilteredTags;
import com.uwyn.rife.template.FilteredTagsMap;
import com.uwyn.rife.template.ParsedBlockData;
import com.uwyn.rife.template.ParsedBlockPart;
import com.uwyn.rife.template.Parser;
import com.uwyn.rife.template.exceptions.TemplateException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Parsed
implements Opcodes {
    private Parser mParser = null;
    private String mTemplateName = null;
    private String mPackage = null;
    private String mClassName = null;
    private URL mResource = null;
    private long mModificationTime = -1;
    private LinkedHashMap<String, ParsedBlockData> mBlocks = new LinkedHashMap();
    private LinkedHashSet<String> mValueIds = new LinkedHashSet();
    private HashMap<String, String> mDefaultValues = new HashMap();
    private ArrayList<String> mBlockDefaultValues = new ArrayList();
    private HashMap<URL, Long> mDependencies = new HashMap();
    private String mModificationState = null;
    private FilteredTagsMap mFilteredValuesMap = null;
    private FilteredTagsMap mFilteredBlocksMap = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    Parsed(Parser parser) {
        if (!$assertionsDisabled && parser == null) {
            throw new AssertionError();
        }
        this.mParser = parser;
    }

    private IntKeyOpenHashMap<ArrayList<String>> getHashcodeKeysMapping(Collection<String> stringCollection) {
        IntKeyOpenHashMap<ArrayList<String>> hashcode_keys_mapping = new IntKeyOpenHashMap<ArrayList<String>>();
        ArrayList<String> keys = null;
        for (String key : stringCollection) {
            int hashcode = key.hashCode();
            keys = hashcode_keys_mapping.get(hashcode);
            if (keys == null) {
                keys = new ArrayList();
                hashcode_keys_mapping.put(hashcode, keys);
            }
            keys.add(key);
        }
        return hashcode_keys_mapping;
    }

    private void addIntegerConst(MethodVisitor method, int value) {
        switch (value) {
            case -1: {
                method.visitInsn(2);
                break;
            }
            case 0: {
                method.visitInsn(3);
                break;
            }
            case 1: {
                method.visitInsn(4);
                break;
            }
            case 2: {
                method.visitInsn(5);
                break;
            }
            case 3: {
                method.visitInsn(6);
                break;
            }
            case 4: {
                method.visitInsn(7);
                break;
            }
            case 5: {
                method.visitInsn(8);
                break;
            }
            default: {
                method.visitLdcInsn(new Integer(value));
                break;
            }
        }
    }

    byte[] getByteCode() {
        String[] captured_groups;
        Label list_null_check;
        Label blockdefaultvalue_doesntexist_label;
        ParsedBlockPart block_part3;
        Iterator block_data_it;
        Label after_key_label;
        String key2;
        ParsedBlockPart block_part22;
        Iterator block_data_it2;
        ClassWriter class_writer = new ClassWriter(true);
        MethodVisitor method = null;
        String full_classname = new StringBuffer().append(new StringBuffer().append(this.getPackage()).append(".").toString()).append(this.getClassName()).toString().replace('.', '/');
        class_writer.visit(48, 33, full_classname, null, "com/uwyn/rife/template/AbstractTemplate", null);
        method = class_writer.visitMethod(1, "<init>", "()V", null, null);
        method.visitVarInsn(25, 0);
        method.visitMethodInsn(183, "com/uwyn/rife/template/AbstractTemplate", "<init>", "()V");
        method.visitInsn(177);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "getName", "()Ljava/lang/String;", null, null);
        method.visitLdcInsn(this.mClassName);
        method.visitInsn(176);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(8, "getModificationTimeReal", "()J", null, null);
        method.visitLdcInsn(new Long(this.getModificationTime()));
        method.visitInsn(173);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "getModificationTime", "()J", null, null);
        method.visitMethodInsn(184, full_classname, "getModificationTimeReal", "()J");
        method.visitInsn(173);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(8, "getModificationState", "()Ljava/lang/String;", null, null);
        if (this.mModificationState == null) {
            method.visitInsn(1);
        } else {
            method.visitLdcInsn(this.mModificationState);
        }
        method.visitInsn(176);
        method.visitMaxs(0, 0);
        ParsedBlockData block_data = null;
        ArrayList<String> keys = null;
        IntKeyOpenHashMap<ArrayList<String>> hashcode_keys_mapping = null;
        LinkedHashMap<String, ParsedBlockPart> blockparts_order = null;
        int[] hashcodes = null;
        hashcode_keys_mapping = this.getHashcodeKeysMapping(this.mBlocks.keySet());
        blockparts_order = new LinkedHashMap<String, ParsedBlockPart>();
        hashcodes = hashcode_keys_mapping.keySet().toArray();
        Arrays.sort(hashcodes);
        keys = null;
        method = class_writer.visitMethod(4, "appendBlockExternalForm", "(Ljava/lang/String;Lcom/uwyn/rife/template/ExternalValue;)Z", null, null);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, "java/lang/String", "hashCode", "()I");
        Label external_default = new Label();
        Label external_found = new Label();
        Label[] external_labels = new Label[hashcodes.length];
        int i = 0;
        while (i < external_labels.length) {
            external_labels[i] = new Label();
            ++i;
        }
        method.visitLookupSwitchInsn(external_default, hashcodes, external_labels);
        String blockdata_static_prefix = "sBlockPart";
        long blockdata_static_counter = 0L;
        String static_identifier = null;
        int i2 = 0;
        while (i2 < hashcodes.length) {
            method.visitLabel(external_labels[i2]);
            keys = hashcode_keys_mapping.get(hashcodes[i2]);
            if (1 == keys.size()) {
                block_data = this.mBlocks.get(keys.get(0));
                block_data_it2 = block_data.iterator();
                block_part22 = null;
                while (block_data_it2.hasNext()) {
                    block_part22 = (ParsedBlockPart)block_data_it2.next();
                    static_identifier = new StringBuffer().append(blockdata_static_prefix).append(blockdata_static_counter++).toString();
                    blockparts_order.put(static_identifier, block_part22);
                    block_part22.visitByteCodeExternalForm(method, full_classname, static_identifier);
                }
            } else {
                for (String key2 : (Collection)keys) {
                    after_key_label = new Label();
                    method.visitVarInsn(25, 1);
                    method.visitLdcInsn(key2);
                    method.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                    method.visitJumpInsn(153, after_key_label);
                    block_data = this.mBlocks.get(key2);
                    block_data_it = block_data.iterator();
                    block_part3 = null;
                    while (block_data_it.hasNext()) {
                        block_part3 = (ParsedBlockPart)block_data_it.next();
                        static_identifier = new StringBuffer().append(blockdata_static_prefix).append(blockdata_static_counter++).toString();
                        blockparts_order.put(static_identifier, block_part3);
                        block_part3.visitByteCodeExternalForm(method, full_classname, static_identifier);
                    }
                    method.visitJumpInsn(167, external_found);
                    method.visitLabel(after_key_label);
                }
                method.visitInsn(3);
                method.visitInsn(172);
            }
            method.visitJumpInsn(167, external_found);
            ++i2;
        }
        method.visitLabel(external_default);
        method.visitInsn(3);
        method.visitInsn(172);
        method.visitLabel(external_found);
        method.visitInsn(4);
        method.visitInsn(172);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(4, "appendBlockInternalForm", "(Ljava/lang/String;Lcom/uwyn/rife/template/InternalValue;)Z", null, null);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, "java/lang/String", "hashCode", "()I");
        Label internal_default = new Label();
        Label internal_found = new Label();
        Label[] internal_labels = new Label[hashcodes.length];
        i = 0;
        while (i < internal_labels.length) {
            internal_labels[i] = new Label();
            ++i;
        }
        method.visitLookupSwitchInsn(internal_default, hashcodes, internal_labels);
        String static_identifier2 = null;
        Iterator static_identifiers_it = blockparts_order.keySet().iterator();
        int i3 = 0;
        while (i3 < hashcodes.length) {
            method.visitLabel(internal_labels[i3]);
            int text_count = 0;
            int value_count = 0;
            keys = hashcode_keys_mapping.get(hashcodes[i3]);
            if (1 == keys.size()) {
                block_data = this.mBlocks.get(keys.get(0));
                block_data_it2 = null;
                block_part22 = null;
                for (ParsedBlockPart block_part22 : block_data) {
                    if (0 == block_part22.getType()) {
                        ++text_count;
                        continue;
                    }
                    if (1 != block_part22.getType()) continue;
                    ++value_count;
                }
                if (text_count + value_count > 0) {
                    method.visitVarInsn(25, 0);
                    method.visitVarInsn(25, 2);
                    this.addIntegerConst(method, text_count + value_count);
                    method.visitMethodInsn(182, full_classname, "increasePartsCapacityInternal", "(Lcom/uwyn/rife/template/InternalValue;I)V");
                }
                if (value_count > 0) {
                    method.visitVarInsn(25, 0);
                    method.visitVarInsn(25, 2);
                    this.addIntegerConst(method, value_count);
                    method.visitMethodInsn(182, full_classname, "increaseValuesCapacityInternal", "(Lcom/uwyn/rife/template/InternalValue;I)V");
                }
                for (ParsedBlockPart block_part22 : block_data) {
                    static_identifier2 = (String)static_identifiers_it.next();
                    block_part22.visitByteCodeInternalForm(method, full_classname, static_identifier2);
                }
                method.visitJumpInsn(167, internal_found);
            } else {
                for (String key2 : (Collection)keys) {
                    after_key_label = new Label();
                    method.visitVarInsn(25, 1);
                    method.visitLdcInsn(key2);
                    method.visitMethodInsn(182, "java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                    method.visitJumpInsn(153, after_key_label);
                    block_data = this.mBlocks.get(key2);
                    block_data_it = null;
                    block_part3 = null;
                    for (ParsedBlockPart block_part3 : block_data) {
                        if (0 == block_part3.getType()) {
                            ++text_count;
                            continue;
                        }
                        if (1 != block_part3.getType()) continue;
                        ++value_count;
                    }
                    method.visitVarInsn(25, 0);
                    method.visitVarInsn(25, 2);
                    this.addIntegerConst(method, text_count + value_count);
                    method.visitMethodInsn(182, full_classname, "increasePartsCapacityInternal", "(Lcom/uwyn/rife/template/InternalValue;I)V");
                    method.visitVarInsn(25, 0);
                    method.visitVarInsn(25, 2);
                    this.addIntegerConst(method, value_count);
                    method.visitMethodInsn(182, full_classname, "increaseValuesCapacityInternal", "(Lcom/uwyn/rife/template/InternalValue;I)V");
                    for (ParsedBlockPart block_part3 : block_data) {
                        static_identifier2 = (String)static_identifiers_it.next();
                        block_part3.visitByteCodeInternalForm(method, full_classname, static_identifier2);
                    }
                    method.visitJumpInsn(167, internal_found);
                    method.visitLabel(after_key_label);
                }
                method.visitInsn(3);
                method.visitInsn(172);
            }
            ++i3;
        }
        method.visitLabel(internal_default);
        method.visitInsn(3);
        method.visitInsn(172);
        method.visitLabel(internal_found);
        method.visitInsn(4);
        method.visitInsn(172);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "getDefaultValue", "(Ljava/lang/String;)Ljava/lang/String;", null, null);
        Label after_null_check = new Label();
        method.visitInsn(1);
        method.visitVarInsn(25, 1);
        method.visitJumpInsn(166, after_null_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("id can't be null.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_null_check);
        Label after_empty_check = new Label();
        method.visitInsn(3);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, "java/lang/String", "length", "()I");
        method.visitJumpInsn(160, after_empty_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("id can't be empty.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_empty_check);
        method.visitInsn(1);
        method.visitVarInsn(58, 2);
        if (this.mBlockDefaultValues.size() > 0) {
            Label blockdefaultvalue_doesntexist_label2 = new Label();
            method.visitFieldInsn(178, full_classname, "sBlockDefaultValues", "Ljava/util/ArrayList;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/ArrayList", "contains", "(Ljava/lang/Object;)Z");
            method.visitJumpInsn(153, blockdefaultvalue_doesntexist_label2);
            method.visitTypeInsn(187, "com/uwyn/rife/template/ExternalValue");
            method.visitInsn(89);
            method.visitMethodInsn(183, "com/uwyn/rife/template/ExternalValue", "<init>", "()V");
            method.visitVarInsn(58, 3);
            method.visitVarInsn(25, 0);
            method.visitVarInsn(25, 1);
            method.visitVarInsn(25, 3);
            method.visitMethodInsn(182, full_classname, "appendBlockExternalForm", "(Ljava/lang/String;Lcom/uwyn/rife/template/ExternalValue;)Z");
            method.visitInsn(87);
            method.visitVarInsn(25, 3);
            method.visitMethodInsn(182, "com/uwyn/rife/template/ExternalValue", "toString", "()Ljava/lang/String;");
            method.visitVarInsn(58, 2);
            method.visitLabel(blockdefaultvalue_doesntexist_label2);
        }
        if (this.mDefaultValues.size() > 0) {
            Label defaultvalues_alreadyexist_label = new Label();
            method.visitInsn(1);
            method.visitVarInsn(25, 2);
            method.visitJumpInsn(166, defaultvalues_alreadyexist_label);
            method.visitFieldInsn(178, full_classname, "sDefaultValues", "Ljava/util/HashMap;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            method.visitTypeInsn(192, "java/lang/String");
            method.visitVarInsn(58, 2);
            method.visitLabel(defaultvalues_alreadyexist_label);
        }
        method.visitVarInsn(25, 2);
        method.visitInsn(176);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(4, "appendDefaultValueExternalForm", "(Ljava/lang/String;Lcom/uwyn/rife/template/ExternalValue;)Z", null, null);
        method.visitInsn(3);
        method.visitVarInsn(54, 3);
        if (this.mBlockDefaultValues.size() > 0) {
            blockdefaultvalue_doesntexist_label = new Label();
            method.visitFieldInsn(178, full_classname, "sBlockDefaultValues", "Ljava/util/ArrayList;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/ArrayList", "contains", "(Ljava/lang/Object;)Z");
            method.visitJumpInsn(153, blockdefaultvalue_doesntexist_label);
            method.visitVarInsn(25, 0);
            method.visitVarInsn(25, 1);
            method.visitVarInsn(25, 2);
            method.visitMethodInsn(182, full_classname, "appendBlockExternalForm", "(Ljava/lang/String;Lcom/uwyn/rife/template/ExternalValue;)Z");
            method.visitInsn(87);
            method.visitInsn(4);
            method.visitVarInsn(54, 3);
            method.visitLabel(blockdefaultvalue_doesntexist_label);
        }
        if (this.mDefaultValues.size() > 0) {
            Label alreadyfound_defaultvalue_label = new Label();
            method.visitVarInsn(21, 3);
            method.visitJumpInsn(154, alreadyfound_defaultvalue_label);
            method.visitFieldInsn(178, full_classname, "sDefaultValues", "Ljava/util/HashMap;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/HashMap", "containsKey", "(Ljava/lang/Object;)Z");
            method.visitJumpInsn(153, alreadyfound_defaultvalue_label);
            method.visitVarInsn(25, 2);
            method.visitFieldInsn(178, full_classname, "sDefaultValues", "Ljava/util/HashMap;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            method.visitTypeInsn(192, "java/lang/String");
            method.visitMethodInsn(182, "com/uwyn/rife/template/ExternalValue", "append", "(Ljava/lang/CharSequence;)V");
            method.visitInsn(4);
            method.visitVarInsn(54, 3);
            method.visitLabel(alreadyfound_defaultvalue_label);
        }
        method.visitVarInsn(21, 3);
        method.visitInsn(172);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(4, "appendDefaultValueInternalForm", "(Ljava/lang/String;Lcom/uwyn/rife/template/InternalValue;)Z", null, null);
        if (this.mBlockDefaultValues.size() > 0) {
            blockdefaultvalue_doesntexist_label = new Label();
            method.visitFieldInsn(178, full_classname, "sBlockDefaultValues", "Ljava/util/ArrayList;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/ArrayList", "contains", "(Ljava/lang/Object;)Z");
            method.visitJumpInsn(153, blockdefaultvalue_doesntexist_label);
            method.visitVarInsn(25, 0);
            method.visitVarInsn(25, 1);
            method.visitVarInsn(25, 2);
            method.visitMethodInsn(182, full_classname, "appendBlockInternalForm", "(Ljava/lang/String;Lcom/uwyn/rife/template/InternalValue;)Z");
            method.visitInsn(87);
            method.visitInsn(4);
            method.visitInsn(172);
            method.visitLabel(blockdefaultvalue_doesntexist_label);
        }
        method.visitInsn(3);
        method.visitInsn(172);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(9, "isModified", "(Lcom/uwyn/rife/resources/ResourceFinder;Ljava/lang/String;)Z", null, null);
        method.visitFieldInsn(178, full_classname, "sResource", "Ljava/net/URL;");
        method.visitMethodInsn(184, full_classname, "getModificationTimeReal", "()J");
        method.visitFieldInsn(178, full_classname, "sDependencies", "Ljava/util/HashMap;");
        method.visitMethodInsn(184, full_classname, "getModificationState", "()Ljava/lang/String;");
        method.visitVarInsn(25, 0);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(184, full_classname, "isTemplateClassModified", "(Ljava/net/URL;JLjava/util/Map;Ljava/lang/String;Lcom/uwyn/rife/resources/ResourceFinder;Ljava/lang/String;)Z");
        method.visitInsn(172);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "hasValueId", "(Ljava/lang/String;)Z", null, null);
        if (this.mValueIds.size() > 0) {
            method.visitFieldInsn(178, full_classname, "sValueIds", "Ljava/util/HashSet;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/HashSet", "contains", "(Ljava/lang/Object;)Z");
        } else {
            method.visitInsn(3);
        }
        method.visitInsn(172);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "getAvailableValueIds", "()[Ljava/lang/String;", null, null);
        if (this.mValueIds.size() > 0) {
            method.visitFieldInsn(178, full_classname, "sValueIdsArray", "[Ljava/lang/String;");
        } else {
            method.visitInsn(3);
            method.visitTypeInsn(189, "java/lang/String");
        }
        method.visitInsn(176);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "getUnsetValueIds", "()Ljava/util/Collection;", null, null);
        method.visitTypeInsn(187, "java/util/ArrayList");
        method.visitInsn(89);
        method.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
        method.visitVarInsn(58, 1);
        if (this.mValueIds.size() > 0) {
            Label while_start_label = new Label();
            Label while_end_label = new Label();
            method.visitFieldInsn(178, full_classname, "sValueIds", "Ljava/util/HashSet;");
            method.visitMethodInsn(182, "java/util/HashSet", "iterator", "()Ljava/util/Iterator;");
            method.visitVarInsn(58, 2);
            method.visitInsn(1);
            method.visitVarInsn(58, 3);
            method.visitLabel(while_start_label);
            method.visitVarInsn(25, 2);
            method.visitMethodInsn(185, "java/util/Iterator", "hasNext", "()Z");
            method.visitJumpInsn(153, while_end_label);
            method.visitVarInsn(25, 2);
            method.visitMethodInsn(185, "java/util/Iterator", "next", "()Ljava/lang/Object;");
            method.visitTypeInsn(192, "java/lang/String");
            method.visitVarInsn(58, 3);
            method.visitVarInsn(25, 0);
            method.visitVarInsn(25, 3);
            method.visitMethodInsn(182, full_classname, "isValueSet", "(Ljava/lang/String;)Z");
            method.visitJumpInsn(154, while_start_label);
            method.visitVarInsn(25, 0);
            method.visitVarInsn(25, 3);
            method.visitMethodInsn(182, full_classname, "hasDefaultValue", "(Ljava/lang/String;)Z");
            method.visitJumpInsn(154, while_start_label);
            method.visitVarInsn(25, 1);
            method.visitVarInsn(25, 3);
            method.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z");
            method.visitInsn(87);
            method.visitJumpInsn(167, while_start_label);
            method.visitLabel(while_end_label);
        }
        method.visitVarInsn(25, 1);
        method.visitInsn(176);
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "getFilteredBlocks", "(Ljava/lang/String;)Ljava/util/List;", null, null);
        after_null_check = new Label();
        method.visitInsn(1);
        method.visitVarInsn(25, 1);
        method.visitJumpInsn(166, after_null_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("filter can't be null.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_null_check);
        after_empty_check = new Label();
        method.visitInsn(3);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, "java/lang/String", "length", "()I");
        method.visitJumpInsn(160, after_empty_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("filter can't be empty.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_empty_check);
        if (this.mFilteredBlocksMap != null) {
            method.visitFieldInsn(178, full_classname, "sFilteredBlocksMap", "Ljava/util/HashMap;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            method.visitTypeInsn(192, "java/util/ArrayList");
            method.visitVarInsn(58, 2);
            method.visitInsn(1);
            method.visitVarInsn(25, 2);
            list_null_check = new Label();
            method.visitJumpInsn(166, list_null_check);
            method.visitTypeInsn(187, "java/util/ArrayList");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
            method.visitVarInsn(58, 2);
            method.visitLabel(list_null_check);
            method.visitVarInsn(25, 2);
            method.visitInsn(176);
        } else {
            method.visitTypeInsn(187, "java/util/ArrayList");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
            method.visitInsn(176);
        }
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "hasFilteredBlocks", "(Ljava/lang/String;)Z", null, null);
        after_null_check = new Label();
        method.visitInsn(1);
        method.visitVarInsn(25, 1);
        method.visitJumpInsn(166, after_null_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("filter can't be null.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_null_check);
        after_empty_check = new Label();
        method.visitInsn(3);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, "java/lang/String", "length", "()I");
        method.visitJumpInsn(160, after_empty_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("filter can't be empty.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_empty_check);
        if (this.mFilteredBlocksMap != null) {
            method.visitFieldInsn(178, full_classname, "sFilteredBlocksMap", "Ljava/util/HashMap;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/HashMap", "containsKey", "(Ljava/lang/Object;)Z");
            method.visitInsn(172);
        } else {
            method.visitInsn(3);
            method.visitInsn(172);
        }
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "getFilteredValues", "(Ljava/lang/String;)Ljava/util/List;", null, null);
        after_null_check = new Label();
        method.visitInsn(1);
        method.visitVarInsn(25, 1);
        method.visitJumpInsn(166, after_null_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("filter can't be null.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_null_check);
        after_empty_check = new Label();
        method.visitInsn(3);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, "java/lang/String", "length", "()I");
        method.visitJumpInsn(160, after_empty_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("filter can't be empty.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_empty_check);
        if (this.mFilteredValuesMap != null) {
            method.visitFieldInsn(178, full_classname, "sFilteredValuesMap", "Ljava/util/HashMap;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/HashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;");
            method.visitTypeInsn(192, "java/util/ArrayList");
            method.visitVarInsn(58, 2);
            method.visitInsn(1);
            method.visitVarInsn(25, 2);
            list_null_check = new Label();
            method.visitJumpInsn(166, list_null_check);
            method.visitTypeInsn(187, "java/util/ArrayList");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
            method.visitVarInsn(58, 2);
            method.visitLabel(list_null_check);
            method.visitVarInsn(25, 2);
            method.visitInsn(176);
        } else {
            method.visitTypeInsn(187, "java/util/ArrayList");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
            method.visitInsn(176);
        }
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "hasFilteredValues", "(Ljava/lang/String;)Z", null, null);
        after_null_check = new Label();
        method.visitInsn(1);
        method.visitVarInsn(25, 1);
        method.visitJumpInsn(166, after_null_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("filter can't be null.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_null_check);
        after_empty_check = new Label();
        method.visitInsn(3);
        method.visitVarInsn(25, 1);
        method.visitMethodInsn(182, "java/lang/String", "length", "()I");
        method.visitJumpInsn(160, after_empty_check);
        method.visitTypeInsn(187, "java/lang/IllegalArgumentException");
        method.visitInsn(89);
        method.visitLdcInsn("filter can't be empty.");
        method.visitMethodInsn(183, "java/lang/IllegalArgumentException", "<init>", "(Ljava/lang/String;)V");
        method.visitInsn(191);
        method.visitLabel(after_empty_check);
        if (this.mFilteredValuesMap != null) {
            method.visitFieldInsn(178, full_classname, "sFilteredValuesMap", "Ljava/util/HashMap;");
            method.visitVarInsn(25, 1);
            method.visitMethodInsn(182, "java/util/HashMap", "containsKey", "(Ljava/lang/Object;)Z");
            method.visitInsn(172);
        } else {
            method.visitInsn(3);
            method.visitInsn(172);
        }
        method.visitMaxs(0, 0);
        method = class_writer.visitMethod(1, "getDependencies", "()Ljava/util/HashMap;", null, null);
        method.visitFieldInsn(178, full_classname, "sDependencies", "Ljava/util/HashMap;");
        method.visitInsn(176);
        method.visitMaxs(0, 0);
        class_writer.visitField(10, "sResource", "Ljava/net/URL;", null, null);
        class_writer.visitField(10, "sDependencies", "Ljava/util/HashMap;", null, null);
        for (Map.Entry entry : (Collection)blockparts_order.entrySet()) {
            ((ParsedBlockPart)entry.getValue()).visitByteCodeStaticDeclaration(class_writer, (String)entry.getKey());
        }
        if (this.mDefaultValues.size() > 0) {
            class_writer.visitField(10, "sDefaultValues", "Ljava/util/HashMap;", null, null);
        }
        if (this.mBlockDefaultValues.size() > 0) {
            class_writer.visitField(10, "sBlockDefaultValues", "Ljava/util/ArrayList;", null, null);
        }
        if (this.mValueIds.size() > 0) {
            class_writer.visitField(10, "sValueIds", "Ljava/util/HashSet;", null, null);
            class_writer.visitField(10, "sValueIdsArray", "[Ljava/lang/String;", null, null);
        }
        if (this.mFilteredBlocksMap != null) {
            class_writer.visitField(10, "sFilteredBlocksMap", "Ljava/util/HashMap;", null, null);
        }
        if (this.mFilteredValuesMap != null) {
            class_writer.visitField(10, "sFilteredValuesMap", "Ljava/util/HashMap;", null, null);
        }
        method = class_writer.visitMethod(8, "<clinit>", "()V", null, null);
        Label resource_start_label = new Label();
        Label resource_end_label = new Label();
        Label resource_handler_label = new Label();
        Label after_resource_label = new Label();
        method.visitLabel(resource_start_label);
        method.visitTypeInsn(187, "java/net/URL");
        method.visitInsn(89);
        method.visitLdcInsn(this.mResource.getProtocol());
        method.visitLdcInsn(this.mResource.getHost());
        this.addIntegerConst(method, this.mResource.getPort());
        method.visitLdcInsn(this.mResource.getFile());
        method.visitMethodInsn(183, "java/net/URL", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V");
        method.visitFieldInsn(179, full_classname, "sResource", "Ljava/net/URL;");
        method.visitLabel(resource_end_label);
        method.visitJumpInsn(167, after_resource_label);
        method.visitLabel(resource_handler_label);
        method.visitVarInsn(58, 0);
        method.visitInsn(1);
        method.visitFieldInsn(179, full_classname, "sResource", "Ljava/net/URL;");
        method.visitTryCatchBlock(resource_start_label, resource_end_label, resource_handler_label, "java/net/MalformedURLException");
        method.visitLabel(after_resource_label);
        method.visitTypeInsn(187, "java/util/HashMap");
        method.visitInsn(89);
        method.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
        method.visitFieldInsn(179, full_classname, "sDependencies", "Ljava/util/HashMap;");
        if (this.mDependencies.size() > 0) {
            for (URL url : (Collection)this.mDependencies.keySet()) {
                Label url_start_label = new Label();
                Label url_end_label = new Label();
                Label url_handler_label = new Label();
                Label after_url_label = new Label();
                method.visitLabel(url_start_label);
                method.visitFieldInsn(178, full_classname, "sDependencies", "Ljava/util/HashMap;");
                method.visitTypeInsn(187, "java/net/URL");
                method.visitInsn(89);
                method.visitLdcInsn(url.getProtocol());
                method.visitLdcInsn(url.getHost());
                this.addIntegerConst(method, url.getPort());
                method.visitLdcInsn(url.getFile());
                method.visitMethodInsn(183, "java/net/URL", "<init>", "(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)V");
                method.visitTypeInsn(187, "java/lang/Long");
                method.visitInsn(89);
                method.visitLdcInsn(new Long(this.mDependencies.get(url)));
                method.visitMethodInsn(183, "java/lang/Long", "<init>", "(J)V");
                method.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                method.visitInsn(87);
                method.visitLabel(url_end_label);
                method.visitJumpInsn(167, after_url_label);
                method.visitLabel(url_handler_label);
                method.visitVarInsn(58, 0);
                method.visitTryCatchBlock(url_start_label, url_end_label, url_handler_label, "java/net/MalformedURLException");
                method.visitLabel(after_url_label);
            }
        }
        for (Iterator entry : (Collection)blockparts_order.entrySet()) {
            ((ParsedBlockPart)entry.getValue()).visitByteCodeStaticDefinition(method, full_classname, (String)entry.getKey());
        }
        if (this.mDefaultValues.size() > 0) {
            method.visitTypeInsn(187, "java/util/HashMap");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
            method.visitFieldInsn(179, full_classname, "sDefaultValues", "Ljava/util/HashMap;");
            for (String key2 : (Collection)this.mDefaultValues.keySet()) {
                method.visitFieldInsn(178, full_classname, "sDefaultValues", "Ljava/util/HashMap;");
                method.visitLdcInsn(key2);
                method.visitLdcInsn(this.mDefaultValues.get(key2));
                method.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                method.visitInsn(87);
            }
        }
        if (this.mBlockDefaultValues.size() > 0) {
            method.visitTypeInsn(187, "java/util/ArrayList");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
            method.visitFieldInsn(179, full_classname, "sBlockDefaultValues", "Ljava/util/ArrayList;");
            for (String key2 : (Collection)this.mBlockDefaultValues) {
                method.visitFieldInsn(178, full_classname, "sBlockDefaultValues", "Ljava/util/ArrayList;");
                method.visitLdcInsn(key2);
                method.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z");
                method.visitInsn(87);
            }
        }
        if (this.mValueIds.size() > 0) {
            method.visitTypeInsn(187, "java/util/HashSet");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/HashSet", "<init>", "()V");
            method.visitFieldInsn(179, full_classname, "sValueIds", "Ljava/util/HashSet;");
            for (String id : (Collection)this.mValueIds) {
                method.visitFieldInsn(178, full_classname, "sValueIds", "Ljava/util/HashSet;");
                method.visitLdcInsn(id);
                method.visitMethodInsn(182, "java/util/HashSet", "add", "(Ljava/lang/Object;)Z");
                method.visitInsn(87);
            }
            method.visitFieldInsn(178, full_classname, "sValueIds", "Ljava/util/HashSet;");
            method.visitMethodInsn(182, "java/util/HashSet", "size", "()I");
            method.visitTypeInsn(189, "java/lang/String");
            method.visitFieldInsn(179, full_classname, "sValueIdsArray", "[Ljava/lang/String;");
            method.visitFieldInsn(178, full_classname, "sValueIds", "Ljava/util/HashSet;");
            method.visitFieldInsn(178, full_classname, "sValueIdsArray", "[Ljava/lang/String;");
            method.visitMethodInsn(182, "java/util/HashSet", "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;");
            method.visitInsn(87);
        }
        if (this.mFilteredBlocksMap != null) {
            method.visitTypeInsn(187, "java/util/HashMap");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
            method.visitFieldInsn(179, full_classname, "sFilteredBlocksMap", "Ljava/util/HashMap;");
            method.visitInsn(1);
            method.visitVarInsn(58, 0);
            FilteredTags filtered_blocks = null;
            Iterator filtered_blocks_keys_it = this.mFilteredBlocksMap.keySet().iterator();
            key2 = null;
            while (filtered_blocks_keys_it.hasNext()) {
                key2 = (String)filtered_blocks_keys_it.next();
                filtered_blocks = this.mFilteredBlocksMap.getFilteredTag(key2);
                method.visitTypeInsn(187, "java/util/ArrayList");
                method.visitInsn(89);
                method.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
                method.visitVarInsn(58, 1);
                Iterator filtered_blocks_it = filtered_blocks.iterator();
                captured_groups = null;
                while (filtered_blocks_it.hasNext()) {
                    captured_groups = (String[])filtered_blocks_it.next();
                    method.visitVarInsn(25, 1);
                    this.addIntegerConst(method, captured_groups.length);
                    method.visitTypeInsn(189, "java/lang/String");
                    int i4 = 0;
                    while (i4 < captured_groups.length) {
                        method.visitInsn(89);
                        this.addIntegerConst(method, i4);
                        method.visitLdcInsn(captured_groups[i4]);
                        method.visitInsn(83);
                        ++i4;
                    }
                    method.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z");
                    method.visitInsn(87);
                }
                method.visitFieldInsn(178, full_classname, "sFilteredBlocksMap", "Ljava/util/HashMap;");
                method.visitLdcInsn(key2);
                method.visitVarInsn(25, 1);
                method.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                method.visitInsn(87);
            }
        }
        if (this.mFilteredValuesMap != null) {
            method.visitTypeInsn(187, "java/util/HashMap");
            method.visitInsn(89);
            method.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V");
            method.visitFieldInsn(179, full_classname, "sFilteredValuesMap", "Ljava/util/HashMap;");
            method.visitInsn(1);
            method.visitVarInsn(58, 1);
            FilteredTags filtered_values = null;
            Iterator filtered_values_keys_it = this.mFilteredValuesMap.keySet().iterator();
            key2 = null;
            while (filtered_values_keys_it.hasNext()) {
                key2 = (String)filtered_values_keys_it.next();
                filtered_values = this.mFilteredValuesMap.getFilteredTag(key2);
                method.visitTypeInsn(187, "java/util/ArrayList");
                method.visitInsn(89);
                method.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V");
                method.visitVarInsn(58, 1);
                Iterator filtered_values_it = filtered_values.iterator();
                captured_groups = null;
                while (filtered_values_it.hasNext()) {
                    captured_groups = (String[])filtered_values_it.next();
                    method.visitVarInsn(25, 1);
                    this.addIntegerConst(method, captured_groups.length);
                    method.visitTypeInsn(189, "java/lang/String");
                    int i5 = 0;
                    while (i5 < captured_groups.length) {
                        method.visitInsn(89);
                        this.addIntegerConst(method, i5);
                        if (captured_groups[i5] == null) {
                            method.visitInsn(1);
                        } else {
                            method.visitLdcInsn(captured_groups[i5]);
                        }
                        method.visitInsn(83);
                        ++i5;
                    }
                    method.visitMethodInsn(182, "java/util/ArrayList", "add", "(Ljava/lang/Object;)Z");
                    method.visitInsn(87);
                }
                method.visitFieldInsn(178, full_classname, "sFilteredValuesMap", "Ljava/util/HashMap;");
                method.visitLdcInsn(key2);
                method.visitVarInsn(25, 1);
                method.visitMethodInsn(182, "java/util/HashMap", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                method.visitInsn(87);
            }
        }
        method.visitInsn(177);
        method.visitMaxs(0, 0);
        class_writer.visitEnd();
        return class_writer.toByteArray();
    }

    void setTemplateName(String templateName) {
        if (!$assertionsDisabled && templateName == null) {
            throw new AssertionError();
        }
        this.mTemplateName = templateName;
    }

    String getTemplateName() {
        return this.mTemplateName;
    }

    void setClassName(String className) {
        if (!$assertionsDisabled && className == null) {
            throw new AssertionError();
        }
        this.mClassName = className;
    }

    String getClassName() {
        return this.mClassName;
    }

    String getFullClassName() {
        if (this.mClassName != null) {
            return new StringBuffer().append(new StringBuffer().append(this.mPackage).append(".").toString()).append(this.mClassName).toString();
        }
        return null;
    }

    void setResource(URL resource) {
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError();
        }
        this.mResource = resource;
    }

    URL getResource() {
        return this.mResource;
    }

    private long getModificationTime() {
        if ((long)-1 == this.mModificationTime) {
            this.mModificationTime = Parser.getModificationTime(this.mParser.getTemplateFactory().getResourceFinder(), this.getResource());
        }
        if (!$assertionsDisabled && this.mModificationTime <= (long)0) {
            throw new AssertionError();
        }
        return this.mModificationTime;
    }

    void setBlock(String id, ParsedBlockData blockData) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && blockData == null) {
            throw new AssertionError();
        }
        this.mBlocks.put(id, blockData);
    }

    ParsedBlockData getContent() {
        return this.getBlock("");
    }

    ParsedBlockData getBlock(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        return this.mBlocks.get(id);
    }

    Collection<String> getBlockIds() {
        return this.mBlocks.keySet();
    }

    HashMap<String, ParsedBlockData> getBlocks() {
        return this.mBlocks;
    }

    void addValue(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() <= 0) {
            throw new AssertionError();
        }
        this.mValueIds.add(id);
    }

    Collection<String> getValueIds() {
        return this.mValueIds;
    }

    void setDefaultValue(String id, String value) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this.mDefaultValues.put(id, value);
    }

    void setBlockDefaultValue(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() <= 0) {
            throw new AssertionError();
        }
        this.mBlockDefaultValues.add(id);
    }

    String getDefaultValue(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() <= 0) {
            throw new AssertionError();
        }
        return this.mDefaultValues.get(id);
    }

    boolean hasDefaultValue(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() <= 0) {
            throw new AssertionError();
        }
        return this.mDefaultValues.containsKey(id);
    }

    boolean hasBlockDefaultValue(String id) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() <= 0) {
            throw new AssertionError();
        }
        return this.mBlockDefaultValues.contains(id);
    }

    HashMap<String, String> getDefaultValues() {
        return this.mDefaultValues;
    }

    ArrayList<String> getBlockDefaultValues() {
        return this.mBlockDefaultValues;
    }

    void addDependency(Parsed parsed) {
        if (!$assertionsDisabled && parsed == null) {
            throw new AssertionError();
        }
        long modification_time = -1;
        try {
            modification_time = parsed.getModificationTime();
        }
        catch (TemplateException e) {
            modification_time = -1;
        }
        this.mDependencies.put(parsed.getResource(), new Long(modification_time));
    }

    void addDependency(URL resource, Long modificationTime) {
        this.mDependencies.put(resource, modificationTime);
    }

    HashMap<URL, Long> getDependencies() {
        return this.mDependencies;
    }

    void setModificationState(String state) {
        this.mModificationState = state;
    }

    String getPackage() {
        return this.mPackage;
    }

    void setPackage(String thePackage) {
        if (!$assertionsDisabled && thePackage == null) {
            throw new AssertionError();
        }
        this.mPackage = thePackage;
    }

    void setFilteredValues(FilteredTagsMap filteredValues) {
        this.mFilteredValuesMap = filteredValues;
    }

    FilteredTagsMap getFilteredValuesMap() {
        return this.mFilteredValuesMap;
    }

    void setFilteredBlocks(FilteredTagsMap filteredBlocks) {
        this.mFilteredBlocksMap = filteredBlocks;
    }

    FilteredTagsMap getFilteredBlocksMap() {
        return this.mFilteredBlocksMap;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.Parsed");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

