/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.template;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.template.BeanHandler;
import com.uwyn.rife.template.EncoderDummy;
import com.uwyn.rife.template.ExternalValue;
import com.uwyn.rife.template.FilteredTagProcessorGroovy;
import com.uwyn.rife.template.FilteredTagProcessorJanino;
import com.uwyn.rife.template.FilteredTagProcessorOgnl;
import com.uwyn.rife.template.InternalString;
import com.uwyn.rife.template.InternalValue;
import com.uwyn.rife.template.Parser;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateEncoder;
import com.uwyn.rife.template.TemplateInitializer;
import com.uwyn.rife.template.exceptions.BeanHandlerUnsupportedException;
import com.uwyn.rife.template.exceptions.BlockUnknownException;
import com.uwyn.rife.template.exceptions.TemplateException;
import com.uwyn.rife.template.exceptions.ValueUnknownException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplate
implements Template {
    protected TemplateInitializer mInitializer = null;
    protected HashMap<String, InternalString> mFixedValues = new HashMap();
    protected HashMap<String, InternalValue> mConstructedValues = new HashMap();
    protected BeanHandler mBeanHandler = null;
    protected TemplateEncoder mEncoder = EncoderDummy.getInstance();
    protected ArrayList<ResourceBundle> mDefaultResourceBundles = null;
    protected ArrayList<ResourceBundle> mResourceBundles = null;
    protected Map<String, Object> mExpressionVars = null;
    protected String mLanguage = null;
    protected Map<String, Object> mCache = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    @Override
    public final void appendBlock(String valueId, String blockId) {
        if (valueId == null || 0 == valueId.length() || !this.hasValueId(valueId)) {
            throw new ValueUnknownException(valueId);
        }
        if (blockId == null || 0 == blockId.length()) {
            throw new BlockUnknownException(blockId);
        }
        if (this.mFixedValues.containsKey(valueId)) {
            InternalValue constructed_value = new InternalValue(this);
            constructed_value.appendText(this.mFixedValues.get(valueId));
            if (!this.appendBlockInternalForm(blockId, constructed_value)) {
                throw new BlockUnknownException(blockId);
            }
            this.mConstructedValues.put(valueId, constructed_value);
            this.mFixedValues.remove(valueId);
        } else if (this.mConstructedValues.containsKey(valueId)) {
            if (!this.appendBlockInternalForm(blockId, this.mConstructedValues.get(valueId))) {
                throw new BlockUnknownException(blockId);
            }
        } else {
            InternalValue constructed_value = new InternalValue(this);
            if (!this.appendBlockInternalForm(blockId, constructed_value)) {
                throw new BlockUnknownException(blockId);
            }
            this.mConstructedValues.put(valueId, constructed_value);
        }
    }

    @Override
    public final void setBlock(String valueId, String blockId) {
        InternalValue constructed_value;
        if (valueId == null || 0 == valueId.length() || !this.hasValueId(valueId)) {
            throw new ValueUnknownException(valueId);
        }
        if (blockId == null || 0 == blockId.length()) {
            throw new BlockUnknownException(blockId);
        }
        if (this.mFixedValues.containsKey(valueId)) {
            this.mFixedValues.remove(valueId);
        }
        if (!this.appendBlockInternalForm(blockId, constructed_value = new InternalValue(this))) {
            throw new BlockUnknownException(blockId);
        }
        this.mConstructedValues.put(valueId, constructed_value);
    }

    @Override
    public String getBlock(String id) {
        if (id == null || 0 == id.length()) {
            throw new BlockUnknownException(id);
        }
        ExternalValue result = new ExternalValue();
        if (!this.appendBlockExternalForm(id, result)) {
            throw new BlockUnknownException(id);
        }
        return result.toString();
    }

    @Override
    public final String getContent() {
        this.processLateTags();
        ExternalValue result = new ExternalValue();
        if (!this.appendBlockExternalForm("", result)) {
            throw new BlockUnknownException("");
        }
        return result.toString();
    }

    @Override
    public void writeBlock(String id, OutputStream out) throws IOException {
        this.writeBlock(id, out, null);
    }

    public void writeBlock(String id, OutputStream out, String charsetName) throws IOException {
        if (out == null) {
            return;
        }
        if (id == null || 0 == id.length()) {
            throw new BlockUnknownException(id);
        }
        ExternalValue result = new ExternalValue();
        if (!this.appendBlockExternalForm(id, result)) {
            throw new BlockUnknownException(id);
        }
        result.write(out, charsetName);
    }

    @Override
    public final void writeContent(OutputStream out) throws IOException {
        this.writeContent(out, null);
    }

    @Override
    public final void writeContent(OutputStream out, String charsetName) throws IOException {
        if (out == null) {
            return;
        }
        ExternalValue result = new ExternalValue();
        if (!this.appendBlockExternalForm("", result)) {
            throw new BlockUnknownException("");
        }
        result.write(out, charsetName);
    }

    @Override
    public final void write(OutputStream out) throws IOException {
        this.writeContent(out);
    }

    @Override
    public final List<CharSequence> getDeferredBlock(String id) {
        if (id == null || 0 == id.length()) {
            throw new BlockUnknownException(id);
        }
        ExternalValue result = new ExternalValue();
        if (!this.appendBlockExternalForm(id, result)) {
            throw new BlockUnknownException(id);
        }
        return result;
    }

    @Override
    public final List<CharSequence> getDeferredContent() {
        this.processLateTags();
        ExternalValue result = new ExternalValue();
        if (!this.appendBlockExternalForm("", result)) {
            throw new BlockUnknownException("");
        }
        return result;
    }

    private void processLateTags() {
        this.evaluateL10nTags();
        this._evaluateLangTags(null);
        this._evaluateOgnlTags(null);
        this._evaluateOgnlConfigTags(null);
        this._evaluateGroovyTags(null);
        this._evaluateGroovyConfigTags(null);
        this._evaluateJaninoTags(null);
        this._evaluateJaninoConfigTags(null);
    }

    @Override
    public void evaluateConfigTags() {
        List<String[]> config_tags = this.getFilteredValues("^CONFIG:\\s*(.*)\\s*$");
        if (config_tags != null && Config.hasRepInstance()) {
            String config_key = null;
            String config_value = null;
            for (String[] captured_groups : (Collection)config_tags) {
                if (this.isValueSet(captured_groups[0])) continue;
                config_key = captured_groups[1];
                config_value = Config.getRepInstance().getString(config_key);
                if (config_value == null) continue;
                this.setValue(captured_groups[0], this.getEncoder().encode(config_value));
            }
        }
    }

    @Override
    public void evaluateL10nTags() {
        List<String[]> l10n_tags = this.getFilteredValues("^L10N:\\s*(.*)\\s*$");
        if (l10n_tags != null && this.hasResourceBundles()) {
            String l10n_key = null;
            String l10n_value = null;
            for (String[] captured_groups : (Collection)l10n_tags) {
                if (this.isValueSet(captured_groups[0])) continue;
                l10n_key = captured_groups[1];
                l10n_value = null;
                for (ResourceBundle bundle : (Collection)this.mResourceBundles) {
                    try {
                        l10n_value = bundle.getString(l10n_key);
                        break;
                    }
                    catch (MissingResourceException e) {
                        // empty catch block
                    }
                }
                if (l10n_value == null) continue;
                this.setValue(captured_groups[0], this.getEncoder().encodeDefensive(l10n_value));
            }
        }
    }

    @Override
    public void evaluateLangTags(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null.");
        }
        this._evaluateLangTags(new StringBuffer().append("LANG:").append(id).toString());
    }

    private void _evaluateLangTags(String id) {
        List<String[]> lang_blocks = this.getFilteredBlocks("(?s)^(LANG:.*):\\s*(\\w*)\\s*$");
        String language = this.getLanguage();
        if (lang_blocks != null && language != null) {
            for (String[] lang_block : (Collection)lang_blocks) {
                String block_lang;
                if (id != null && !id.equals(lang_block[1]) || id == null && this.isValueSet(lang_block[1]) || !(block_lang = lang_block[lang_block.length - 1]).equals(language)) continue;
                this.setBlock(lang_block[1], lang_block[0]);
            }
        }
    }

    @Override
    public void evaluateExpressionTags(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null.");
        }
        this._evaluateOgnlTags(new StringBuffer().append("OGNL:").append(id).toString());
        this._evaluateGroovyTags(new StringBuffer().append("GROOVY:").append(id).toString());
        this._evaluateJaninoTags(new StringBuffer().append("JANINO:").append(id).toString());
    }

    @Override
    public void evaluateExpressionConfigTags(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id can't be null.");
        }
        this._evaluateOgnlConfigTags(new StringBuffer().append("OGNL:CONFIG:").append(id).toString());
        this._evaluateGroovyConfigTags(new StringBuffer().append("GROOVY:CONFIG:").append(id).toString());
        this._evaluateJaninoConfigTags(new StringBuffer().append("JANINO:CONFIG:").append(id).toString());
    }

    private void _evaluateOgnlTags(String id) {
        if (this.hasFilteredBlocks("(?s)^(OGNL:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$")) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.template.Template");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            FilteredTagProcessorOgnl.getInstance().processTags(this, this.getFilteredBlocks("(?s)^(OGNL:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$"), id, clazz, "template", this, null);
        }
    }

    private void _evaluateOgnlConfigTags(String id) {
        if (this.hasFilteredBlocks("(?s)^(OGNL:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$")) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.config.Config");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            FilteredTagProcessorOgnl.getInstance().processTags(this, this.getFilteredBlocks("(?s)^(OGNL:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$"), id, clazz, "config", Config.getRepInstance(), null);
        }
    }

    private void _evaluateGroovyTags(String id) {
        if (this.hasFilteredBlocks("(?s)^(GROOVY:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$")) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.template.Template");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            FilteredTagProcessorGroovy.getInstance().processTags(this, this.getFilteredBlocks("(?s)^(GROOVY:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$"), id, clazz, "template", this, null);
        }
    }

    private void _evaluateGroovyConfigTags(String id) {
        if (this.hasFilteredBlocks("(?s)^(GROOVY:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$")) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.config.Config");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            FilteredTagProcessorGroovy.getInstance().processTags(this, this.getFilteredBlocks("(?s)^(GROOVY:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$"), id, clazz, "config", Config.getRepInstance(), null);
        }
    }

    private void _evaluateJaninoTags(String id) {
        if (this.hasFilteredBlocks("(?s)^(JANINO:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$")) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.template.Template");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            FilteredTagProcessorJanino.getInstance().processTags(this, this.getFilteredBlocks("(?s)^(JANINO:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$"), id, clazz, "template", this, null);
        }
    }

    private void _evaluateJaninoConfigTags(String id) {
        if (this.hasFilteredBlocks("(?s)^(JANINO:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$")) {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.config.Config");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            FilteredTagProcessorJanino.getInstance().processTags(this, this.getFilteredBlocks("(?s)^(JANINO:CONFIG:.*):\\s*\\[\\[\\s*(.*)\\s*\\]\\]\\s*$"), id, clazz, "config", Config.getRepInstance(), null);
        }
    }

    @Override
    public final InternalValue createInternalValue() {
        return new InternalValue(this);
    }

    @Override
    public final void setValue(String id, List<CharSequence> deferredContent) {
        if (id == null || 0 == id.length() || !this.hasValueId(id)) {
            throw new ValueUnknownException(id);
        }
        if (this.mFixedValues.containsKey(id)) {
            this.mFixedValues.remove(id);
        }
        this.mConstructedValues.put(id, new InternalValue(this, deferredContent));
    }

    @Override
    public final void setValue(String id, InternalValue internalValue) {
        if (id == null || 0 == id.length() || !this.hasValueId(id)) {
            throw new ValueUnknownException(id);
        }
        if (internalValue == null) {
            internalValue = this.createInternalValue();
        }
        if (this.mFixedValues.containsKey(id)) {
            this.mFixedValues.remove(id);
        }
        this.mConstructedValues.put(id, internalValue);
    }

    @Override
    public final void setValue(String id, Template template2) {
        if (template2 == null) {
            this.setValue(id, "");
        }
        this.setValue(id, template2.getContent());
    }

    @Override
    public final void setValue(String id, Object value) {
        this.setValue(id, String.valueOf(value));
    }

    @Override
    public final void setValue(String id, boolean value) {
        this.setValue(id, String.valueOf(value));
    }

    @Override
    public final void setValue(String id, char value) {
        this.setValue(id, String.valueOf(value));
    }

    @Override
    public final void setValue(String id, char[] value) {
        this.setValue(id, String.valueOf(value));
    }

    @Override
    public final void setValue(String id, char[] value, int offset, int count) {
        this.setValue(id, String.valueOf(value, offset, count));
    }

    @Override
    public final void setValue(String id, double value) {
        this.setValue(id, String.valueOf(value));
    }

    @Override
    public final void setValue(String id, float value) {
        this.setValue(id, String.valueOf(value));
    }

    @Override
    public final void setValue(String id, int value) {
        this.setValue(id, String.valueOf(value));
    }

    @Override
    public final void setValue(String id, long value) {
        this.setValue(id, String.valueOf(value));
    }

    @Override
    public final void setValue(String id, String value) {
        if (id == null || 0 == id.length() || !this.hasValueId(id)) {
            throw new ValueUnknownException(id);
        }
        if (value == null) {
            value = "";
        }
        this.mFixedValues.remove(id);
        this.mConstructedValues.remove(id);
        this.mFixedValues.put(id, new InternalString(value));
    }

    @Override
    public void setBean(Object bean) {
        this.setBean(bean, null, true);
    }

    @Override
    public void setBean(Object bean, String prefix) {
        this.setBean(bean, prefix, true);
    }

    @Override
    public void setBean(Object bean, String prefix, boolean encode) {
        if (this.mBeanHandler == null) {
            throw new BeanHandlerUnsupportedException(this, bean);
        }
        this.mBeanHandler.setBean(this, bean, prefix, encode);
    }

    @Override
    public void removeBean(Object bean) {
        this.removeBean(bean, null);
    }

    @Override
    public void removeBean(Object bean, String prefix) {
        if (this.mBeanHandler == null) {
            throw new BeanHandlerUnsupportedException(this, bean);
        }
        this.mBeanHandler.removeBean(this, bean, prefix);
    }

    @Override
    public final void appendValue(String id, Object value) {
        this.appendValue(id, String.valueOf(value));
    }

    @Override
    public final void appendValue(String id, boolean value) {
        this.appendValue(id, String.valueOf(value));
    }

    @Override
    public final void appendValue(String id, char value) {
        this.appendValue(id, String.valueOf(value));
    }

    @Override
    public final void appendValue(String id, char[] value) {
        this.appendValue(id, String.valueOf(value));
    }

    @Override
    public final void appendValue(String id, char[] value, int offset, int count) {
        this.appendValue(id, String.valueOf(value, offset, count));
    }

    @Override
    public final void appendValue(String id, double value) {
        this.appendValue(id, String.valueOf(value));
    }

    @Override
    public final void appendValue(String id, float value) {
        this.appendValue(id, String.valueOf(value));
    }

    @Override
    public final void appendValue(String id, int value) {
        this.appendValue(id, String.valueOf(value));
    }

    @Override
    public final void appendValue(String id, long value) {
        this.appendValue(id, String.valueOf(value));
    }

    @Override
    public final void appendValue(String id, String value) {
        if (id == null || 0 == id.length() || !this.hasValueId(id)) {
            throw new ValueUnknownException(id);
        }
        if (value == null) {
            return;
        }
        if (this.mFixedValues.containsKey(id)) {
            this.mFixedValues.get(id).append(value);
        } else if (this.mConstructedValues.containsKey(id)) {
            this.mConstructedValues.get(id).appendText(value);
        } else {
            this.mFixedValues.put(id, new InternalString(value));
        }
    }

    @Override
    public final String getValue(String id) {
        if (id == null || 0 == id.length() || !this.hasValueId(id)) {
            throw new ValueUnknownException(id);
        }
        if (this.mFixedValues.containsKey(id)) {
            return this.mFixedValues.get(id).toString();
        }
        if (this.mConstructedValues.containsKey(id)) {
            ExternalValue result = new ExternalValue();
            this.mConstructedValues.get(id).appendExternalForm(result);
            return result.toString();
        }
        return this.getDefaultValue(id);
    }

    @Override
    public abstract String getDefaultValue(String var1);

    @Override
    public boolean hasDefaultValue(String id) {
        return this.getDefaultValue(id) != null;
    }

    @Override
    public abstract List<String[]> getFilteredBlocks(String var1);

    @Override
    public abstract boolean hasFilteredBlocks(String var1);

    @Override
    public abstract List<String[]> getFilteredValues(String var1);

    @Override
    public abstract boolean hasFilteredValues(String var1);

    @Override
    public final boolean hasBlock(String id) {
        if (id == null || 0 == id.length()) {
            return false;
        }
        ExternalValue temp_value = new ExternalValue();
        return this.appendBlockExternalForm(id, temp_value);
    }

    @Override
    public final boolean isValueSet(String id) {
        if (id == null || 0 == id.length()) {
            return false;
        }
        return this.mFixedValues.containsKey(id) || this.mConstructedValues.containsKey(id);
    }

    @Override
    public final int countValues() {
        return this.mFixedValues.size() + this.mConstructedValues.size();
    }

    @Override
    public final void removeValue(String id) {
        if (id == null || 0 == id.length() || !this.hasValueId(id)) {
            throw new ValueUnknownException(id);
        }
        this.mFixedValues.remove(id);
        this.mConstructedValues.remove(id);
    }

    @Override
    public final void clear() {
        this.mFixedValues = new HashMap();
        this.mConstructedValues = new HashMap();
        this.mResourceBundles = null;
        if (this.mDefaultResourceBundles != null) {
            this.mResourceBundles = new ArrayList<ResourceBundle>(this.mDefaultResourceBundles);
        }
        this.initialize();
    }

    @Override
    public abstract String[] getAvailableValueIds();

    @Override
    public abstract Collection<String> getUnsetValueIds();

    @Override
    public abstract boolean hasValueId(String var1);

    @Override
    public abstract long getModificationTime();

    protected AbstractTemplate() {
    }

    protected void appendTextInternal(InternalValue value, CharSequence text) {
        value.appendText(text);
    }

    protected void increasePartsCapacityInternal(InternalValue value, int size) {
        value.increasePartsCapacity(size);
    }

    protected void increaseValuesCapacityInternal(InternalValue value, int size) {
        value.increaseValuesCapacity(size);
    }

    protected abstract boolean appendBlockExternalForm(String var1, ExternalValue var2);

    protected abstract boolean appendBlockInternalForm(String var1, InternalValue var2);

    protected final void appendValueExternalForm(String id, String tag, ExternalValue result) {
        if (!$assertionsDisabled && id == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && id.length() == 0) {
            throw new AssertionError();
        }
        InternalString fixed_value = this.mFixedValues.get(id);
        if (fixed_value != null) {
            result.append(fixed_value);
            return;
        }
        InternalValue constructed_value = this.mConstructedValues.get(id);
        if (constructed_value != null) {
            constructed_value.appendExternalForm(result);
            return;
        }
        if (!this.appendDefaultValueExternalForm(id, result)) {
            result.append(tag);
        }
    }

    protected abstract boolean appendDefaultValueExternalForm(String var1, ExternalValue var2);

    protected final void appendValueInternalForm(String id, String tag, InternalValue result) {
        InternalString fixed_value = this.mFixedValues.get(id);
        if (fixed_value != null) {
            result.appendText(fixed_value);
            return;
        }
        InternalValue constructed_value = this.mConstructedValues.get(id);
        if (constructed_value != null) {
            result.appendConstructedValue(constructed_value);
            return;
        }
        if (!this.appendDefaultValueInternalForm(id, result)) {
            result.appendValueId(id, tag);
        }
    }

    protected abstract boolean appendDefaultValueInternalForm(String var1, InternalValue var2);

    @Override
    public final BeanHandler getBeanHandler() {
        return this.mBeanHandler;
    }

    final void setBeanHandler(BeanHandler beanHandler) {
        this.mBeanHandler = beanHandler;
    }

    @Override
    public final TemplateEncoder getEncoder() {
        return this.mEncoder;
    }

    final void setEncoder(TemplateEncoder encoder) {
        this.mEncoder = encoder == null ? EncoderDummy.getInstance() : encoder;
    }

    void setDefaultResourceBundles(ArrayList<ResourceBundle> bundles) {
        this.mDefaultResourceBundles = bundles;
        if (bundles != null) {
            this.mResourceBundles = new ArrayList<ResourceBundle>(bundles);
        }
    }

    @Override
    public final void addResourceBundle(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return;
        }
        if (this.mResourceBundles == null) {
            this.mResourceBundles = new ArrayList();
        }
        this.mResourceBundles.add(resourceBundle);
    }

    @Override
    public final Collection<ResourceBundle> getResourceBundles() {
        if (this.mResourceBundles == null) {
            this.mResourceBundles = new ArrayList();
        }
        return this.mResourceBundles;
    }

    @Override
    public final boolean hasResourceBundles() {
        return this.mResourceBundles != null && this.mResourceBundles.size() > 0;
    }

    @Override
    public void setLanguage(String lang) {
        this.mLanguage = lang;
    }

    @Override
    public String getLanguage() {
        if (this.mLanguage == null) {
            return RifeConfig.Tools.getDefaultLanguage();
        }
        return this.mLanguage;
    }

    @Override
    public void setExpressionVar(String name, Object value) {
        if (this.mExpressionVars == null) {
            this.mExpressionVars = new HashMap<String, Object>();
        }
        this.mExpressionVars.put(name, value);
    }

    @Override
    public void setExpressionVars(Map<String, Object> map) {
        this.mExpressionVars = map;
    }

    @Override
    public Map<String, Object> getExpressionVars() {
        return this.mExpressionVars;
    }

    final void initialize() {
        this.evaluateConfigTags();
        this.evaluateL10nTags();
        if (this.mInitializer == null) {
            return;
        }
        this.mInitializer.initialize(this);
    }

    final void setInitializer(TemplateInitializer initializer) {
        this.mInitializer = initializer;
    }

    @Override
    public void cacheObject(String key, Object value) {
        if (key == null) {
            return;
        }
        if (this.mCache == null) {
            this.mCache = new HashMap<String, Object>();
        }
        this.mCache.put(key, value);
    }

    @Override
    public Object getCacheObject(String key) {
        if (this.mCache == null) {
            return null;
        }
        return this.mCache.get(key);
    }

    protected static boolean isTemplateClassModified(URL templateResource, long templateModificationTime, Map templateDependencies, String templateModificationState, ResourceFinder resourceFinder, String modificationState) {
        try {
            if (Parser.getModificationTime(resourceFinder, templateResource) > templateModificationTime) {
                return true;
            }
            if (templateDependencies.size() > 0) {
                Iterator url_it = templateDependencies.keySet().iterator();
                URL dependency_resource = null;
                while (url_it.hasNext()) {
                    dependency_resource = (URL)url_it.next();
                    if (Parser.getModificationTime(resourceFinder, dependency_resource) <= (Long)templateDependencies.get(dependency_resource)) continue;
                    return true;
                }
            }
            if (templateModificationState != null || modificationState != null) {
                if (templateModificationState == null || modificationState == null) {
                    return true;
                }
                if (!templateModificationState.equals(modificationState)) {
                    return true;
                }
            }
        }
        catch (TemplateException e) {
            return false;
        }
        return false;
    }

    @Override
    public Template clone() {
        AbstractTemplate new_template = null;
        try {
            new_template = (AbstractTemplate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            new_template = null;
        }
        new_template.mFixedValues = new HashMap();
        for (String value_id : (Collection)this.mFixedValues.keySet()) {
            new_template.mFixedValues.put(value_id, this.mFixedValues.get(value_id));
        }
        new_template.mConstructedValues = new HashMap();
        for (String constructed_value_id : (Collection)this.mConstructedValues.keySet()) {
            new_template.mConstructedValues.put(constructed_value_id, this.mConstructedValues.get(constructed_value_id));
        }
        if (this.mExpressionVars != null) {
            new_template.mExpressionVars = new HashMap<String, Object>(this.mExpressionVars);
        }
        return new_template;
    }

    @Override
    public /* synthetic */ Object clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.template.AbstractTemplate");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

