/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing.documents;

import java.awt.Toolkit;
import java.text.StringCharacterIterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CharFilterDocument
extends PlainDocument {
    public static final int VALID = 0;
    public static final int INVALID = 1;
    private String mChars = null;
    private int mFilterType = -1;
    private int mMaxChars = 0;

    public CharFilterDocument(String chars, int filterType) {
        this(chars, filterType, 0);
    }

    public CharFilterDocument(String chars, int filterType, int maxChars) {
        this.mChars = chars;
        this.mFilterType = filterType;
        this.mMaxChars = maxChars;
    }

    public void insertString(int offset, String origString, AttributeSet attributes) throws BadLocationException {
        StringBuffer filtered_string = new StringBuffer(this.filterString(origString));
        if (this.mMaxChars > 0 && this.getLength() + filtered_string.length() > this.mMaxChars) {
            filtered_string.setLength(this.mMaxChars - this.getLength());
        }
        if (origString.length() != filtered_string.length()) {
            Toolkit.getDefaultToolkit().beep();
        }
        super.insertString(offset, filtered_string.toString(), attributes);
    }

    private String filterString(String origString) {
        StringBuffer filtered_string = new StringBuffer();
        StringCharacterIterator it = new StringCharacterIterator(origString);
        StringBuffer stringBuffer = filtered_string;
        synchronized (stringBuffer) {
            while ('\uffff' != it.current()) {
                if (0 == this.mFilterType) {
                    if (-1 != this.mChars.indexOf(it.current())) {
                        filtered_string.append(it.current());
                    }
                } else if (1 == this.mFilterType && -1 == this.mChars.indexOf(it.current())) {
                    filtered_string.append(it.current());
                }
                it.next();
            }
            return filtered_string.toString();
        }
    }
}

