/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import com.uwyn.rife.tools.SortListComparables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Lookandfeel {
    private static final String LAF_GTK_CLASS = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static final String LAF_MAC_CLASS = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final String LAF_METAL_CLASS = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String LAF_MOTIF_CLASS = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String LAF_WINDOWS_CLASS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String LAF_KUNSTSTOFF_CLASS = "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
    private static final String LAF_ALLOY_CLASS = "com.incors.plaf.alloy.AlloyLookAndFeel";
    private static final String LAF_COMPIERE_CLASS = "org.compiere.plaf.CompiereLookAndFeel";
    private static final String LAF_JGOODIES_WINDOWS_CLASS = "com.jgoodies.plaf.windows.ExtWindowsLookAndFeel";
    private static final String LAF_JGOODIES_PLASTIC_CLASS = "com.jgoodies.plaf.plastic.PlasticLookAndFeel";
    private static final String LAF_JGOODIES_PLASTIC3D_CLASS = "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel";
    private static final String LAF_JGOODIES_PLASTICXP_CLASS = "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel";
    private static final String LAF_METOUIA_CLASS = "net.sourceforge.mlf.metouia.MetouiaLookAndFeel";
    private static final String LAF_OYOAHA_CLASS = "com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel";
    private static final String LAF_SLAF_CLASS = "com.memoire.slaf.SlafLookAndFeel";
    private static final String[] JDK_LAFS = new String[]{"com.sun.java.swing.plaf.gtk.GTKLookAndFeel", "com.sun.java.swing.plaf.mac.MacLookAndFeel", "javax.swing.plaf.metal.MetalLookAndFeel", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", "com.sun.java.swing.plaf.windows.WindowsLookAndFeel", "com.incors.plaf.kunststoff.KunststoffLookAndFeel", "com.incors.plaf.alloy.AlloyLookAndFeel", "org.compiere.plaf.CompiereLookAndFeel", "com.jgoodies.plaf.windows.ExtWindowsLookAndFeel", "com.jgoodies.plaf.plastic.PlasticLookAndFeel", "com.jgoodies.plaf.plastic.Plastic3DLookAndFeel", "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel", "net.sourceforge.mlf.metouia.MetouiaLookAndFeel", "com.oyoaha.swing.plaf.oyoaha.OyoahaLookAndFeel", "com.memoire.slaf.SlafLookAndFeel"};

    public static Map<String, String> getAvailableLookAndFeels() {
        HashSet<String> classnames = new HashSet<String>();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n];
            classnames.add(info.getClassName());
            ++n;
        }
        String[] stringArray = JDK_LAFS;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String classname = stringArray[n2];
            classnames.add(classname);
            ++n2;
        }
        ArrayList<String> supported_names = new ArrayList<String>();
        HashMap<String, String> supported_mappings = new HashMap<String, String>();
        Class<?> laf_class = null;
        String laf_name = null;
        LookAndFeel lookandfeel = null;
        for (String classname : (Collection)classnames) {
            try {
                laf_class = Class.forName(classname);
                lookandfeel = (LookAndFeel)laf_class.newInstance();
                laf_name = lookandfeel.getName();
                if (!lookandfeel.isSupportedLookAndFeel()) continue;
                supported_names.add(laf_name);
                supported_mappings.put(laf_name, classname);
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
        SortListComparables sort = new SortListComparables();
        sort.sort(supported_names);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String name : (Collection)supported_names) {
            result.put(name, (String)supported_mappings.get(name));
        }
        return result;
    }
}

