/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import com.uwyn.rife.tools.StringUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JMultiLabel
extends JPanel
implements ComponentListener {
    private String mMessageText = null;
    private Font mMessageFont = null;
    private FontMetrics mMessageFontMetrics = null;
    private Color mMessageColor = null;
    private int mWrapWidth = 0;
    private boolean mAutoWrap = false;
    private ArrayList<TextLayout> mTextLayouts = null;
    private double mTextWidth = 0.0;
    private double mTextHeight = 0.0;
    private int mCachedWidth = -1;

    public JMultiLabel() {
        this("");
    }

    public JMultiLabel(String messageText) {
        this(messageText, 0);
    }

    public JMultiLabel(String messageText, int wrapWidth) {
        this.mMessageText = messageText;
        this.setOpaque(false);
        this.addComponentListener(this);
        this.setFont(UIManager.getFont("Label.font"));
        this.setWrapWidth(wrapWidth);
    }

    public void setMessageText(String messageText) {
        this.mMessageText = messageText;
        this.mCachedWidth = -1;
    }

    public void setWrapWidth(int wrapWidth) {
        this.mWrapWidth = wrapWidth;
        this.mCachedWidth = -1;
    }

    public void setAutoWrap(boolean autoWrap) {
        this.mAutoWrap = autoWrap;
    }

    public void setFont(Font font) {
        this.mCachedWidth = -1;
        this.mMessageFont = font;
    }

    public Font getFont() {
        return this.mMessageFont;
    }

    public void setColor(Color color) {
        this.mMessageColor = color;
    }

    public Dimension getPreferredSize() {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.ensureValidLayouts(g2);
        Dimension dimension = null;
        Border border = this.getBorder();
        if (border == null) {
            dimension = new Dimension((int)Math.ceil(this.mTextWidth), (int)Math.ceil(this.mTextHeight));
        } else {
            Insets border_insets = border.getBorderInsets(this);
            dimension = new Dimension((int)Math.ceil(this.mTextWidth) + border_insets.left + border_insets.right, (int)Math.ceil(this.mTextHeight) + border_insets.top + border_insets.bottom);
        }
        return dimension;
    }

    private int getWrappingWidth() {
        if (this.mWrapWidth <= 0) {
            int width;
            if (!this.mAutoWrap) {
                return Integer.MAX_VALUE;
            }
            Border border = this.getBorder();
            int border_horiz = 0;
            if (border != null) {
                Insets border_insets = border.getBorderInsets(this);
                border_horiz = border_insets.left + border_insets.right;
            }
            if ((width = super.getWidth() - border_horiz) <= 0) {
                width = Integer.MAX_VALUE;
            }
            return width;
        }
        return this.mWrapWidth;
    }

    public Dimension getMinimumSize() {
        Dimension minimum_size = super.getMinimumSize();
        Dimension preferred_size = this.getPreferredSize();
        return new Dimension((int)Math.ceil(minimum_size.getWidth()), (int)Math.ceil(preferred_size.getHeight()));
    }

    public Dimension getMaximumSize() {
        return super.getMaximumSize();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintMessage((Graphics2D)g);
    }

    private void addTextLayout(TextLayout layout) {
        double layout_width;
        this.mTextLayouts.add(layout);
        if (this.mTextHeight != 0.0) {
            this.mTextHeight += (double)layout.getLeading();
        }
        if ((layout_width = layout.getBounds().getWidth() + 1.0) > this.mTextWidth) {
            this.mTextWidth = layout_width;
        }
        this.mTextHeight += (double)(layout.getAscent() + layout.getDescent());
    }

    private void ensureValidLayouts(Graphics2D g2) {
        int wrapping_width = this.getWrappingWidth();
        if (this.mCachedWidth == wrapping_width) {
            return;
        }
        this.mTextLayouts = new ArrayList();
        FontRenderContext render_context = g2.getFontRenderContext();
        if (this.mMessageText == null || 0 == this.mMessageText.length()) {
            TextLayout layout = new TextLayout(" ", this.mMessageFont, render_context);
            this.mTextLayouts.add(layout);
            this.mTextWidth = 0.0;
            this.mTextHeight = 0.0;
        } else {
            ArrayList<String> lines = StringUtils.split(this.mMessageText.toString(), "\n");
            int newline_count = lines.size();
            int character_count = 0;
            boolean line_count = false;
            Iterator iterator = ((Collection)lines).iterator();
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                character_count += line.length();
            }
            TextLayout layout = null;
            if (0 == character_count) {
                int i = 0;
                while (i < newline_count) {
                    layout = new TextLayout(" ", this.getFont(), render_context);
                    this.addTextLayout(layout);
                    ++i;
                }
            } else {
                this.mTextWidth = 0.0;
                this.mTextHeight = 0.0;
                boolean current_newline = false;
                Iterator iterator2 = ((Collection)lines).iterator();
                block4: while (iterator2.hasNext()) {
                    String line = (String)iterator2.next();
                    if (0 == line.length()) {
                        layout = new TextLayout(" ", this.getFont(), render_context);
                        this.addTextLayout(layout);
                        continue;
                    }
                    AttributedString attributed_string = new AttributedString(line.toString());
                    attributed_string.addAttribute(TextAttribute.FONT, this.getFont());
                    AttributedCharacterIterator iterator3 = attributed_string.getIterator();
                    LineBreakMeasurer measurer = new LineBreakMeasurer(iterator3, render_context);
                    while (measurer.getPosition() < iterator3.getEndIndex()) {
                        try {
                            layout = measurer.nextLayout(wrapping_width);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            continue block4;
                        }
                        this.addTextLayout(layout);
                    }
                }
            }
        }
        this.mCachedWidth = Integer.MAX_VALUE != wrapping_width ? -1 : wrapping_width;
    }

    public boolean paintMessage(Graphics2D g2) {
        Object previous_aliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object previous_textaliasing = g2.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        Color previous_color = g2.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(this.mMessageColor);
        this.ensureValidLayouts(g2);
        Border border = this.getBorder();
        int border_x = 0;
        int border_y = 0;
        if (border != null) {
            Insets border_insets = border.getBorderInsets(this);
            border_x = border_insets.left;
            border_y = border_insets.top;
        }
        boolean all_lines_shown = true;
        if (this.mTextLayouts != null && this.mTextLayouts.size() > 0) {
            float x = border_x;
            float y1 = border_y;
            float y2 = -1;
            Iterator iterator = ((Collection)this.mTextLayouts).iterator();
            while (iterator.hasNext()) {
                int height;
                TextLayout layout = (TextLayout)iterator.next();
                y2 = (y1 += layout.getAscent()) + layout.getDescent();
                if (y2 > (float)(height = this.getHeight())) {
                    all_lines_shown = false;
                    break;
                }
                layout.draw(g2, x, y1);
                y1 = y2 + layout.getLeading();
            }
        }
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, previous_textaliasing);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, previous_aliasing);
        g2.setColor(previous_color);
        return all_lines_shown;
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        if (this.mAutoWrap) {
            this.mWrapWidth = 0;
            this.mCachedWidth = -1;
        }
    }
}

