/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.swing.Colors;
import com.uwyn.rife.swing.DefaultFocusSetter;
import com.uwyn.rife.swing.DefaultFocused;
import com.uwyn.rife.swing.Images;
import com.uwyn.rife.swing.JDialog;
import com.uwyn.rife.tools.Localization;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class JDialogYesNo
extends JDialog
implements ActionListener,
DefaultFocused {
    public static final int OK = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    protected GridBagConstraints mConstraints = null;
    protected JFrame mParentFrame = null;
    protected JPanel mContentPane = null;
    protected JLabel mConfirmationIcon = null;
    protected JPanel mConfirmationIconPanel = null;
    protected JComponent mConfirmationMessage = null;
    protected JButton mYesButton = null;
    protected JButton mNoButton = null;
    protected JButton mCancelButton = null;
    protected JPanel mButtonsPanel = null;
    protected int mPerformedAction = 2;

    public JDialogYesNo(JFrame frame, String text) {
        this(frame, Localization.getString("rife.dialog.yesno.title"), text);
    }

    public JDialogYesNo(JFrame frame, String title, String text) {
        this(frame, title, new JLabel(text));
    }

    public JDialogYesNo(JFrame frame, String title, JComponent messageComponent) {
        super(frame, title, true);
        this.mParentFrame = frame;
        this.mConfirmationIcon = new JLabel(Images.getRepInstance().getImageIcon(RifeConfig.Swing.getIconConfirmPath()));
        this.mConfirmationIcon.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, (Color)null));
        this.mConfirmationIcon.setBackground(Colors.CONFIRM_BACKGROUND);
        this.mConfirmationIcon.setOpaque(true);
        this.mConfirmationIconPanel = new JPanel();
        this.mConfirmationIconPanel.setBackground(Colors.CONFIRM_BACKGROUND);
        this.mConfirmationIconPanel.add(this.mConfirmationIcon);
        this.mConfirmationMessage = messageComponent;
        this.mConfirmationMessage.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mYesButton = new JButton();
        this.mYesButton.addActionListener(this);
        this.mNoButton = new JButton();
        this.mNoButton.addActionListener(this);
        this.mCancelButton = new JButton();
        this.mCancelButton.addActionListener(this);
        this.mButtonsPanel = new JPanel(new FlowLayout(2));
        this.setButtonLabels();
        this.mButtonsPanel.add(this.mYesButton);
        this.mButtonsPanel.add(this.mNoButton);
        this.mButtonsPanel.add(this.mCancelButton);
        this.mContentPane = new JPanel(new GridBagLayout());
        this.mContentPane.setBackground(Color.white);
        this.setContentPane(this.mContentPane);
        this.mConstraints = new GridBagConstraints();
        this.mConstraints.gridx = 0;
        this.mConstraints.gridy = 0;
        this.mConstraints.gridwidth = 1;
        this.mConstraints.gridheight = 1;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.anchor = 10;
        this.mConstraints.fill = 1;
        this.mContentPane.add((Component)this.mConfirmationIconPanel, this.mConstraints);
        this.mConstraints.gridx = 1;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.anchor = 18;
        this.mConstraints.fill = 2;
        this.mContentPane.add((Component)this.mConfirmationMessage, this.mConstraints);
        this.mConstraints.gridx = 0;
        this.mConstraints.gridy = 1;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.gridwidth = 2;
        this.mContentPane.add((Component)new JSeparator(0), this.mConstraints);
        this.mConstraints.gridy = 2;
        this.mContentPane.add((Component)this.mButtonsPanel, this.mConstraints);
        this.mContentPane.setVisible(true);
        this.pack();
        this.setDefaultCloseOperation(2);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        }
        new DefaultFocusSetter(this);
    }

    public JComponent getDefaultFocus() {
        return this.mYesButton;
    }

    protected void setButtonLabels() {
        this.mYesButton.setText(Localization.getString("rife.dialog.yesno.yesbutton"));
        this.mYesButton.setMnemonic(Localization.getChar("rife.dialog.yesno.yesbutton.mnemonic"));
        this.mNoButton.setText(Localization.getString("rife.dialog.yesno.nobutton"));
        this.mNoButton.setMnemonic(Localization.getChar("rife.dialog.yesno.nobutton.mnemonic"));
        this.mCancelButton.setText(Localization.getString("rife.dialog.confirm.cancelbutton"));
        this.mCancelButton.setMnemonic(Localization.getChar("rife.dialog.confirm.cancelbutton.mnemonic"));
    }

    public int getPerformedAction() {
        return this.mPerformedAction;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.mYesButton == source) {
            this.mPerformedAction = 0;
            this.dispose();
        } else if (this.mNoButton == source) {
            this.mPerformedAction = 1;
            this.dispose();
        } else if (this.mCancelButton == source) {
            this.mPerformedAction = 2;
            this.dispose();
        }
    }
}

