/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.swing.Colors;
import com.uwyn.rife.swing.DefaultFocusSetter;
import com.uwyn.rife.swing.DefaultFocused;
import com.uwyn.rife.swing.Images;
import com.uwyn.rife.swing.JDialog;
import com.uwyn.rife.tools.Localization;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class JDialogInfo
extends JDialog
implements ActionListener,
DefaultFocused {
    protected GridBagConstraints mConstraints = null;
    protected JPanel mContentPane = null;
    protected JLabel mInfoIcon = new JLabel(Images.getRepInstance().getImageIcon(RifeConfig.Swing.getIconInfoPath()));
    protected JPanel mInfoIconPanel = null;
    protected JComponent mInfoMessage = null;
    protected JButton mOkButton = null;
    protected JPanel mButtonsPanel = null;

    public JDialogInfo(JFrame frame, String text) {
        this(frame, Localization.getString("rife.dialog.info.title"), text);
    }

    public JDialogInfo(JFrame frame, String title, String text) {
        this(frame, title, new JLabel(text));
    }

    public JDialogInfo(JFrame frame, String title, JComponent messageComponent) {
        super(frame, title, true);
        this.mInfoIcon.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, (Color)null));
        this.mInfoIcon.setBackground(Colors.INFO_BACKGROUND);
        this.mInfoIcon.setOpaque(true);
        this.mInfoIconPanel = new JPanel();
        this.mInfoIconPanel.setBackground(Colors.INFO_BACKGROUND);
        this.mInfoIconPanel.add(this.mInfoIcon);
        this.mInfoMessage = messageComponent;
        this.mInfoMessage.setBorder(BorderFactory.createMatteBorder(10, 10, 10, 10, (Color)null));
        this.mOkButton = new JButton(Localization.getString("rife.dialog.info.okbutton"));
        this.mOkButton.setMnemonic(Localization.getChar("rife.dialog.info.okbutton.mnemonic"));
        this.mOkButton.addActionListener(this);
        this.mButtonsPanel = new JPanel(new FlowLayout(2));
        this.mButtonsPanel.add(this.mOkButton);
        this.mContentPane = new JPanel(new GridBagLayout());
        this.mContentPane.setBackground(Color.white);
        this.setContentPane(this.mContentPane);
        this.mConstraints = new GridBagConstraints();
        this.mConstraints.gridx = 0;
        this.mConstraints.gridy = 0;
        this.mConstraints.gridwidth = 1;
        this.mConstraints.gridheight = 1;
        this.mConstraints.weightx = 0.0;
        this.mConstraints.weighty = 1.0;
        this.mConstraints.anchor = 10;
        this.mConstraints.fill = 1;
        this.mContentPane.add((Component)this.mInfoIconPanel, this.mConstraints);
        this.mConstraints.gridx = 1;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.anchor = 18;
        this.mConstraints.fill = 2;
        this.mContentPane.add((Component)this.mInfoMessage, this.mConstraints);
        this.mConstraints.gridx = 0;
        this.mConstraints.gridy = 1;
        this.mConstraints.weightx = 1.0;
        this.mConstraints.weighty = 0.0;
        this.mConstraints.gridwidth = 2;
        this.mContentPane.add((Component)new JSeparator(0), this.mConstraints);
        this.mConstraints.gridy = 2;
        this.mContentPane.add((Component)this.mButtonsPanel, this.mConstraints);
        this.mContentPane.setVisible(true);
        this.pack();
        this.setDefaultCloseOperation(0);
        if (frame != null) {
            this.setLocationRelativeTo(frame);
        }
        new DefaultFocusSetter(this);
    }

    public JComponent getDefaultFocus() {
        return this.mOkButton;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (this.mOkButton == source) {
            this.dispose();
        }
    }

    public void safeShow() {
        SwingUtilities.invokeLater(new DialogShowThread(this));
    }

    public class DialogShowThread
    extends Thread {
        JDialog mDialog = null;

        public DialogShowThread(JDialog dialog) {
            this.mDialog = dialog;
        }

        public void run() {
            this.mDialog.setVisible(true);
        }

        static /* synthetic */ JDialogInfo access$0(DialogShowThread dialogShowThread) {
            return dialogShowThread.JDialogInfo.this;
        }
    }
}

