/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.swing;

import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.swing.Images;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cursors {
    private String mPath = null;
    private HashMap<String, Cursor> mCursors = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    public Cursors() {
        this.mCursors = new HashMap();
    }

    public Cursors(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path can't be null.");
        }
        if (0 == path.length()) {
            throw new IllegalArgumentException("path can't be empty.");
        }
        this.mPath = path;
        this.initialize();
        if (!$assertionsDisabled && this.mPath == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mPath.length() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.mCursors == null) {
            throw new AssertionError();
        }
    }

    private void initialize() {
        Images images = Images.getRepInstance();
        this.mCursors = new HashMap();
        Point hotspot = new Point(6, 6);
        String cursor_filename_short = null;
        for (String cursor_filename : (Collection)images.getImageIconNames(this.mPath)) {
            cursor_filename_short = cursor_filename.substring(this.mPath.length(), cursor_filename.length() - 4);
            Image icon_image = images.getImageIcon(cursor_filename).getImage();
            this.mCursors.put(cursor_filename_short, Toolkit.getDefaultToolkit().createCustomCursor(icon_image, hotspot, cursor_filename_short));
        }
    }

    public static boolean hasRepInstance() {
        return Rep.hasParticipant("ParticipantCursors");
    }

    public static Cursors getRepInstance() {
        Participant participant = Rep.getParticipant("ParticipantCursors");
        if (participant == null) {
            return null;
        }
        return (Cursors)participant.getObject();
    }

    public Cursor getCursor(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path can't be null.");
        }
        return this.mCursors.get(path);
    }

    public ArrayList<String> getCursorNames(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix can't be null.");
        }
        ArrayList<String> matching_cursors = new ArrayList<String>();
        for (String cursor_filename : (Collection)this.mCursors.keySet()) {
            if (!cursor_filename.startsWith(prefix)) continue;
            matching_cursors.add(cursor_filename);
        }
        return matching_cursors;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.swing.Cursors");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

