/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.tools.ArrayUtils;
import com.uwyn.rife.tools.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Format;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class ValidityChecks {
    public static boolean checkNotNull(Object value) {
        return value != null;
    }

    public static boolean checkNotEmpty(CharSequence value) {
        if (value == null) {
            return true;
        }
        String value_string = value.toString();
        return 0 != StringUtils.trim(value_string).length();
    }

    public static boolean checkNotEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof CharSequence) {
            return ValidityChecks.checkNotEmpty((String)value);
        }
        if (value instanceof Character) {
            return ValidityChecks.checkNotEmpty((Character)value);
        }
        if (value instanceof Byte) {
            return ValidityChecks.checkNotEmpty((Byte)value);
        }
        if (value instanceof Short) {
            return ValidityChecks.checkNotEmpty((Short)value);
        }
        if (value instanceof Integer) {
            return ValidityChecks.checkNotEmpty((Integer)value);
        }
        if (value instanceof Long) {
            return ValidityChecks.checkNotEmpty((Long)value);
        }
        if (value instanceof Float) {
            return ValidityChecks.checkNotEmpty((Float)value);
        }
        if (value instanceof Double) {
            return ValidityChecks.checkNotEmpty((Double)value);
        }
        return true;
    }

    public static boolean checkNotEmpty(Character value) {
        if (value == null) {
            return true;
        }
        return ValidityChecks.checkNotEmpty(value.charValue());
    }

    public static boolean checkNotEmpty(char value) {
        return '\u0000' != value;
    }

    public static boolean checkNotEmpty(Byte value) {
        if (value == null) {
            return true;
        }
        return ValidityChecks.checkNotEmpty((byte)value);
    }

    public static boolean checkNotEmpty(byte value) {
        return 0 != value;
    }

    public static boolean checkNotEmpty(Short value) {
        if (value == null) {
            return true;
        }
        return ValidityChecks.checkNotEmpty((short)value);
    }

    public static boolean checkNotEmpty(short value) {
        return 0 != value;
    }

    public static boolean checkNotEmpty(Integer value) {
        if (value == null) {
            return true;
        }
        return ValidityChecks.checkNotEmpty((int)value);
    }

    public static boolean checkNotEmpty(int value) {
        return 0 != value;
    }

    public static boolean checkNotEmpty(Long value) {
        if (value == null) {
            return true;
        }
        return ValidityChecks.checkNotEmpty((long)value);
    }

    public static boolean checkNotEmpty(long value) {
        return 0L != value;
    }

    public static boolean checkNotEmpty(Float value) {
        if (value == null) {
            return true;
        }
        return ValidityChecks.checkNotEmpty(value.floatValue());
    }

    public static boolean checkNotEmpty(float value) {
        return 0.0f != value;
    }

    public static boolean checkNotEmpty(Double value) {
        if (value == null) {
            return true;
        }
        return ValidityChecks.checkNotEmpty((double)value);
    }

    public static boolean checkNotEmpty(double value) {
        return 0.0 != value;
    }

    public static boolean checkNotEqual(boolean value, boolean reference) {
        return !(!value ? !reference : reference);
    }

    public static boolean checkNotEqual(byte value, byte reference) {
        return value != reference;
    }

    public static boolean checkNotEqual(char value, char reference) {
        return value != reference;
    }

    public static boolean checkNotEqual(short value, short reference) {
        return value != reference;
    }

    public static boolean checkNotEqual(int value, int reference) {
        return value != reference;
    }

    public static boolean checkNotEqual(long value, long reference) {
        return value != reference;
    }

    public static boolean checkNotEqual(float value, float reference) {
        return value != reference;
    }

    public static boolean checkNotEqual(double value, double reference) {
        return value != reference;
    }

    public static boolean checkNotEqual(Object value, Object reference) {
        if (value == null || reference == null) {
            return true;
        }
        return !value.equals(reference);
    }

    public static boolean checkEqual(boolean value, boolean reference) {
        return !(!value ? reference : !reference);
    }

    public static boolean checkEqual(byte value, byte reference) {
        return value == reference;
    }

    public static boolean checkEqual(char value, char reference) {
        return value == reference;
    }

    public static boolean checkEqual(short value, short reference) {
        return value == reference;
    }

    public static boolean checkEqual(int value, int reference) {
        return value == reference;
    }

    public static boolean checkEqual(long value, long reference) {
        return value == reference;
    }

    public static boolean checkEqual(float value, float reference) {
        return value == reference;
    }

    public static boolean checkEqual(double value, double reference) {
        return value == reference;
    }

    public static boolean checkEqual(Object value, Object reference) {
        if (value == null || reference == null) {
            return true;
        }
        return value.equals(reference);
    }

    public static boolean checkLength(byte value, int min, int max) {
        return ValidityChecks.checkLength(String.valueOf(value), min, max);
    }

    public static boolean checkLength(char value, int min, int max) {
        return ValidityChecks.checkLength(String.valueOf(value), min, max);
    }

    public static boolean checkLength(short value, int min, int max) {
        return ValidityChecks.checkLength(String.valueOf(value), min, max);
    }

    public static boolean checkLength(int value, int min, int max) {
        return ValidityChecks.checkLength(String.valueOf(value), min, max);
    }

    public static boolean checkLength(long value, int min, int max) {
        return ValidityChecks.checkLength(String.valueOf(value), min, max);
    }

    public static boolean checkLength(float value, int min, int max) {
        return ValidityChecks.checkLength(String.valueOf(value), min, max);
    }

    public static boolean checkLength(double value, int min, int max) {
        return ValidityChecks.checkLength(String.valueOf(value), min, max);
    }

    public static boolean checkLength(Object value, int min, int max) {
        if (value == null) {
            return true;
        }
        String string = value.toString();
        if (min > 0 && string.length() < min) {
            return false;
        }
        return max < 0 || string.length() <= max;
    }

    public static boolean checkRegexp(Object value, String pattern) {
        if (value == null || pattern == null || 0 == pattern.length()) {
            return true;
        }
        String string = value.toString();
        if (0 == string.length()) {
            return true;
        }
        Pattern regexp = null;
        try {
            regexp = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        Matcher match = regexp.matcher(string);
        return match.matches();
    }

    public static boolean checkEmail(Object value) {
        return ValidityChecks.checkRegexp(value, "^[a-zA-Z0-9][_\\+\\-\\.\\w]*@[\\w\\.\\-]+\\.[a-zA-Z]{2,4}$");
    }

    public static boolean checkUrl(Object value) {
        if (value == null) {
            return true;
        }
        String string = value.toString();
        if (0 == string.length()) {
            return true;
        }
        if (string.startsWith("https://")) {
            string = "http" + string.substring(5);
        }
        try {
            new URL(string);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean checkLaterThanNow(Date value) {
        if (value == null) {
            return true;
        }
        return value.after(new Date());
    }

    public static boolean checkLimitedDate(Object value, Date min, Date max) {
        if (value == null || !(value instanceof Date)) {
            return true;
        }
        Date date = (Date)value;
        if (min != null && date.before(min)) {
            return false;
        }
        return max == null || !date.after(max);
    }

    public static boolean checkInList(Object value, String[] list) {
        if (value == null || list == null || 0 == list.length) {
            return true;
        }
        String[] strings = ArrayUtils.createStringArray(value);
        if (strings == null) {
            return false;
        }
        if (0 == strings.length) {
            return true;
        }
        Object[] sorted = (String[])list.clone();
        Arrays.sort(sorted);
        String[] stringArray = strings;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (0 != string.length() && Arrays.binarySearch(sorted, string) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean checkRange(byte value, byte begin, byte end) {
        if (value < begin) {
            return false;
        }
        return value <= end;
    }

    public static boolean checkRange(char value, char begin, char end) {
        if (value < begin) {
            return false;
        }
        return value <= end;
    }

    public static boolean checkRange(short value, short begin, short end) {
        if (value < begin) {
            return false;
        }
        return value <= end;
    }

    public static boolean checkRange(int value, int begin, int end) {
        if (value < begin) {
            return false;
        }
        return value <= end;
    }

    public static boolean checkRange(long value, long begin, long end) {
        if (value < begin) {
            return false;
        }
        return value <= end;
    }

    public static boolean checkRange(float value, float begin, float end) {
        if (value < begin) {
            return false;
        }
        return !(value > end);
    }

    public static boolean checkRange(double value, double begin, double end) {
        if (value < begin) {
            return false;
        }
        return !(value > end);
    }

    public static boolean checkRange(Object value, Comparable begin, Comparable end) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof Comparable)) {
            return true;
        }
        Comparable comparable = (Comparable)value;
        if (begin != null && comparable.compareTo(begin) < 0) {
            return false;
        }
        return end == null || comparable.compareTo(end) <= 0;
    }

    public static boolean checkFormat(Object value, Format format) {
        if (value == null || format == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return true;
        }
        String string = (String)value;
        try {
            Object parsed = format.parseObject(string);
            if (parsed == null) {
                return false;
            }
            return format.format(parsed).equals(string);
        }
        catch (ParseException e) {
            return false;
        }
    }
}

