/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.PropertyValidationRule;
import com.uwyn.rife.site.Validation;
import com.uwyn.rife.site.ValidationRule;
import com.uwyn.rife.site.exceptions.ValidationException;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationGroup<C extends ConstrainedProperty>
implements Cloneable {
    private String mName = null;
    private Validation mValidation = null;
    private ArrayList<String> mSubjects = null;
    private ValidationGroup mParent = null;
    private ArrayList<String> mPropertyNames = null;

    ValidationGroup(String name, Validation validation) {
        this.mName = name;
        this.mValidation = validation;
        this.mSubjects = new ArrayList();
    }

    void setParent(ValidationGroup parent) {
        this.mParent = parent;
    }

    void setValidation(Validation validation) {
        this.mValidation = validation;
    }

    public void reinitializeProperties(Object bean) {
        if (bean == null || this.mPropertyNames == null || 0 == this.mPropertyNames.size()) {
            return;
        }
        Object new_bean = null;
        try {
            new_bean = bean.getClass().newInstance();
        }
        catch (Throwable e) {
            throw new ValidationException(e);
        }
        String[] property_names = new String[this.mPropertyNames.size()];
        this.mPropertyNames.toArray(property_names);
        try {
            for (String name : (Collection)BeanUtils.getPropertyNames(bean.getClass(), property_names, null, null)) {
                BeanUtils.setPropertyValue(bean, name, BeanUtils.getPropertyValue(new_bean, name));
            }
        }
        catch (BeanUtilsException e) {
            throw new ValidationException(e);
        }
    }

    public String getName() {
        return this.mName;
    }

    public List<String> getSubjects() {
        return this.mSubjects;
    }

    public Validation getValidation() {
        return this.mValidation;
    }

    public ValidationGroup<C> addSubject(String subject) {
        this.addPropertyName(subject);
        if (this.mSubjects.contains(subject)) {
            return this;
        }
        this.mSubjects.add(subject);
        if (this.mParent != null) {
            this.mParent.addSubject(subject);
        }
        return this;
    }

    private void addPropertyName(String name) {
        if (this.mPropertyNames == null) {
            this.mPropertyNames = new ArrayList();
        }
        if (!this.mPropertyNames.contains(name)) {
            this.mPropertyNames.add(name);
        }
    }

    public ValidationGroup<C> addRule(ValidationRule rule) {
        this.mValidation.addRule(rule);
        this.addSubject(rule.getSubject());
        return this;
    }

    public ValidationGroup<C> addConstraint(C constrainedProperty) {
        this.addPropertyName(((ConstrainedProperty)constrainedProperty).getPropertyName());
        List<PropertyValidationRule> rules = this.mValidation.addConstrainedPropertyRules(constrainedProperty);
        for (ValidationRule rule : (Collection)rules) {
            this.addSubject(rule.getSubject());
        }
        return this;
    }

    public ValidationGroup<C> addGroup(String name) {
        ValidationGroup group = this.mValidation.addGroup(name);
        group.setParent(this);
        return group;
    }

    public ValidationGroup<C> clone() {
        ValidationGroup new_validationgroup = null;
        try {
            new_validationgroup = (ValidationGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.site").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        if (this.mSubjects != null) {
            new_validationgroup.mSubjects = new ArrayList<String>(this.mSubjects);
        }
        if (this.mPropertyNames != null) {
            new_validationgroup.mPropertyNames = new ArrayList<String>(this.mPropertyNames);
        }
        return new_validationgroup;
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }
}

