/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.tools.ExceptionUtils;
import java.util.logging.Logger;

public abstract class ValidationError
implements Cloneable {
    public static final String IDENTIFIER_MANDATORY = "MANDATORY";
    public static final String IDENTIFIER_UNICITY = "UNICITY";
    public static final String IDENTIFIER_WRONGLENGTH = "WRONGLENGTH";
    public static final String IDENTIFIER_WRONGFORMAT = "WRONGFORMAT";
    public static final String IDENTIFIER_NOTNUMERIC = "NOTNUMERIC";
    public static final String IDENTIFIER_UNEXPECTED = "UNEXPECTED";
    public static final String IDENTIFIER_INCOMPLETE = "INCOMPLETE";
    public static final String IDENTIFIER_INVALID = "INVALID";
    public static final String IDENTIFIER_NOTSAME = "NOTSAME";
    private String mIdentifier = null;
    private String mSubject = null;

    public ValidationError(String identifier, String subject) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier can't be null");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject can't be null");
        }
        this.mIdentifier = identifier;
        this.mSubject = subject;
    }

    public final String getIdentifier() {
        return this.mIdentifier;
    }

    public final String getSubject() {
        return this.mSubject;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.site").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }

    public int hashCode() {
        return this.mIdentifier.hashCode() * this.mSubject.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ValidationError) {
            ValidationError other_error = (ValidationError)object;
            return other_error != null && other_error.mIdentifier.equals(this.mIdentifier) && other_error.mSubject.equals(this.mSubject);
        }
        return false;
    }

    public static class MANDATORY
    extends ValidationError {
        public MANDATORY(String subject) {
            super(ValidationError.IDENTIFIER_MANDATORY, subject);
        }
    }

    public static class UNICITY
    extends ValidationError {
        public UNICITY(String subject) {
            super(ValidationError.IDENTIFIER_UNICITY, subject);
        }
    }

    public static class WRONGLENGTH
    extends ValidationError {
        public WRONGLENGTH(String subject) {
            super(ValidationError.IDENTIFIER_WRONGLENGTH, subject);
        }
    }

    public static class WRONGFORMAT
    extends ValidationError {
        public WRONGFORMAT(String subject) {
            super(ValidationError.IDENTIFIER_WRONGFORMAT, subject);
        }
    }

    public static class NOTNUMERIC
    extends ValidationError {
        public NOTNUMERIC(String subject) {
            super(ValidationError.IDENTIFIER_NOTNUMERIC, subject);
        }
    }

    public static class UNEXPECTED
    extends ValidationError {
        public UNEXPECTED(String subject) {
            super(ValidationError.IDENTIFIER_UNEXPECTED, subject);
        }
    }

    public static class INCOMPLETE
    extends ValidationError {
        public INCOMPLETE(String subject) {
            super(ValidationError.IDENTIFIER_INCOMPLETE, subject);
        }
    }

    public static class INVALID
    extends ValidationError {
        public INVALID(String subject) {
            super(ValidationError.IDENTIFIER_INVALID, subject);
        }
    }

    public static class NOTSAMEAS
    extends ValidationError {
        public NOTSAMEAS(String subject) {
            super(ValidationError.IDENTIFIER_NOTSAME, subject);
        }
    }
}

