/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.FormBuilder;
import com.uwyn.rife.site.Validated;
import com.uwyn.rife.site.ValidationBuilder;
import com.uwyn.rife.site.ValidationBuilderXml;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBuilderXml
implements FormBuilder {
    private ValidationBuilder mValidationBuilder = new ValidationBuilderXml();

    @Override
    public Collection<String> generateForm(Template template2, Class beanClass, Map<String, String[]> values, String prefix) throws BeanUtilsException {
        if (beanClass == null) {
            return new ArrayList<String>();
        }
        Object bean = null;
        try {
            bean = beanClass.newInstance();
        }
        catch (Throwable e) {
            bean = null;
        }
        return this.generateForm(template2, beanClass, bean, values, prefix);
    }

    @Override
    public Collection<String> generateForm(Template template2, Object bean, Map<String, String[]> values, String prefix) throws BeanUtilsException {
        if (bean == null) {
            return new ArrayList<String>();
        }
        if (bean instanceof Class) {
            throw new IllegalArgumentException("bean should be a bean instance, not a bean class.");
        }
        return this.generateForm(template2, bean.getClass(), bean, values, prefix);
    }

    private Collection<String> generateForm(Template template2, Class beanClass, Object bean, Map<String, String[]> values, String prefix) throws BeanUtilsException {
        ArrayList<String> set_values = new ArrayList<String>();
        if (template2 == null) {
            return set_values;
        }
        Constrained constrained = null;
        if (bean != null && bean instanceof Constrained) {
            constrained = (Constrained)bean;
        }
        if (values == null && bean != null) {
            Validated validated = null;
            Set<ValidationError> previous_errors = null;
            if (bean instanceof Validated) {
                validated = (Validated)bean;
                set_values.addAll(this.mValidationBuilder.generateValidationErrors(template2, validated.getValidationErrors(), validated.getValidatedSubjects(), prefix));
                set_values.addAll(this.mValidationBuilder.generateErrorMarkings(template2, validated.getValidationErrors(), validated.getValidatedSubjects(), prefix));
                previous_errors = validated.getValidationErrors();
                validated.resetValidation();
                validated.validate();
            }
            if (validated != null) {
                validated.replaceValidationErrors(previous_errors);
            }
        }
        return set_values;
    }

    @Override
    public Collection<String> generateField(Template template2, ConstrainedProperty property, String[] values, String prefix) {
        return new ArrayList<String>();
    }

    @Override
    public Collection<String> generateField(Template template2, String name, String[] values, String prefix) {
        return new ArrayList<String>();
    }

    @Override
    public void removeForm(Template template2, Class beanClass, String prefix) throws BeanUtilsException {
        if (template2 == null || beanClass == null) {
            return;
        }
        Object bean = null;
        try {
            bean = beanClass.newInstance();
        }
        finally {
            Validated validated = null;
        }
    }

    @Override
    public void removeField(Template template2, String name, String prefix) {
    }

    @Override
    public Collection<String> selectParameter(Template template2, String name, String[] values) {
        return new ArrayList<String>();
    }

    @Override
    public void unselectParameter(Template template2, String name, String[] values) {
    }

    @Override
    public ValidationBuilder getValidationBuilder() {
        return this.mValidationBuilder;
    }

    @Override
    public Object clone() {
        try {
            FormBuilderXml other = (FormBuilderXml)super.clone();
            other.mValidationBuilder = (ValidationBuilder)this.mValidationBuilder.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.site").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }
}

