/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.site;

import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.FormBuilder;
import com.uwyn.rife.site.Validated;
import com.uwyn.rife.site.ValidationBuilder;
import com.uwyn.rife.site.ValidationBuilderXhtml;
import com.uwyn.rife.site.ValidationError;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.tools.ArrayUtils;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormBuilderXhtml
implements FormBuilder {
    public static final String SUFFIX_SELECTED = ":SELECTED";
    public static final String SUFFIX_CHECKED = ":CHECKED";
    public static final String VALUE_SELECTED = " selected=\"selected\"";
    public static final String VALUE_CHECKED = " checked=\"checked\"";
    private ValidationBuilder mValidationBuilder = new ValidationBuilderXhtml();

    @Override
    public Collection<String> generateForm(Template template2, Class beanClass, Map<String, String[]> values, String prefix) throws BeanUtilsException {
        if (beanClass == null) {
            return new ArrayList<String>();
        }
        Object bean = null;
        try {
            bean = beanClass.newInstance();
        }
        catch (Throwable e) {
            bean = null;
        }
        return this.generateForm(template2, beanClass, bean, values, prefix);
    }

    @Override
    public Collection<String> generateForm(Template template2, Object bean, Map<String, String[]> values, String prefix) throws BeanUtilsException {
        if (bean == null) {
            return new ArrayList<String>();
        }
        if (bean instanceof Class) {
            throw new IllegalArgumentException("bean should be a bean instance, not a bean class.");
        }
        return this.generateForm(template2, bean.getClass(), bean, values, prefix);
    }

    private Collection<String> generateForm(Template template2, Class beanClass, Object bean, Map<String, String[]> values, String prefix) throws BeanUtilsException {
        ArrayList<String> set_values = new ArrayList<String>();
        if (template2 == null) {
            return set_values;
        }
        Constrained constrained = null;
        if (bean != null && bean instanceof Constrained) {
            constrained = (Constrained)bean;
        }
        if (values == null && bean != null) {
            Validated validated = null;
            Set<ValidationError> previous_errors = null;
            if (bean instanceof Validated) {
                validated = (Validated)bean;
                set_values.addAll(this.mValidationBuilder.generateValidationErrors(template2, validated.getValidationErrors(), validated.getValidatedSubjects(), prefix));
                set_values.addAll(this.mValidationBuilder.generateErrorMarkings(template2, validated.getValidationErrors(), validated.getValidatedSubjects(), prefix));
                previous_errors = validated.getValidationErrors();
                validated.resetValidation();
                validated.validate();
            }
            SortedMap<String, Object> property_value_map = BeanUtils.getPropertyValues(bean, null, null, null);
            String[] property_values = null;
            for (Map.Entry entry : (Collection)property_value_map.entrySet()) {
                property_values = entry.getValue() == null ? null : ArrayUtils.createStringArray(entry.getValue());
                this.generateFormField(template2, constrained, (String)entry.getKey(), property_values, prefix, set_values);
            }
            if (validated != null) {
                validated.replaceValidationErrors(previous_errors);
            }
        } else {
            SortedSet<String> property_names = BeanUtils.getPropertyNames(beanClass, null, null, null);
            String[] property_values = null;
            for (String property_name : (Collection)property_names) {
                if (values != null) {
                    property_values = prefix == null ? values.get(property_name) : values.get(new StringBuffer().append(prefix).append(property_name).toString());
                }
                this.generateFormField(template2, constrained, property_name, property_values, prefix, set_values);
            }
        }
        return set_values;
    }

    private void generateFormField(Template template2, Constrained constrained, String propertyName, String[] propertyValues, String prefix, ArrayList<String> setValues) {
        ConstrainedProperty constrained_property = null;
        if (constrained != null) {
            constrained_property = (ConstrainedProperty)constrained.getConstrainedProperty(propertyName);
        }
        if (constrained_property == null) {
            this.generateField(template2, propertyName, propertyValues, prefix, setValues);
        } else {
            this.generateField(template2, constrained_property, propertyValues, prefix, setValues);
        }
    }

    @Override
    public Collection<String> generateField(Template template2, ConstrainedProperty property, String[] values, String prefix) {
        return this.generateField(template2, property, values, prefix, null);
    }

    private Collection<String> generateField(Template template2, ConstrainedProperty property, String[] values, String prefix, ArrayList<String> setValues) {
        if (setValues == null) {
            setValues = new ArrayList();
        }
        if (template2 == null || property == null) {
            return setValues;
        }
        String name = null;
        name = prefix == null ? property.getPropertyName() : new StringBuffer().append(prefix).append(property.getPropertyName()).toString();
        this.generateField(template2, name, property, values, setValues);
        return setValues;
    }

    @Override
    public Collection<String> generateField(Template template2, String name, String[] values, String prefix) {
        return this.generateField(template2, name, values, prefix, null);
    }

    private Collection<String> generateField(Template template2, String name, String[] values, String prefix, ArrayList<String> setValues) {
        if (setValues == null) {
            setValues = new ArrayList();
        }
        if (template2 == null || name == null || 0 == name.length()) {
            return setValues;
        }
        if (prefix != null) {
            name = new StringBuffer().append(prefix).append(name).toString();
        }
        this.generateField(template2, name, null, values, setValues);
        return setValues;
    }

    private void generateField(Template template2, String name, ConstrainedProperty property, String[] values, ArrayList<String> setValues) {
        Template builder_template = TemplateFactory.XHTML.get("formbuilder.fields");
        this.generateFieldHidden(template2, name, property, values, builder_template, setValues);
        this.generateFieldInput(template2, name, property, values, builder_template, setValues);
        this.generateFieldSecret(template2, name, property, values, builder_template, setValues);
        this.generateFieldTextarea(template2, name, property, values, builder_template, setValues);
        this.generateFieldRadio(template2, name, property, values, builder_template, setValues);
        this.generateFieldCheckbox(template2, name, property, values, builder_template, setValues);
        this.generateFieldSelect(template2, name, property, values, builder_template, setValues);
        this.generateFieldDisplay(template2, name, property, values, builder_template, setValues);
    }

    private void generateFieldText(String prefix, boolean setValue, boolean valueAsAttribute, boolean limitLength, boolean disableField, Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        StringBuffer field_buffer = null;
        String field = null;
        String field_attributes = null;
        field_buffer = new StringBuffer(prefix.length() + name.length());
        field_buffer.append(prefix);
        field_buffer.append(name);
        field = field_buffer.toString();
        if (template2.hasValueId(field) && !template2.isValueSet(field)) {
            field_buffer = new StringBuffer(prefix.length() + FormBuilder.MIDDLE_ATTRIBUTES.length() + name.length());
            field_buffer.append(prefix);
            field_buffer.append("ATTRIBUTES:");
            field_buffer.append(name);
            field_attributes = field_buffer.toString();
            builderTemplate.setValue("NAME", template2.getEncoder().encode(name));
            String value = null;
            if (values != null && values.length > 0 && values[0] != null) {
                value = template2.getEncoder().encode(values[0]);
            } else if (property != null && property.hasDefaultValue()) {
                value = template2.getEncoder().encode(property.getDefaultValue().toString());
            }
            if (template2.hasBlock(field_attributes)) {
                if (template2.hasValueId("FORM:NAME")) {
                    template2.setValue("FORM:NAME", template2.getEncoder().encode(name));
                }
                if (template2.hasValueId("FORM:VALUE") && value != null) {
                    template2.setValue("FORM:VALUE", value);
                }
                builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getBlock(field_attributes).trim()).toString());
                if (template2.hasValueId("FORM:NAME")) {
                    template2.removeValue("FORM:NAME");
                }
                if (template2.hasValueId("FORM:VALUE")) {
                    template2.removeValue("FORM:VALUE");
                }
            } else if (template2.hasDefaultValue(field)) {
                builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getDefaultValue(field).trim()).toString());
            }
            if (setValue && value != null) {
                builderTemplate.setValue("VALUE", value);
                if (valueAsAttribute) {
                    builderTemplate.appendBlock("ATTRIBUTES", "VALUE");
                }
            }
            if (limitLength && property != null && property.getMaxLength() >= 0) {
                builderTemplate.setValue("MAXLENGTH", property.getMaxLength());
                builderTemplate.appendBlock("ATTRIBUTES", "MAXLENGTH");
            }
            if (disableField && property != null && !property.isEditable()) {
                builderTemplate.appendBlock("ATTRIBUTES", "DISABLED");
            }
            template2.setValue(field, builderTemplate.getBlock(prefix));
            setValues.add(field);
            builderTemplate.removeValue("NAME");
            builderTemplate.removeValue("VALUE");
            builderTemplate.removeValue("MAXLENGTH");
            builderTemplate.removeValue("ATTRIBUTES");
        }
    }

    private void generateFieldHidden(Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        this.generateFieldText("FORM:HIDDEN:", true, true, false, false, template2, name, property, values, builderTemplate, setValues);
    }

    private void generateFieldInput(Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        this.generateFieldText("FORM:INPUT:", true, true, true, true, template2, name, property, values, builderTemplate, setValues);
    }

    private void generateFieldSecret(Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        this.generateFieldText("FORM:SECRET:", false, true, true, true, template2, name, property, values, builderTemplate, setValues);
    }

    private void generateFieldTextarea(Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        this.generateFieldText("FORM:TEXTAREA:", true, false, false, true, template2, name, property, values, builderTemplate, setValues);
    }

    private void generateFieldCollection(String prefix, boolean singleValue, Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        StringBuffer field_buffer = null;
        String field = null;
        String field_attributes = null;
        field_buffer = new StringBuffer(prefix.length() + name.length());
        field_buffer.append(prefix);
        field_buffer.append(name);
        field = field_buffer.toString();
        if (template2.hasValueId(field) && !template2.isValueSet(field)) {
            String value;
            int n;
            String[] stringArray;
            field_buffer = new StringBuffer(prefix.length() + FormBuilder.MIDDLE_ATTRIBUTES.length() + name.length());
            field_buffer.append(prefix);
            field_buffer.append("ATTRIBUTES:");
            field_buffer.append(name);
            field_attributes = field_buffer.toString();
            builderTemplate.setValue("NAME", template2.getEncoder().encode(name));
            ArrayList<String> active_values = null;
            if (values != null && values.length > 0) {
                if (singleValue) {
                    if (values[0] != null) {
                        active_values = new ArrayList();
                        active_values.add(values[0]);
                    }
                } else {
                    active_values = new ArrayList<String>();
                    stringArray = values;
                    n = 0;
                    while (n < stringArray.length) {
                        value = stringArray[n];
                        if (value != null) {
                            active_values.add(value);
                        }
                        ++n;
                    }
                }
            }
            if (active_values == null && property != null && property.hasDefaultValue()) {
                active_values = new ArrayList();
                active_values.add(property.getDefaultValue().toString());
            }
            if (property == null || !property.isInList()) {
                if (template2.hasBlock(field_attributes)) {
                    if (template2.hasValueId("FORM:NAME")) {
                        template2.setValue("FORM:NAME", template2.getEncoder().encode(name));
                    }
                    if (template2.hasValueId("FORM:VALUE")) {
                        if (values != null && values.length > 0 && values[0] != null) {
                            template2.setValue("FORM:VALUE", template2.getEncoder().encode(values[0]));
                        } else if (property != null && property.hasDefaultValue()) {
                            template2.setValue("FORM:VALUE", template2.getEncoder().encode(property.getDefaultValue().toString()));
                        }
                    }
                    builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getBlock(field_attributes).trim()).toString());
                    if (template2.hasValueId("FORM:NAME")) {
                        template2.removeValue("FORM:NAME");
                    }
                    if (template2.hasValueId("FORM:VALUE")) {
                        template2.removeValue("FORM:VALUE");
                    }
                } else if (template2.hasDefaultValue(field)) {
                    builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getDefaultValue(field).trim()).toString());
                } else {
                    builderTemplate.setValue("ATTRIBUTES", "");
                }
                if (active_values != null && StringUtils.convertToBoolean((String)active_values.get(0))) {
                    builderTemplate.appendBlock("ATTRIBUTES", "CHECKED");
                }
                if (property != null && !property.isEditable()) {
                    builderTemplate.appendBlock("ATTRIBUTES", "DISABLED");
                }
                template2.setValue(field, builderTemplate.getBlock(prefix));
            } else {
                stringArray = property.getInList();
                n = 0;
                while (n < stringArray.length) {
                    value = stringArray[n];
                    if (value != null) {
                        if (template2.hasValueId("FORM:NAME")) {
                            template2.setValue("FORM:NAME", template2.getEncoder().encode(name));
                        }
                        if (template2.hasValueId("FORM:VALUE") && value != null) {
                            template2.setValue("FORM:VALUE", template2.getEncoder().encode(value));
                        }
                        if (template2.hasBlock(field_attributes)) {
                            builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getBlock(field_attributes).trim()).toString());
                        } else if (template2.hasDefaultValue(field)) {
                            builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getDefaultValue(field).trim()).toString());
                        } else {
                            builderTemplate.setValue("ATTRIBUTES", "");
                        }
                        builderTemplate.setValue("VALUE", template2.getEncoder().encode(value));
                        builderTemplate.appendBlock("ATTRIBUTES", "VALUE");
                        if (active_values != null && active_values.contains(value)) {
                            builderTemplate.appendBlock("ATTRIBUTES", "CHECKED");
                        }
                        if (!property.isEditable()) {
                            builderTemplate.appendBlock("ATTRIBUTES", "DISABLED");
                        }
                        if (template2.hasBlock(field)) {
                            if (template2.hasValueId("FORM:FIELD")) {
                                template2.setValue("FORM:FIELD", builderTemplate.getBlock(prefix));
                            }
                            if (template2.hasValueId("FORM:LABEL")) {
                                template2.setValue("FORM:LABEL", this.generateLabel(template2, name, value));
                            }
                            template2.appendBlock(field, field);
                            if (template2.hasValueId("FORM:FIELD")) {
                                template2.removeValue("FORM:FIELD");
                            }
                            if (template2.hasValueId("FORM:LABEL")) {
                                template2.removeValue("FORM:LABEL");
                            }
                        } else {
                            template2.appendValue(field, builderTemplate.getBlock(prefix));
                            template2.appendValue(field, this.generateLabel(template2, name, value));
                        }
                        if (template2.hasValueId("FORM:NAME")) {
                            template2.removeValue("FORM:NAME");
                        }
                        if (template2.hasValueId("FORM:VALUE")) {
                            template2.removeValue("FORM:VALUE");
                        }
                    }
                    ++n;
                }
            }
            setValues.add(field);
            builderTemplate.removeValue("NAME");
            builderTemplate.removeValue("VALUE");
            builderTemplate.removeValue("ATTRIBUTES");
        }
    }

    private void generateFieldRadio(Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        this.generateFieldCollection("FORM:RADIO:", true, template2, name, property, values, builderTemplate, setValues);
    }

    private void generateFieldCheckbox(Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        this.generateFieldCollection("FORM:CHECKBOX:", false, template2, name, property, values, builderTemplate, setValues);
    }

    private void generateFieldSelect(Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        StringBuffer field_buffer = null;
        String field = null;
        field_buffer = new StringBuffer(FormBuilder.PREFIX_FORM_SELECT.length() + name.length());
        field_buffer.append("FORM:SELECT:");
        field_buffer.append(name);
        field = field_buffer.toString();
        if (template2.hasValueId(field) && !template2.isValueSet(field)) {
            builderTemplate.setValue("NAME", template2.getEncoder().encode(name));
            ArrayList<String> active_values = null;
            if (values != null && values.length > 0) {
                active_values = new ArrayList<String>();
                String[] stringArray = values;
                int n = 0;
                while (n < stringArray.length) {
                    String value = stringArray[n];
                    if (value != null) {
                        active_values.add(value);
                    }
                    ++n;
                }
            }
            if (active_values == null && property != null && property.hasDefaultValue()) {
                active_values = new ArrayList();
                active_values.add(property.getDefaultValue().toString());
            }
            if (property != null && property.isInList()) {
                List<String> list = Arrays.asList(property.getInList());
                String default_value = null;
                if (property.hasDefaultValue() && list.contains(default_value = Convert.toString(property.getDefaultValue()))) {
                    default_value = null;
                }
                int i = 0;
                while (i < list.size()) {
                    String value = null;
                    if (default_value != null) {
                        value = default_value;
                        default_value = null;
                    } else {
                        value = list.get(i);
                        ++i;
                    }
                    if (value == null) continue;
                    builderTemplate.setValue("VALUE", template2.getEncoder().encode(value));
                    if (active_values != null && active_values.contains(value)) {
                        builderTemplate.setBlock("ATTRIBUTES", "SELECTED");
                    } else {
                        builderTemplate.setValue("ATTRIBUTES", "");
                    }
                    builderTemplate.setValue("LABEL", this.generateLabel(template2, name, value));
                    builderTemplate.appendBlock("OPTIONS", "FORM:OPTION:");
                    builderTemplate.removeValue("ATTRIBUTES");
                    builderTemplate.removeValue("VALUE");
                    builderTemplate.removeValue("LABEL");
                    if (template2.hasValueId("FORM:NAME")) {
                        template2.removeValue("FORM:NAME");
                    }
                    if (!template2.hasValueId("FORM:VALUE")) continue;
                    template2.removeValue("FORM:VALUE");
                }
                if (template2.hasDefaultValue(field)) {
                    builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getDefaultValue(field).trim()).toString());
                } else {
                    builderTemplate.setValue("ATTRIBUTES", "");
                }
                if (!property.isEditable()) {
                    builderTemplate.appendBlock("ATTRIBUTES", "DISABLED");
                }
            }
            template2.setValue(field, builderTemplate.getBlock("FORM:SELECT:"));
            setValues.add(field);
            builderTemplate.removeValue("NAME");
            builderTemplate.removeValue("OPTIONS");
            builderTemplate.removeValue("ATTRIBUTES");
        }
    }

    private void generateFieldDisplay(Template template2, String name, ConstrainedProperty property, String[] values, Template builderTemplate, ArrayList<String> setValues) {
        StringBuffer field_buffer = null;
        String field = null;
        String field_attributes = null;
        field_buffer = new StringBuffer(FormBuilder.PREFIX_FORM_DISPLAY.length() + name.length());
        field_buffer.append("FORM:DISPLAY:");
        field_buffer.append(name);
        field = field_buffer.toString();
        if (template2.hasValueId(field) && !template2.isValueSet(field)) {
            field_buffer = new StringBuffer(FormBuilder.PREFIX_FORM_DISPLAY.length() + FormBuilder.MIDDLE_ATTRIBUTES.length() + name.length());
            field_buffer.append("FORM:DISPLAY:");
            field_buffer.append("ATTRIBUTES:");
            field_buffer.append(name);
            field_attributes = field_buffer.toString();
            int counter = 0;
            do {
                String value = null;
                if (values != null && values.length > counter && values[counter] != null) {
                    value = template2.getEncoder().encode(values[counter]);
                } else if (property != null && property.hasDefaultValue()) {
                    value = template2.getEncoder().encode(property.getDefaultValue().toString());
                }
                if (template2.hasBlock(field_attributes)) {
                    if (template2.hasValueId("FORM:NAME")) {
                        template2.setValue("FORM:NAME", template2.getEncoder().encode(name));
                    }
                    if (template2.hasValueId("FORM:VALUE") && value != null) {
                        template2.setValue("FORM:VALUE", value);
                    }
                    builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getBlock(field_attributes).trim()).toString());
                    if (template2.hasValueId("FORM:NAME")) {
                        template2.removeValue("FORM:NAME");
                    }
                    if (template2.hasValueId("FORM:VALUE")) {
                        template2.removeValue("FORM:VALUE");
                    }
                } else if (template2.hasDefaultValue(field)) {
                    builderTemplate.setValue("ATTRIBUTES", new StringBuffer().append(" ").append(template2.getDefaultValue(field).trim()).toString());
                }
                if (value != null) {
                    if (property != null && property.isInList()) {
                        builderTemplate.setValue("VALUE", this.generateLabel(template2, name, value));
                    } else {
                        builderTemplate.setValue("VALUE", value);
                    }
                }
                String field_content = builderTemplate.getBlock("FORM:DISPLAY:");
                if (0 == counter) {
                    template2.setValue(field, field_content);
                    continue;
                }
                template2.appendValue(field, field_content);
            } while (values != null && values.length > 1 && ++counter < values.length);
            setValues.add(field);
            builderTemplate.removeValue("VALUE");
            builderTemplate.removeValue("ATTRIBUTES");
        }
    }

    private String generateLabel(Template template2, String name, String value) {
        StringBuffer label_id_buffer = null;
        String label_id = null;
        StringBuffer label_valueid_buffer = null;
        String label_valueid = null;
        StringBuffer stringBuffer = label_id_buffer = new StringBuffer(name.length() + 1 + value.length());
        synchronized (stringBuffer) {
            label_id_buffer.append(name);
            label_id_buffer.append(":");
            label_id_buffer.append(value);
            label_id = label_id_buffer.toString();
        }
        stringBuffer = label_valueid_buffer = new StringBuffer(FormBuilder.PREFIX_FORM_LABEL.length() + label_id.length());
        synchronized (stringBuffer) {
            label_valueid_buffer.append("FORM:LABEL:");
            label_valueid_buffer.append(label_id);
            label_valueid = label_valueid_buffer.toString();
        }
        String label = null;
        if (template2.hasResourceBundles()) {
            for (ResourceBundle bundle : template2.getResourceBundles()) {
                try {
                    label = bundle.getString(label_id);
                    if (label == null) break;
                    label = template2.getEncoder().encode(label);
                    break;
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
        }
        if (label == null && template2.hasBlock(label_valueid)) {
            label = template2.getBlock(label_valueid);
        }
        if (label == null) {
            label = value;
        }
        return label;
    }

    @Override
    public void removeForm(Template template2, Class beanClass, String prefix) throws BeanUtilsException {
        if (template2 == null || beanClass == null) {
            return;
        }
        Object bean = null;
        try {
            bean = beanClass.newInstance();
        }
        catch (Throwable e) {
            bean = null;
        }
        SortedSet<String> property_names = BeanUtils.getPropertyNames(beanClass, null, null, null);
        for (String property_name : (Collection)property_names) {
            this.removeField(template2, property_name, prefix);
        }
        Validated validated = null;
        if (bean != null && bean instanceof Validated) {
            validated = bean;
            this.mValidationBuilder.removeValidationErrors(template2, validated.getValidatedSubjects(), prefix);
            this.mValidationBuilder.removeErrorMarkings(template2, validated.getValidatedSubjects(), prefix);
        }
    }

    @Override
    public void removeField(Template template2, String name, String prefix) {
        if (template2 == null || name == null || 0 == name.length()) {
            return;
        }
        if (prefix != null) {
            name = new StringBuffer().append(prefix).append(name).toString();
        }
        String value_id = null;
        String[] stringArray = FormBuilder.VALUE_PREFIXES;
        int n = 0;
        while (n < stringArray.length) {
            String value_prefix = stringArray[n];
            value_id = new StringBuffer().append(value_prefix).append(name).toString();
            if (template2.isValueSet(value_id)) {
                template2.removeValue(value_id);
            }
            ++n;
        }
    }

    @Override
    public Collection<String> selectParameter(Template template2, String name, String[] values) {
        ArrayList<String> set_values = new ArrayList<String>();
        if (template2 == null || name == null || 0 == name.length() || values == null || 0 == values.length) {
            return set_values;
        }
        StringBuffer value_id_buffer = null;
        String value_id = null;
        String[] stringArray = values;
        int n = 0;
        while (n < stringArray.length) {
            String value = stringArray[n];
            if (value != null) {
                StringBuffer stringBuffer = value_id_buffer = new StringBuffer(name);
                synchronized (stringBuffer) {
                    value_id_buffer.append(":");
                    value_id_buffer.append(value);
                }
                value_id = new StringBuffer().append(value_id_buffer.toString()).append(SUFFIX_SELECTED).toString();
                if (template2.hasValueId(value_id)) {
                    template2.setValue(value_id, VALUE_SELECTED);
                    set_values.add(value_id);
                }
                if (template2.hasValueId(value_id = new StringBuffer().append(value_id_buffer.toString()).append(SUFFIX_CHECKED).toString())) {
                    template2.setValue(value_id, VALUE_CHECKED);
                    set_values.add(value_id);
                }
                if (template2.hasValueId(value_id = new StringBuffer().append(name).append(SUFFIX_CHECKED).toString()) && StringUtils.convertToBoolean(value)) {
                    template2.setValue(value_id, VALUE_CHECKED);
                    set_values.add(value_id);
                }
            }
            ++n;
        }
        return set_values;
    }

    @Override
    public void unselectParameter(Template template2, String name, String[] values) {
        if (template2 == null || name == null || 0 == name.length()) {
            return;
        }
        String value_id = null;
        value_id = new StringBuffer().append(name).append(SUFFIX_CHECKED).toString();
        if (template2.hasValueId(value_id)) {
            template2.removeValue(value_id);
        }
        if (values == null || 0 == values.length) {
            return;
        }
        StringBuffer value_id_buffer = null;
        String[] stringArray = values;
        int n = 0;
        while (n < stringArray.length) {
            String value = stringArray[n];
            if (value != null) {
                StringBuffer stringBuffer = value_id_buffer = new StringBuffer(name);
                synchronized (stringBuffer) {
                    value_id_buffer.append(":");
                    value_id_buffer.append(value);
                }
                value_id = new StringBuffer().append(value_id_buffer.toString()).append(SUFFIX_SELECTED).toString();
                if (template2.hasValueId(value_id)) {
                    template2.removeValue(value_id);
                }
                if (template2.hasValueId(value_id = new StringBuffer().append(value_id_buffer.toString()).append(SUFFIX_CHECKED).toString())) {
                    template2.removeValue(value_id);
                }
            }
            ++n;
        }
    }

    @Override
    public ValidationBuilder getValidationBuilder() {
        return this.mValidationBuilder;
    }

    @Override
    public Object clone() {
        try {
            FormBuilderXhtml other = (FormBuilderXhtml)super.clone();
            other.mValidationBuilder = (ValidationBuilder)this.mValidationBuilder.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.site").severe(ExceptionUtils.getExceptionStackTrace(e));
            return null;
        }
    }
}

