/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.servlet;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.Datasources;
import com.uwyn.rife.scheduler.Scheduler;
import com.uwyn.rife.scheduler.exceptions.FatalTaskExecutionException;
import com.uwyn.rife.scheduler.exceptions.NoExecutorForTasktypeException;
import com.uwyn.rife.scheduler.exceptions.UnableToRetrieveTasksToProcessException;
import com.uwyn.rife.scheduler.taskmanagers.DatabaseTasksFactory;
import com.uwyn.rife.scheduler.taskoptionmanagers.DatabaseTaskoptionsFactory;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

public class SchedulerServlet
extends HttpServlet {
    public void init() throws ServletException {
        String sleep_time = this.getInitParameter("sleeptime");
        String datasource_name = this.getInitParameter("datasource");
        Datasource datasource = Datasources.getRepInstance().getDatasource(datasource_name);
        Scheduler scheduler = new Scheduler(DatabaseTasksFactory.getInstance(datasource), DatabaseTaskoptionsFactory.getInstance(datasource));
        if (sleep_time != null) {
            try {
                scheduler.setSleepTime(Integer.parseInt(sleep_time));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            scheduler.start();
        }
        catch (NoExecutorForTasktypeException e) {
            Logger.getLogger("com.uwyn.rife.servlet").severe(e.getMessage());
        }
        catch (UnableToRetrieveTasksToProcessException e) {
            Logger.getLogger("com.uwyn.rife.servlet").severe(e.getMessage());
        }
        catch (FatalTaskExecutionException e) {
            Logger.getLogger("com.uwyn.rife.servlet").severe(e.getMessage());
        }
    }
}

