/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler.taskmanagers.exceptions;

import com.uwyn.rife.scheduler.exceptions.TaskManagerException;
import java.util.Date;

public class RescheduleTaskErrorException
extends TaskManagerException {
    private int mId = -1;
    private long mNewPlanned = -1;
    private String mFrequency = null;

    public RescheduleTaskErrorException(int id, long newPlanned, String frequency, Throwable cause) {
        super("Error while trying to reschedule the task with id '" + id + "', planned at '" + new Date(newPlanned).toString() + "' with frequency '" + frequency + "'.", cause);
        this.mId = id;
        this.mNewPlanned = newPlanned;
        this.mFrequency = frequency;
    }

    public RescheduleTaskErrorException(int id, long newPlanned, Throwable cause) {
        super("Error while trying to reschedule the task with id '" + id + "', planned at '" + new Date(newPlanned).toString() + "' with no frequency.", cause);
        this.mId = id;
        this.mNewPlanned = newPlanned;
    }

    public int getTaskId() {
        return this.mId;
    }

    public long getNewPlanned() {
        return this.mNewPlanned;
    }

    public String getFrequency() {
        return this.mFrequency;
    }
}

