/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler.taskmanagers;

import com.uwyn.rife.pcj.map.IntKeyOpenHashMap;
import com.uwyn.rife.scheduler.Scheduler;
import com.uwyn.rife.scheduler.Task;
import com.uwyn.rife.scheduler.TaskManager;
import com.uwyn.rife.scheduler.exceptions.FrequencyException;
import com.uwyn.rife.scheduler.exceptions.TaskManagerException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.ConcludeTaskErrorException;
import com.uwyn.rife.scheduler.taskmanagers.exceptions.RescheduleTaskErrorException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryTasks
implements TaskManager {
    private Scheduler mScheduler = null;
    private IntKeyOpenHashMap<Task> mTaskMapping = new IntKeyOpenHashMap();
    private int mTaskIdSequence = 0;
    private static /* synthetic */ boolean $assertionsDisabled;

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.mScheduler = scheduler;
    }

    @Override
    public Scheduler getScheduler() {
        return this.mScheduler;
    }

    @Override
    public int addTask(Task task) throws TaskManagerException {
        if (task == null) {
            throw new IllegalArgumentException("task can't be null.");
        }
        MemoryTasks memoryTasks = this;
        synchronized (memoryTasks) {
            int task_id = this.mTaskIdSequence++;
            task.setId(task_id);
            this.mTaskMapping.put(task_id, task);
            task.setTaskManager(this);
            return task_id;
        }
    }

    @Override
    public boolean updateTask(Task task) throws TaskManagerException {
        if (task == null) {
            throw new IllegalArgumentException("task can't be null.");
        }
        if (task.getId() < 0) {
            throw new IllegalArgumentException("the task id is required.");
        }
        MemoryTasks memoryTasks = this;
        synchronized (memoryTasks) {
            int task_id = task.getId();
            if (!this.mTaskMapping.containsKey(task_id)) {
                return false;
            }
            this.mTaskMapping.put(task_id, task);
            task.setTaskManager(this);
            return true;
        }
    }

    @Override
    public Task getTask(int id) throws TaskManagerException {
        if (id < 0) {
            throw new IllegalArgumentException("the task id can't be negative.");
        }
        return this.mTaskMapping.get(id);
    }

    @Override
    public Collection<Task> getTasksToProcess() throws TaskManagerException {
        ArrayList<Task> tasks_to_process = new ArrayList<Task>();
        MemoryTasks memoryTasks = this;
        synchronized (memoryTasks) {
            for (Task task : this.mTaskMapping.values()) {
                if (task.isBusy() || task.getPlanned() >= Calendar.getInstance().getTimeInMillis()) continue;
                tasks_to_process.add(task);
            }
        }
        return tasks_to_process;
    }

    @Override
    public Collection<Task> getScheduledTasks() throws TaskManagerException {
        ArrayList<Task> scheduled_tasks = new ArrayList<Task>();
        MemoryTasks memoryTasks = this;
        synchronized (memoryTasks) {
            for (Task task : this.mTaskMapping.values()) {
                if (task.isBusy() || task.getPlanned() < Calendar.getInstance().getTimeInMillis()) continue;
                scheduled_tasks.add(task);
            }
        }
        return scheduled_tasks;
    }

    @Override
    public boolean removeTask(int id) throws TaskManagerException {
        if (id < 0) {
            throw new IllegalArgumentException("the task id can't be negative.");
        }
        MemoryTasks memoryTasks = this;
        synchronized (memoryTasks) {
            return this.mTaskMapping.remove(id) != null;
            {
            }
        }
    }

    @Override
    public boolean rescheduleTask(Task task, long newPlanned, String frequency) throws TaskManagerException {
        if (task == null) {
            throw new IllegalArgumentException("task can't be null.");
        }
        if (newPlanned <= (long)0) {
            throw new IllegalArgumentException("newPlanned has to be bigger than 0.");
        }
        boolean result = false;
        Task task_tmp = null;
        try {
            task_tmp = task.clone();
            task_tmp.setPlanned(newPlanned);
            task_tmp.setFrequency(frequency);
        }
        catch (Throwable e) {
            if (frequency == null) {
                throw new RescheduleTaskErrorException(task.getId(), newPlanned, e);
            }
            throw new RescheduleTaskErrorException(task.getId(), newPlanned, frequency, e);
        }
        result = this.updateTask(task_tmp);
        if (!$assertionsDisabled && !result) {
            throw new AssertionError();
        }
        return result;
    }

    @Override
    public boolean concludeTask(Task task) throws TaskManagerException {
        if (task == null) {
            throw new IllegalArgumentException("task can't be null.");
        }
        if (task.getPlanned() <= Calendar.getInstance().getTimeInMillis()) {
            if (task.getFrequency() == null) {
                return this.removeTask(task.getId());
            }
            try {
                long next_date = task.getNextDate();
                if (next_date >= (long)0 && this.rescheduleTask(task, next_date, task.getFrequency()) && this.deactivateTask(task.getId())) {
                    return true;
                }
            }
            catch (FrequencyException e) {
                throw new ConcludeTaskErrorException(task.getId(), e);
            }
        }
        return false;
    }

    @Override
    public boolean activateTask(int id) throws TaskManagerException {
        if (id < 0) {
            throw new IllegalArgumentException("the task id can't be negative.");
        }
        MemoryTasks memoryTasks = this;
        synchronized (memoryTasks) {
            Task task = this.mTaskMapping.get(id);
            if (task == null) {
                return false;
            }
            task.setBusy(true);
            return true;
        }
    }

    @Override
    public boolean deactivateTask(int id) throws TaskManagerException {
        if (id < 0) {
            throw new IllegalArgumentException("the task id can't be negative.");
        }
        MemoryTasks memoryTasks = this;
        synchronized (memoryTasks) {
            Task task = this.mTaskMapping.get(id);
            if (task == null) {
                return false;
            }
            task.setBusy(false);
            return true;
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.scheduler.taskmanagers.MemoryTasks");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

