/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler.schedulermanagers;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.scheduler.Executor;
import com.uwyn.rife.scheduler.Scheduler;
import com.uwyn.rife.scheduler.Task;
import com.uwyn.rife.scheduler.Taskoption;
import com.uwyn.rife.scheduler.exceptions.FrequencyException;
import com.uwyn.rife.scheduler.exceptions.SchedulerException;
import com.uwyn.rife.scheduler.exceptions.TaskManagerException;
import com.uwyn.rife.scheduler.exceptions.TaskoptionManagerException;
import com.uwyn.rife.scheduler.taskmanagers.MemoryTasks;
import com.uwyn.rife.scheduler.taskoptionmanagers.MemoryTaskoptions;
import com.uwyn.rife.xml.Xml2Data;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.xml.sax.Attributes;

public class Xml2MemoryScheduler
extends Xml2Data {
    private StringBuffer mCharacterData = null;
    private Scheduler mScheduler = null;
    private MemoryTasks mTasks = null;
    private MemoryTaskoptions mTaskoptions = null;
    private int mLastTaskId = -1;
    private Taskoption mLastTaskoption = null;

    public Scheduler getScheduler() {
        return this.mScheduler;
    }

    public void startDocument() {
        this.mCharacterData = new StringBuffer();
        this.mTasks = new MemoryTasks();
        this.mTaskoptions = new MemoryTaskoptions();
        this.mScheduler = new Scheduler(this.mTasks, this.mTaskoptions);
        this.mLastTaskId = -1;
        this.mLastTaskoption = null;
    }

    public void endDocument() {
        this.mCharacterData = null;
        this.mTasks = null;
        this.mTaskoptions = null;
        this.mLastTaskId = -1;
        this.mLastTaskoption = null;
    }

    private String registerExecutor(String classname) {
        try {
            Class<?> executor_class = Class.forName(classname);
            Executor executor = (Executor)executor_class.newInstance();
            if (!this.mScheduler.addExecutor(executor)) {
                throw new XmlErrorException("Couldn't add the executor with class '" + classname + "' to the scheduler.");
            }
            return executor.getHandledTasktype();
        }
        catch (ClassNotFoundException e) {
            throw new XmlErrorException("Error while retrieving the executor's class '" + classname + "'.", e);
        }
        catch (InstantiationException e) {
            throw new XmlErrorException("Error while instantiating the executor with class '" + classname + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new XmlErrorException("Error while instantiating the executor with class '" + classname + "'.", e);
        }
        catch (SchedulerException e) {
            throw new XmlErrorException("Error while adding the executor with class '" + classname + "' to the scheduler.", e);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (!qName.equals("scheduler")) {
            if (qName.equals("task")) {
                String classname = atts.getValue("classname");
                String planned = atts.getValue("planned");
                String frequency = atts.getValue("frequency");
                String type = atts.getValue("type");
                if (classname == null || 0 == classname.length()) {
                    if (type == null || 0 == type.length()) {
                        throw new XmlErrorException("Either the executor's classname or the task type have to be specified.");
                    }
                } else if (type != null && type.length() > 0) {
                    throw new XmlErrorException("A task type can't be specified if the executor's class has been specified.");
                }
                if (classname != null && classname.length() > 0) {
                    type = this.registerExecutor(classname);
                }
                SimpleDateFormat date_formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
                Date planned_date = null;
                if (planned == null) {
                    planned_date = Calendar.getInstance().getTime();
                } else {
                    try {
                        planned_date = date_formatter.parse(planned);
                    }
                    catch (ParseException e) {
                        throw new XmlErrorException("Invalid planned '" + planned + "'.", e);
                    }
                }
                Task task = new Task();
                task.setType(type);
                task.setPlanned(planned_date);
                try {
                    task.setFrequency(frequency);
                }
                catch (FrequencyException e) {
                    throw new XmlErrorException("Invalid frequency '" + frequency + "'.", e);
                }
                try {
                    this.mLastTaskId = this.mTasks.addTask(task);
                }
                catch (TaskManagerException e) {
                    throw new XmlErrorException("Error while adding the task to the scheduler.", e);
                }
                if (planned == null && frequency != null) {
                    try {
                        long one_minute_earlier = task.getPlanned() - (long)60000;
                        long first_valid_planned = task.getNextDate(one_minute_earlier);
                        task.setPlanned(first_valid_planned);
                    }
                    catch (FrequencyException e) {}
                }
            } else if (qName.equals("option")) {
                this.mCharacterData = new StringBuffer();
                this.mLastTaskoption = new Taskoption();
                this.mLastTaskoption.setTaskId(this.mLastTaskId);
                this.mLastTaskoption.setName(atts.getValue("name"));
            } else if (qName.equals("config")) {
                if (this.mCharacterData != null && Config.hasRepInstance()) {
                    this.mCharacterData.append(Config.getRepInstance().getString(atts.getValue("param"), ""));
                }
            } else if (qName.equals("executor")) {
                String classname = atts.getValue("classname");
                this.registerExecutor(classname);
            } else {
                throw new XmlErrorException("Unsupport element name '" + qName + "'.");
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (qName.equals("option")) {
            this.mLastTaskoption.setValue(this.mCharacterData.toString());
            try {
                this.mTaskoptions.addTaskoption(this.mLastTaskoption);
            }
            catch (TaskoptionManagerException e) {
                throw new XmlErrorException("Error while adding the taskoption with name '" + this.mLastTaskoption.getName() + "', value '" + this.mLastTaskoption.getValue() + "' and task id '" + this.mLastTaskoption.getTaskId() + "'.", e);
            }
            this.mCharacterData = new StringBuffer();
            this.mLastTaskoption = null;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (length > 0) {
            this.mCharacterData.append(String.copyValueOf(ch, start, length));
        }
    }
}

