/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler.schedulermanagers;

import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.scheduler.Scheduler;
import com.uwyn.rife.scheduler.SchedulerFactory;
import com.uwyn.rife.scheduler.exceptions.SchedulerManagerException;
import com.uwyn.rife.scheduler.schedulermanagers.Xml2MemoryScheduler;
import com.uwyn.rife.scheduler.schedulermanagers.exceptions.InitializationErrorException;
import com.uwyn.rife.scheduler.schedulermanagers.exceptions.ModificationTimeErrorException;
import com.uwyn.rife.scheduler.schedulermanagers.exceptions.SchedulerNotFoundException;
import com.uwyn.rife.scheduler.taskmanagers.MemoryTasks;
import com.uwyn.rife.scheduler.taskoptionmanagers.MemoryTaskoptions;
import com.uwyn.rife.selector.XmlSelectorResolver;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.net.URL;

public class MemoryScheduler
implements SchedulerFactory {
    private Scheduler mScheduler = null;
    private long mModificationTime = 0;
    private String mXmlPath = null;
    private ResourceFinder mResourceFinder = null;
    private Xml2MemoryScheduler mXmlMemoryScheduler = null;

    public MemoryScheduler() {
    }

    public MemoryScheduler(String xmlPath, ResourceFinder resourceFinder) throws SchedulerManagerException {
        if (xmlPath == null) {
            throw new IllegalArgumentException("xmlPath can't be null.");
        }
        if (0 == xmlPath.length()) {
            throw new IllegalArgumentException("xmlPath can't be empty.");
        }
        if (resourceFinder == null) {
            throw new IllegalArgumentException("resourceFinder can't be null.");
        }
        this.mResourceFinder = resourceFinder;
        String datasource_resolved = XmlSelectorResolver.resolve(xmlPath, this.mResourceFinder, "rep/scheduler-");
        if (datasource_resolved == null) {
            throw new SchedulerNotFoundException(xmlPath);
        }
        URL datasource_resource = this.mResourceFinder.getResource(datasource_resolved);
        if (datasource_resource == null) {
            throw new SchedulerNotFoundException(xmlPath, datasource_resolved);
        }
        try {
            this.mModificationTime = resourceFinder.getModificationTime(datasource_resolved);
        }
        catch (ResourceFinderErrorException e) {
            throw new ModificationTimeErrorException(xmlPath, e);
        }
        this.mXmlPath = datasource_resolved;
        this.mXmlMemoryScheduler = new Xml2MemoryScheduler();
        this.initialize();
        this.mXmlMemoryScheduler = null;
    }

    public Scheduler getScheduler() {
        if (this.mScheduler == null) {
            this.mScheduler = new Scheduler(new MemoryTasks(), new MemoryTaskoptions());
        }
        return this.mScheduler;
    }

    private void initialize() throws SchedulerManagerException {
        try {
            this.mXmlMemoryScheduler.processXml(this.mXmlPath, this.mResourceFinder);
            this.mScheduler = this.mXmlMemoryScheduler.getScheduler();
        }
        catch (XmlErrorException e) {
            throw new InitializationErrorException(this.mXmlPath, e);
        }
    }

    public String getXmlPath() {
        return this.mXmlPath;
    }
}

