/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.scheduler;

import com.uwyn.rife.scheduler.exceptions.FrequencyException;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Frequency {
    private static final int MAX_YEAR = 2050;
    private static final byte[] ALL_MINUTES;
    private static final byte[] ALL_HOURS;
    private static final byte[] ALL_DATES;
    private static final byte[] ALL_MONTHS;
    private static final byte[] ALL_WEEKDAYS;
    private static final byte[] EMPTY_DATE_OVERFLOW;
    private String mFrequency = null;
    private byte[] mMinutes = null;
    private byte[] mHours = null;
    private byte[] mDates = null;
    private byte[] mDatesUnderflow = null;
    private byte[] mDatesOverflow = null;
    private byte[] mMonths = null;
    private byte[] mWeekdays = null;
    private boolean mParsed = false;
    private static /* synthetic */ boolean $assertionsDisabled;

    Frequency(String frequency) throws FrequencyException {
        this.parse(frequency);
    }

    long getNextDate(long start) throws FrequencyException {
        if (start < (long)0) {
            throw new IllegalArgumentException("start should be positive");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(start);
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        int date = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        ++minute;
        minute = this.getNextValidMinute(minute);
        if (-1 == minute || -1 == this.mHours[hour] || -1 == this.mMonths[month - 1] || -1 == this.getDates(month, year)[date - 1]) {
            ++hour;
            if (-1 == (hour = this.getNextValidHour(hour)) || -1 == this.mMonths[month - 1] || -1 == this.getDates(month, year)[date - 1]) {
                ++date;
                hour = this.getFirstValidHour();
            }
            minute = this.getFirstValidMinute();
        }
        while (year < 2050) {
            if (-1 == (date = this.getNextValidDate(date, month, year)) || -1 == this.mMonths[month - 1]) {
                ++month;
                if (-1 == (month = this.getNextValidMonth(month))) {
                    ++year;
                    month = this.getFirstValidMonth();
                }
                if (-1 == (date = this.getFirstValidDate(month, year))) {
                    date = 1;
                    continue;
                }
            }
            calendar.set(year, month - 1, date, hour, minute);
            if (year == calendar.get(1) && month == calendar.get(2) + 1) {
                int weekday = calendar.get(7) - 2;
                if (-1 == weekday) {
                    weekday = 6;
                }
                if (this.mWeekdays[weekday] != -1) {
                    return calendar.getTimeInMillis();
                }
            }
            ++date;
        }
        throw new FrequencyException("no valid next date available");
    }

    private int getFirstValidMinute() {
        return this.getNextValidMinute(0);
    }

    private int getNextValidMinute(int minute) {
        if (!$assertionsDisabled && minute < 0) {
            throw new AssertionError();
        }
        int i = minute;
        while (i < this.mMinutes.length) {
            if (this.mMinutes[i] != -1) {
                return this.mMinutes[i];
            }
            ++i;
        }
        return -1;
    }

    private int getFirstValidHour() {
        return this.getNextValidHour(0);
    }

    private int getNextValidHour(int hour) {
        if (!$assertionsDisabled && hour < 0) {
            throw new AssertionError();
        }
        int i = hour;
        while (i < this.mHours.length) {
            if (this.mHours[i] != -1) {
                return this.mHours[i];
            }
            ++i;
        }
        return -1;
    }

    private byte[] getDates(int month, int year) {
        if (!$assertionsDisabled && month < 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && year < 0) {
            throw new AssertionError();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        byte maximum_date = (byte)calendar.getActualMaximum(5);
        byte[] dates = null;
        dates = new byte[ALL_DATES.length];
        Arrays.fill(dates, (byte)-1);
        System.arraycopy(this.mDates, 0, dates, 0, maximum_date);
        if (this.mDatesUnderflow != null && this.mDatesOverflow != null) {
            calendar.roll(2, -1);
            byte maximum_date_previous = (byte)calendar.getActualMaximum(5);
            byte end_value = ALL_DATES[ALL_DATES.length - 1];
            byte difference = (byte)(end_value - maximum_date_previous);
            int start_position = ALL_DATES.length - 1;
            int target_position = 0;
            int i = start_position;
            while (i >= 0) {
                if (this.mDatesUnderflow[i] != 0 && i > maximum_date_previous - 1 && (target_position = i - maximum_date_previous) < this.mDatesUnderflow[i] && target_position < maximum_date) {
                    dates[target_position] = ALL_DATES[target_position];
                }
                if (this.mDatesOverflow[i] != 0 && (target_position = i + difference) < this.mDatesOverflow[i] && target_position < maximum_date) {
                    dates[target_position] = ALL_DATES[target_position];
                }
                --i;
            }
        }
        return dates;
    }

    private int getFirstValidDate(int month, int year) {
        return this.getNextValidDate(1, month, year);
    }

    private int getNextValidDate(int date, int month, int year) {
        if (!$assertionsDisabled && date < 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && month < 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && year < 0) {
            throw new AssertionError();
        }
        byte[] dates = this.getDates(month, year);
        int i = date - 1;
        while (i < dates.length) {
            if (dates[i] != -1) {
                return dates[i];
            }
            ++i;
        }
        return -1;
    }

    private int getFirstValidMonth() {
        return this.getNextValidMonth(1);
    }

    private int getNextValidMonth(int month) {
        if (!$assertionsDisabled && month < 1) {
            throw new AssertionError();
        }
        int i = month - 1;
        while (i < this.mMonths.length) {
            if (this.mMonths[i] != -1) {
                return this.mMonths[i];
            }
            ++i;
        }
        return -1;
    }

    boolean isParsed() {
        return this.mParsed;
    }

    String getFrequency() {
        return this.mFrequency;
    }

    byte[] getMinutes() {
        return this.mMinutes;
    }

    byte[] getHours() {
        return this.mHours;
    }

    byte[] getDates() {
        return this.mDates;
    }

    byte[] getDatesUnderflow() {
        return this.mDatesUnderflow;
    }

    byte[] getDatesOverflow() {
        return this.mDatesOverflow;
    }

    byte[] getMonths() {
        return this.mMonths;
    }

    byte[] getWeekdays() {
        return this.mWeekdays;
    }

    void parse(String frequency) throws FrequencyException {
        if (frequency == null) {
            throw new IllegalArgumentException("frequency can't be null");
        }
        if (0 == frequency.length()) {
            throw new IllegalArgumentException("frequency can't be empty");
        }
        this.mFrequency = frequency;
        this.mParsed = false;
        this.mMinutes = null;
        this.mHours = null;
        this.mDates = null;
        this.mDatesUnderflow = new byte[ALL_DATES.length];
        this.mDatesOverflow = new byte[ALL_DATES.length];
        this.mMonths = null;
        this.mWeekdays = null;
        ArrayList<String> frequency_parts = StringUtils.split(frequency, " ");
        if (frequency_parts.size() != 5) {
            throw new FrequencyException("invalid frequency, should be 5 fields seperated by a space");
        }
        String minutes = frequency_parts.get(0);
        String hours = frequency_parts.get(1);
        String dates = frequency_parts.get(2);
        String months = frequency_parts.get(3);
        String weekdays = frequency_parts.get(4);
        this.mMinutes = this.processParts(StringUtils.split(minutes, ","), ALL_MINUTES, false, null, null);
        this.mHours = this.processParts(StringUtils.split(hours, ","), ALL_HOURS, false, null, null);
        this.mDates = this.processParts(StringUtils.split(dates, ","), ALL_DATES, true, this.mDatesUnderflow, this.mDatesOverflow);
        if (Arrays.equals(this.mDatesUnderflow, EMPTY_DATE_OVERFLOW)) {
            this.mDatesUnderflow = null;
        }
        if (Arrays.equals(this.mDatesOverflow, EMPTY_DATE_OVERFLOW)) {
            this.mDatesOverflow = null;
        }
        this.mMonths = this.processParts(StringUtils.split(months, ","), ALL_MONTHS, false, null, null);
        this.mWeekdays = this.processParts(StringUtils.split(weekdays, ","), ALL_WEEKDAYS, false, null, null);
        this.mParsed = true;
    }

    /*
     * Unable to fully structure code
     */
    private byte[] processParts(ArrayList<String> parts, byte[] allValues, boolean deferOverflowProcessing, byte[] underflowStorage, byte[] overflowStorage) throws FrequencyException {
        if (!Frequency.$assertionsDisabled && parts == null) {
            throw new AssertionError();
        }
        if (!Frequency.$assertionsDisabled && parts.size() <= 0) {
            throw new AssertionError();
        }
        if (!Frequency.$assertionsDisabled && allValues == null) {
            throw new AssertionError();
        }
        if (!Frequency.$assertionsDisabled && allValues.length <= 0) {
            throw new AssertionError();
        }
        if (!(Frequency.$assertionsDisabled || !deferOverflowProcessing || deferOverflowProcessing && underflowStorage != null && overflowStorage != null)) {
            throw new AssertionError();
        }
        part = null;
        result_values = null;
        result_values = new byte[allValues.length];
        Arrays.fill(result_values, (byte)-1);
        if (underflowStorage != null) {
            Arrays.fill(underflowStorage, (byte)-1);
        }
        if (overflowStorage != null) {
            Arrays.fill(overflowStorage, (byte)-1);
        }
        begin = allValues[0];
        end = allValues[allValues.length - 1];
        var10_10 = ((Collection)parts).iterator();
        while (var10_10.hasNext()) {
            part = current_part = (String)var10_10.next();
            if (current_part.equals("*")) {
                result_values = allValues;
                return result_values;
            }
            try {
                block28: {
                    block29: {
                        seperator = -1;
                        divider = (byte)-1;
                        seperator = current_part.indexOf("/");
                        if (seperator != -1) {
                            divider = Byte.parseByte(current_part.substring(seperator + 1));
                            current_part = current_part.substring(0, seperator);
                        }
                        if (current_part.equals("*")) {
                            if (-1 == divider) {
                                throw new FrequencyException(new StringBuffer().append(new StringBuffer().append("invalid frequency part '").append(part).toString()).append("'").toString());
                            }
                            i = (byte)false;
                            while (i < allValues.length) {
                                result_values[i] = allValues[i];
                                i = (byte)(i + divider);
                            }
                            continue;
                        }
                        seperator = current_part.indexOf("-");
                        if (seperator == -1) break block28;
                        left = Byte.parseByte(current_part.substring(0, seperator));
                        right = Byte.parseByte(current_part.substring(seperator + 1));
                        if (left < begin || left > end) {
                            throw new FrequencyException(new StringBuffer().append(new StringBuffer().append("value out of range '").append(left).toString()).append("'").toString());
                        }
                        if (right < begin || right > end) {
                            throw new FrequencyException(new StringBuffer().append(new StringBuffer().append("value out of range '").append(right).toString()).append("'").toString());
                        }
                        if (left == right) {
                            if (divider != -1) {
                                throw new FrequencyException(new StringBuffer().append(new StringBuffer().append("invalid frequency part '").append(part).toString()).append("'").toString());
                            }
                            result_values[left - begin] = allValues[left - begin];
                            continue;
                        }
                        if (-1 == divider) {
                            divider = (byte)true;
                        }
                        if (right >= left) break block29;
                        if (!deferOverflowProcessing) ** GOTO lbl75
                        while (left <= end) {
                            result_values[left - begin] = allValues[left - begin];
                            if (underflowStorage[left - begin] < right) {
                                underflowStorage[left - begin] = right;
                            }
                            left = (byte)(left + divider);
                        }
                        left = (byte)(begin + (left - end) - 1);
                        while (left <= right) {
                            if (overflowStorage[left - begin] < right) {
                                overflowStorage[left - begin] = right;
                            }
                            left = (byte)(left + divider);
                        }
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            result_values[left - begin] = allValues[left - begin];
                            left = (byte)(left + divider);
lbl75:
                            // 2 sources

                            ** while (left <= end)
                        }
lbl76:
                        // 1 sources

                        left = (byte)(begin + (left - end) - 1);
                    }
                    while (left <= right) {
                        result_values[left - begin] = allValues[left - begin];
                        left = (byte)(left + divider);
                    }
                    continue;
                }
                if (divider != -1) {
                    throw new FrequencyException(new StringBuffer().append(new StringBuffer().append("invalid frequency part '").append(part).toString()).append("'").toString());
                }
                minute = Byte.parseByte(current_part);
                if (minute < begin || minute > end) {
                    throw new FrequencyException(new StringBuffer().append(new StringBuffer().append("value out of range '").append(minute).toString()).append("'").toString());
                }
                result_values[minute - begin] = allValues[minute - begin];
            }
            catch (NumberFormatException e) {
                throw new FrequencyException(new StringBuffer().append(new StringBuffer().append("invalid frequency part '").append(part).toString()).append("'").toString(), e);
            }
        }
        return result_values;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.scheduler.Frequency");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        ALL_MINUTES = new byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10, (byte)11, (byte)12, (byte)13, (byte)14, (byte)15, (byte)16, (byte)17, (byte)18, (byte)19, (byte)20, (byte)21, (byte)22, (byte)23, (byte)24, (byte)25, (byte)26, (byte)27, (byte)28, (byte)29, (byte)30, (byte)31, (byte)32, (byte)33, (byte)34, (byte)35, (byte)36, (byte)37, (byte)38, (byte)39, (byte)40, (byte)41, (byte)42, (byte)43, (byte)44, (byte)45, (byte)46, (byte)47, (byte)48, (byte)49, (byte)50, (byte)51, (byte)52, (byte)53, (byte)54, (byte)55, (byte)56, (byte)57, (byte)58, (byte)59};
        ALL_HOURS = new byte[]{(byte)0, (byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10, (byte)11, (byte)12, (byte)13, (byte)14, (byte)15, (byte)16, (byte)17, (byte)18, (byte)19, (byte)20, (byte)21, (byte)22, (byte)23};
        ALL_DATES = new byte[]{(byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10, (byte)11, (byte)12, (byte)13, (byte)14, (byte)15, (byte)16, (byte)17, (byte)18, (byte)19, (byte)20, (byte)21, (byte)22, (byte)23, (byte)24, (byte)25, (byte)26, (byte)27, (byte)28, (byte)29, (byte)30, (byte)31};
        ALL_MONTHS = new byte[]{(byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10, (byte)11, (byte)12};
        ALL_WEEKDAYS = new byte[]{(byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7};
        EMPTY_DATE_OVERFLOW = new byte[]{(byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1, (byte)-1};
    }
}

