/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.resources;

import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.tools.InputStreamUser;
import java.net.URL;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceFinder
implements ResourceFinder {
    @Override
    public <ResultType> ResultType useStream(String name, InputStreamUser user) throws ResourceFinderErrorException {
        if (name == null || user == null) {
            return null;
        }
        URL resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        return this.useStream(resource, user);
    }

    @Override
    public String getContent(String name) throws ResourceFinderErrorException {
        return this.getContent(name, null);
    }

    @Override
    public String getContent(String name, String encoding) throws ResourceFinderErrorException {
        if (name == null) {
            return null;
        }
        URL resource = this.getResource(name);
        if (resource == null) {
            return null;
        }
        return this.getContent(resource, encoding);
    }

    @Override
    public String getContent(URL resource) throws ResourceFinderErrorException {
        return this.getContent(resource, null);
    }

    @Override
    public long getModificationTime(String name) throws ResourceFinderErrorException {
        if (name == null) {
            return -1;
        }
        URL resource = this.getResource(name);
        if (resource == null) {
            return -1;
        }
        return this.getModificationTime(resource);
    }
}

