/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.rep;

import com.uwyn.rife.rep.BlockingParticipant;
import com.uwyn.rife.rep.BlockingParticipantDelegate;
import com.uwyn.rife.rep.BlockingRepositoryCleanup;
import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.rep.Repository;
import com.uwyn.rife.rep.RepositoryListener;
import com.uwyn.rife.rep.Xml2BlockingRepository;
import com.uwyn.rife.rep.exceptions.BlockingParticipantExpectedException;
import com.uwyn.rife.rep.exceptions.InitializationErrorException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingRepository
extends ThreadGroup
implements Repository {
    private static final String DEFAULT_REP_PATH = "rep/participants.xml";
    private HashMap<String, BlockingParticipant> mRepParticipants = new HashMap();
    private HashMap<String, ArrayList<BlockingParticipant>> mRepParticipantClassnames = new HashMap();
    private ArrayList<String> mRepParticipantsOrder = new ArrayList();
    private ArrayList<String> mRepParticipantsToWaitFor = new ArrayList();
    private HashSet<RepositoryListener> mRepListeners = new HashSet();
    private boolean mFinished = false;
    private Object mFinishedThreadMonitor = new Object();
    private boolean mCleanedUp = false;
    private BlockingRepositoryCleanup mCleanupShutdownHook = null;
    private Object mCleanupThreadMonitor = new Object();
    private Throwable mParticipantException = null;
    private Properties mProperties = new Properties();

    public BlockingRepository() {
        super("BlockingRepository");
        this.mProperties.putAll((Map<?, ?>)System.getProperties());
    }

    public boolean addParticipant(String className, String name, boolean blocking, String parameter) {
        Class<?> klass = null;
        try {
            klass = Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            className = new StringBuffer().append("com.uwyn.rife.rep.participants.").append(className).toString();
            try {
                klass = Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                return false;
            }
        }
        return this.addParticipant(klass, name, blocking, parameter);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean addParticipant(Class klass, String name, boolean blocking, String parameter) {
        if (name == null || 0 == name.length()) {
            name = klass.getName();
        }
        if (this.mRepParticipants.containsKey(name)) {
            return false;
        }
        try {
            void var8_13;
            Class<?> clazz;
            BlockingParticipant participant_instance = null;
            try {
                clazz = Class.forName("com.uwyn.rife.rep.BlockingParticipant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (!clazz.isAssignableFrom(klass)) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("com.uwyn.rife.rep.Participant");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (!clazz2.isAssignableFrom(klass)) throw new BlockingParticipantExpectedException(klass.getName());
                participant_instance = new BlockingParticipantDelegate(klass);
            } else {
                participant_instance = (BlockingParticipant)klass.newInstance();
            }
            participant_instance.setName(name);
            Thread thread = new Thread((ThreadGroup)this, participant_instance);
            participant_instance.setThread(thread);
            participant_instance.setRepository(this);
            this.mRepParticipants.put(name, participant_instance);
            ArrayList<BlockingParticipant> arrayList = this.mRepParticipantClassnames.get(klass.getName());
            if (arrayList == null) {
                ArrayList arrayList2 = new ArrayList();
                this.mRepParticipantClassnames.put(klass.getName(), arrayList2);
            }
            var8_13.add(participant_instance);
            this.mRepParticipantsOrder.add(name);
            if (blocking) {
                this.mRepParticipantsToWaitFor.add(name);
            }
            if (parameter == null) return true;
            participant_instance.setParameter(parameter);
            return true;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
    }

    @Override
    public boolean hasParticipant(String name) {
        BlockingParticipant participant = this.getParticipant(name);
        if (participant == null) {
            return false;
        }
        return !participant.hadInitializationError();
    }

    @Override
    public BlockingParticipant getParticipant(String name) {
        ArrayList<BlockingParticipant> participants;
        if (this.mRepParticipants.containsKey(name)) {
            return this.mRepParticipants.get(name);
        }
        String prefixed_name = new StringBuffer().append("com.uwyn.rife.rep.participants.").append(name).toString();
        if (this.mRepParticipants.containsKey(prefixed_name)) {
            return this.mRepParticipants.get(prefixed_name);
        }
        if (this.mRepParticipantClassnames.containsKey(name) && (participants = this.mRepParticipantClassnames.get(name)).size() > 0) {
            return participants.get(0);
        }
        if (this.mRepParticipantClassnames.containsKey(prefixed_name) && (participants = this.mRepParticipantClassnames.get(prefixed_name)).size() > 0) {
            return participants.get(0);
        }
        return null;
    }

    @Override
    public /* synthetic */ Participant getParticipant(String string) {
        return this.getParticipant(string);
    }

    public Collection<BlockingParticipant> getParticipants(String className) {
        ArrayList<BlockingParticipant> participants;
        ArrayList<BlockingParticipant> participants2;
        if (this.mRepParticipantClassnames.containsKey(className) && (participants2 = this.mRepParticipantClassnames.get(className)).size() > 0) {
            return participants2;
        }
        String prefixed_name = new StringBuffer().append("com.uwyn.rife.rep.participants.").append(className).toString();
        if (this.mRepParticipantClassnames.containsKey(prefixed_name) && (participants = this.mRepParticipantClassnames.get(prefixed_name)).size() > 0) {
            return participants;
        }
        return null;
    }

    public void runParticipants(ResourceFinder resourceFinder) {
        for (String name : (Collection)this.mRepParticipantsOrder) {
            BlockingParticipant participant = this.mRepParticipants.get(name);
            try {
                if (participant.getThread().isAlive() || participant.isFinished()) continue;
                Logger.getLogger("com.uwyn.rife.rep").info(new StringBuffer().append("INITIALIZATION : ").append(participant.getInitializationMessage()).toString());
                participant.setResourceFinder(resourceFinder);
                participant.getThread().start();
                if (!this.mRepParticipantsToWaitFor.contains(name)) continue;
                participant.waitUntilFinished();
            }
            finally {
                this.detectParticipantException();
            }
        }
    }

    private void detectParticipantException() {
        if (this.mParticipantException != null) {
            if (this.mParticipantException instanceof RuntimeException) {
                throw (RuntimeException)this.mParticipantException;
            }
            throw new RuntimeException(this.mParticipantException);
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable e) {
        if (e instanceof ThreadDeath) {
            super.uncaughtException(thread, e);
        }
        if (this.mParticipantException == null) {
            this.mParticipantException = e;
        }
        Object object = this.mFinishedThreadMonitor;
        synchronized (object) {
            if (!this.mFinished) {
                this.mFinished = true;
                this.fireInitFinished();
                this.cleanup();
            } else if (this.mParticipantException != null) {
                Logger.getLogger("com.uwyn.rife.rep").severe(ExceptionUtils.getExceptionStackTrace(this.mParticipantException));
            }
        }
    }

    public void initialize(String repXmlPath, ResourceFinder resourcefinder) {
        this.mFinished = false;
        if (resourcefinder == null) {
            resourcefinder = ResourceFinderClasspath.getInstance();
        }
        if (repXmlPath == null) {
            repXmlPath = DEFAULT_REP_PATH;
        }
        Xml2BlockingRepository xml2rep = new Xml2BlockingRepository(this);
        try {
            xml2rep.addRepParticipants(repXmlPath, resourcefinder);
        }
        catch (XmlErrorException e) {
            throw new InitializationErrorException(e);
        }
        this.runParticipants(resourcefinder);
        Object object = this.mFinishedThreadMonitor;
        synchronized (object) {
            if (!this.mFinished) {
                this.mCleanupShutdownHook = new BlockingRepositoryCleanup(this);
                Runtime.getRuntime().addShutdownHook(this.mCleanupShutdownHook);
                this.mFinished = true;
                this.fireInitFinished();
            }
        }
    }

    public boolean isFinished() {
        return this.mFinished;
    }

    @Override
    public void cleanup() {
        if (!this.mFinished) {
            return;
        }
        Object object = this.mCleanupThreadMonitor;
        synchronized (object) {
            if (this.mCleanedUp) {
                return;
            }
            String name = null;
            BlockingParticipant participant = null;
            int i = this.mRepParticipantsOrder.size() - 1;
            while (i >= 0) {
                name = this.mRepParticipantsOrder.get(i);
                participant = this.getParticipant(name);
                if (participant != null) {
                    Logger.getLogger("com.uwyn.rife.rep").info(new StringBuffer().append("CLEANUP : ").append(participant.getCleanupMessage()).toString());
                    participant.cleanup();
                }
                --i;
            }
            this.mCleanedUp = true;
        }
    }

    @Override
    public Properties getProperties() {
        return this.mProperties;
    }

    public void addRepListener(RepositoryListener repListener) {
        this.mRepListeners.add(repListener);
    }

    public void removeRepListener(RepositoryListener repListener) {
        this.mRepListeners.remove(repListener);
    }

    public void fireInitActionPerformed(BlockingParticipant participant) {
        if (this.mRepListeners.size() > 0) {
            for (RepositoryListener listener : (Collection)this.mRepListeners) {
                listener.initActionPerformed(participant);
            }
        }
    }

    public void fireInitFinished() {
        if (this.mRepListeners.size() > 0) {
            for (RepositoryListener listener : (Collection)this.mRepListeners) {
                listener.initFinished();
            }
        }
    }
}

