/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.rep;

import com.uwyn.rife.rep.BlockingRepository;
import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.resources.ResourceFinder;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockingParticipant
implements Participant,
Runnable {
    private BlockingRepository mRepository = null;
    private Object mInitThreadMonitor = new Object();
    private String mInitializationMessage = null;
    private String mCleanupMessage = null;
    private ResourceFinder mResourcefinder = null;
    private volatile boolean mInitializationFinished = false;
    private volatile boolean mInitializationError = false;
    private String mParameter = null;
    private String mThreadName = null;
    private Thread mThread = null;

    void setName(String name) {
        this.mThreadName = name;
        if (this.mThread != null) {
            this.mThread.setName(this.mThreadName);
        }
    }

    public String getName() {
        if (this.mThread != null) {
            return this.mThread.getName();
        }
        return this.mThreadName;
    }

    protected abstract void initialize();

    protected Object _getObject(Object key) {
        return null;
    }

    protected List<?> _getObjects(Object key) {
        return null;
    }

    protected void cleanup() {
    }

    void setRepository(BlockingRepository repository) {
        this.mRepository = repository;
    }

    public BlockingRepository getRepository() {
        return this.mRepository;
    }

    public void setParameter(String parameter) {
        this.mParameter = parameter;
    }

    public String getParameter() {
        return this.mParameter;
    }

    public void setResourceFinder(ResourceFinder resourceFinder) {
        this.mResourcefinder = resourceFinder;
    }

    public ResourceFinder getResourceFinder() {
        return this.mResourcefinder;
    }

    @Override
    public final void run() {
        if (!this.isFinished()) {
            try {
                try {
                    this.initialize();
                }
                catch (Throwable e) {
                    this.mInitializationError = true;
                    this.getThread().getThreadGroup().uncaughtException(this.mThread, e);
                }
            }
            finally {
                Object object = this.mInitThreadMonitor;
                synchronized (object) {
                    this.mInitializationFinished = true;
                    this.mInitThreadMonitor.notifyAll();
                    this.mRepository.fireInitActionPerformed(this);
                }
            }
        }
    }

    public final boolean isFinished() {
        return this.mInitializationFinished;
    }

    public boolean hadInitializationError() {
        Object object = this.mInitThreadMonitor;
        synchronized (object) {
            return this.mInitializationError;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void waitUntilFinished() {
        Object object = this.mInitThreadMonitor;
        synchronized (object) {
            while (!this.isFinished()) {
                try {
                    this.mInitThreadMonitor.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public void setInitializationMessage(String message) {
        this.mInitializationMessage = message;
    }

    public String getInitializationMessage() {
        if (this.mInitializationMessage == null) {
            return new StringBuffer().append(new StringBuffer().append("Initializing '").append(this.getClass().getName()).toString()).append("' ...").toString();
        }
        return this.mInitializationMessage;
    }

    public void setCleanupMessage(String message) {
        this.mCleanupMessage = message;
    }

    public String getCleanupMessage() {
        if (this.mCleanupMessage == null) {
            return new StringBuffer().append(new StringBuffer().append("Cleaning up '").append(this.getClass().getName()).toString()).append("' ...").toString();
        }
        return this.mCleanupMessage;
    }

    @Override
    public final Object getObject() {
        return this._getObject();
    }

    protected Object _getObject() {
        return this.getObject(null);
    }

    @Override
    public final Object getObject(Object key) {
        if (this.isFinished()) {
            return this._getObject(key);
        }
        return this.getObjectAndWait(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object getObjectAndWait(Object key) {
        Object object = this.mInitThreadMonitor;
        synchronized (object) {
            while (!this.isFinished()) {
                try {
                    this.mInitThreadMonitor.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return this._getObject(key);
        }
    }

    @Override
    public final List<?> getObjects() {
        return this._getObjects();
    }

    protected List<?> _getObjects() {
        return this.getObjects(null);
    }

    @Override
    public final List<?> getObjects(Object key) {
        if (this.isFinished()) {
            return this._getObjects(key);
        }
        return this.getObjectsAndWait(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<?> getObjectsAndWait(Object key) {
        Object object = this.mInitThreadMonitor;
        synchronized (object) {
            while (!this.isFinished()) {
                try {
                    this.mInitThreadMonitor.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            return this._getObjects(key);
        }
    }

    void setThread(Thread thread) {
        this.mThread = thread;
        if (this.mThreadName != null) {
            this.mThread.setName(this.mThreadName);
        }
    }

    Thread getThread() {
        return this.mThread;
    }
}

