/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.pcj.util;

import com.uwyn.rife.pcj.map.NoSuchMappingException;
import java.util.NoSuchElementException;

public class Exceptions {
    public static void indexOutOfBounds(int index, int low, int high) {
        throw new IndexOutOfBoundsException("Index out of bounds: " + index + ", valid range is " + low + " to " + high);
    }

    public static void nullArgument(String name) {
        throw new NullPointerException("The specified " + name + " is null");
    }

    public static void negativeArgument(String name, Object value) {
        throw new IllegalArgumentException(name + " cannot be negative: " + String.valueOf(value));
    }

    public static void negativeOrZeroArgument(String name, Object value) {
        throw new IllegalArgumentException(name + " must be a positive value: " + String.valueOf(value));
    }

    public static void endOfIterator() {
        throw new NoSuchElementException("Attempt to iterate past iterator's last element.");
    }

    public static void startOfIterator() {
        throw new NoSuchElementException("Attempt to iterate past iterator's first element.");
    }

    public static void noElementToRemove() {
        throw new IllegalStateException("Attempt to remove element from iterator that has no current element.");
    }

    public static void noElementToGet() {
        throw new IllegalStateException("Attempt to get element from iterator that has no current element. Call next() first.");
    }

    public static void noElementToSet() {
        throw new IllegalStateException("Attempt to set element in iterator that has no current element.");
    }

    public static void noLastElement() {
        throw new IllegalStateException("No value to return. Call containsKey() first.");
    }

    public static void noSuchMapping(Object key) {
        throw new NoSuchMappingException("No such key in map: " + String.valueOf(key));
    }

    public static void dequeNoFirst() {
        throw new IndexOutOfBoundsException("Attempt to get first element of empty deque");
    }

    public static void dequeNoLast() {
        throw new IndexOutOfBoundsException("Attempt to get last element of empty deque");
    }

    public static void dequeNoFirstToRemove() {
        throw new IndexOutOfBoundsException("Attempt to remove last element of empty deque");
    }

    public static void dequeNoLastToRemove() {
        throw new IndexOutOfBoundsException("Attempt to remove last element of empty deque");
    }

    public static void nullElementNotAllowed() {
        throw new IllegalArgumentException("Attempt to add a null value to an adapted primitive set.");
    }

    public static void cannotAdapt(String name) {
        throw new IllegalStateException("The " + name + " contains values preventing it from being adapted to a primitive " + name);
    }

    public static void unsupported(String name) {
        throw new UnsupportedOperationException("Attempt to invoke unsupported operation: " + name);
    }

    public static void unmodifiable(String name) {
        throw new UnsupportedOperationException("Attempt to modify unmodifiable " + name);
    }

    public static void cloning() {
        throw new RuntimeException("Clone is not supported");
    }

    public static void invalidRangeBounds(Object first, Object last) {
        throw new IllegalArgumentException("First (" + first + ") cannot be greater than last (" + last + ")");
    }

    public static void cannotMergeRanges(Object r1, Object r2) {
        throw new IllegalArgumentException("Ranges cannot be merged: " + r1.toString() + " and " + r2.toString());
    }

    public static void setNoFirst() {
        throw new NoSuchElementException("Attempt to get first element of empty set");
    }

    public static void setNoLast() {
        throw new NoSuchElementException("Attempt to get last element of empty set");
    }

    public static void invalidSetBounds(Object low, Object high) {
        throw new IllegalArgumentException("Lower bound (" + low + ") cannot be greater than upper bound (" + high + ")");
    }

    public static void valueNotInSubRange(Object value) {
        throw new IllegalArgumentException("Attempt to add a value outside valid range: " + value);
    }

    public static void invalidUpperBound(Object value) {
        throw new IllegalArgumentException("Upper bound is not in valid sub-range: " + value);
    }

    public static void invalidLowerBound(Object value) {
        throw new IllegalArgumentException("Lower bound is not in valid sub-range: " + value);
    }
}

