/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.pcj.map;

import com.uwyn.rife.pcj.AbstractIntCollection;
import com.uwyn.rife.pcj.IntCollection;
import com.uwyn.rife.pcj.IntIterator;
import com.uwyn.rife.pcj.hash.DefaultIntHashFunction;
import com.uwyn.rife.pcj.hash.IntHashFunction;
import com.uwyn.rife.pcj.hash.Primes;
import com.uwyn.rife.pcj.map.AbstractIntKeyIntMap;
import com.uwyn.rife.pcj.map.IntKeyIntMap;
import com.uwyn.rife.pcj.map.IntKeyIntMapIterator;
import com.uwyn.rife.pcj.map.MapDefaults;
import com.uwyn.rife.pcj.set.AbstractIntSet;
import com.uwyn.rife.pcj.set.IntSet;
import com.uwyn.rife.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class IntKeyIntChainedHashMap
extends AbstractIntKeyIntMap
implements IntKeyIntMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private IntHashFunction keyhash;
    private int size;
    private transient Entry[] data;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient IntSet keys;
    private transient IntCollection values;
    private transient boolean hasLastValue;
    private transient int lastValue;

    static /* synthetic */ void access$S1000004(IntKeyIntChainedHashMap intKeyIntChainedHashMap, int n) {
        intKeyIntChainedHashMap.size = n;
    }

    static /* synthetic */ void access$S1000005(IntKeyIntChainedHashMap intKeyIntChainedHashMap, Entry[] entryArray) {
        intKeyIntChainedHashMap.data = entryArray;
    }

    IntKeyIntChainedHashMap(IntHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        this.data = new Entry[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.hasLastValue = false;
    }

    IntKeyIntChainedHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultIntHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public IntKeyIntChainedHashMap() {
        this(11);
    }

    public IntKeyIntChainedHashMap(IntKeyIntMap map) {
        this();
        this.putAll(map);
    }

    public IntKeyIntChainedHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public IntKeyIntChainedHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public IntKeyIntChainedHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public IntKeyIntChainedHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public IntKeyIntChainedHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public IntKeyIntChainedHashMap(IntHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public IntKeyIntChainedHashMap(IntHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public IntKeyIntChainedHashMap(IntHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public IntKeyIntChainedHashMap(IntHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public IntKeyIntChainedHashMap(IntHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public IntKeyIntChainedHashMap(IntHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            Entry[] newdata = new Entry[newcapacity];
            int i = 0;
            while (i < this.data.length) {
                Entry e = this.data[i];
                while (e != null) {
                    int index = Math.abs(this.keyhash.hash(e.key)) % newdata.length;
                    Entry next = e.next;
                    e.next = newdata[index];
                    newdata[index] = e;
                    e = next;
                }
                ++i;
            }
            this.data = newdata;
        }
    }

    private Entry addList(Entry list, Entry v) {
        v.next = list;
        return v;
    }

    private Entry removeList(Entry list, Entry e) {
        if (list == e) {
            list = e.next;
            e.next = null;
            return list;
        }
        Entry listStart = list;
        while (list.next != e) {
            list = list.next;
        }
        list.next = e.next;
        e.next = null;
        return listStart;
    }

    private Entry searchList(Entry list, int key) {
        while (list != null) {
            if (list.key == key) {
                return list;
            }
            list = list.next;
        }
        return null;
    }

    private Entry getEntry(int key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        return this.searchList(this.data[index], key);
    }

    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public int lget() {
        if (!this.hasLastValue) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public int put(int key, int value) {
        int result;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            result = MapDefaults.defaultInt();
            e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            this.ensureCapacity(this.size + 1);
            ++this.size;
        } else {
            result = e.value;
            e.value = value;
        }
        return result;
    }

    public IntCollection values() {
        if (this.values == null) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public Object clone() {
        try {
            IntKeyIntChainedHashMap c = (IntKeyIntChainedHashMap)super.clone();
            c.data = new Entry[this.data.length];
            int i = 0;
            while (i < this.data.length) {
                c.data[i] = this.cloneList(this.data[i]);
                ++i;
            }
            c.values = null;
            c.keys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    private Entry cloneList(Entry e) {
        if (e == null) {
            return null;
        }
        Entry ne = new Entry(e.getKey(), e.getValue());
        ne.next = this.cloneList(e.next);
        return ne;
    }

    public IntKeyIntMapIterator entries() {
        return new 2();
    }

    public void clear() {
        Arrays.fill(this.data, null);
        this.size = 0;
    }

    public boolean containsKey(int key) {
        Entry e = this.getEntry(key);
        if (e == null) {
            this.hasLastValue = false;
        } else {
            this.hasLastValue = true;
            this.lastValue = e.value;
        }
        return this.hasLastValue;
    }

    public boolean containsValue(int value) {
        int i = 0;
        while (i < this.data.length) {
            Entry e = this.data[i];
            while (e != null) {
                if (e.value == value) {
                    return true;
                }
                e = e.next;
            }
            ++i;
        }
        return false;
    }

    public int get(int key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        return e != null ? e.value : MapDefaults.defaultInt();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int remove(int key) {
        int value;
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e != null) {
            this.data[index] = this.removeList(this.data[index], e);
            value = e.value;
            this.size += -1;
        } else {
            value = MapDefaults.defaultInt();
        }
        return value;
    }

    public int size() {
        return this.size;
    }

    public int tget(int key) {
        int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
        Entry e = this.searchList(this.data[index], key);
        if (e == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return e.value;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        IntKeyIntMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeInt(i.getKey());
            s.writeInt(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new Entry[s.readInt()];
        int i = 0;
        while (i < this.size) {
            int key = s.readInt();
            int value = s.readInt();
            int index = Math.abs(this.keyhash.hash(key)) % this.data.length;
            Entry e = new Entry(key, value);
            e.next = this.data[index];
            this.data[index] = e;
            ++i;
        }
    }

    private static class Entry {
        int key;
        int value;
        Entry next;

        Entry(int key, int value) {
            this.key = key;
            this.value = value;
        }

        public int getKey() {
            return this.key;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return e.getKey() == this.key && e.getValue() == this.value;
        }
    }

    private class KeySet
    extends AbstractIntSet {
        public void clear() {
            IntKeyIntChainedHashMap.this.clear();
        }

        public boolean contains(int v) {
            return IntKeyIntChainedHashMap.this.getEntry(v) != null;
        }

        public IntIterator iterator() {
            return new 3();
        }

        public boolean remove(int v) {
            boolean result = IntKeyIntChainedHashMap.this.containsKey(v);
            if (result) {
                IntKeyIntChainedHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return IntKeyIntChainedHashMap.this.size;
        }

        class 3
        implements IntIterator {
            Entry currEntry = null;
            int nextList = this.nextList(0);
            Entry nextEntry = this.nextList == -1 ? null : IntKeyIntChainedHashMap.access$L1000005(KeySet.access$0(KeySet.this))[this.nextList];

            3() {
            }

            int nextList(int index) {
                while (index < IntKeyIntChainedHashMap.this.data.length && IntKeyIntChainedHashMap.this.data[index] == null) {
                    ++index;
                }
                return index < IntKeyIntChainedHashMap.this.data.length ? index : -1;
            }

            public boolean hasNext() {
                return this.nextEntry != null;
            }

            public int next() {
                if (this.nextEntry == null) {
                    Exceptions.endOfIterator();
                }
                this.currEntry = this.nextEntry;
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry == null) {
                    this.nextList = this.nextList(this.nextList + 1);
                    if (this.nextList != -1) {
                        this.nextEntry = IntKeyIntChainedHashMap.this.data[this.nextList];
                    }
                }
                return this.currEntry.key;
            }

            public void remove() {
                if (this.currEntry == null) {
                    Exceptions.noElementToRemove();
                }
                IntKeyIntChainedHashMap.this.remove(this.currEntry.getKey());
                this.currEntry = null;
            }

            static /* synthetic */ KeySet access$0(3 var0) {
                return var0.KeySet.this;
            }
        }
    }

    private class ValueCollection
    extends AbstractIntCollection {
        public void clear() {
            IntKeyIntChainedHashMap.this.clear();
        }

        public boolean contains(int v) {
            return IntKeyIntChainedHashMap.this.containsValue(v);
        }

        public IntIterator iterator() {
            return new 5();
        }

        public int size() {
            return IntKeyIntChainedHashMap.this.size;
        }

        class 5
        implements IntIterator {
            Entry currEntry = null;
            int nextList = this.nextList(0);
            Entry nextEntry = this.nextList == -1 ? null : IntKeyIntChainedHashMap.access$L1000005(ValueCollection.access$0(ValueCollection.this))[this.nextList];

            5() {
            }

            int nextList(int index) {
                while (index < IntKeyIntChainedHashMap.this.data.length && IntKeyIntChainedHashMap.this.data[index] == null) {
                    ++index;
                }
                return index < IntKeyIntChainedHashMap.this.data.length ? index : -1;
            }

            public boolean hasNext() {
                return this.nextEntry != null;
            }

            public int next() {
                if (this.nextEntry == null) {
                    Exceptions.endOfIterator();
                }
                this.currEntry = this.nextEntry;
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry == null) {
                    this.nextList = this.nextList(this.nextList + 1);
                    if (this.nextList != -1) {
                        this.nextEntry = IntKeyIntChainedHashMap.this.data[this.nextList];
                    }
                }
                return this.currEntry.value;
            }

            public void remove() {
                if (this.currEntry == null) {
                    Exceptions.noElementToRemove();
                }
                IntKeyIntChainedHashMap.this.remove(this.currEntry.getKey());
                this.currEntry = null;
            }

            static /* synthetic */ ValueCollection access$0(5 var0) {
                return var0.ValueCollection.this;
            }
        }
    }

    class 2
    implements IntKeyIntMapIterator {
        Entry currEntry = null;
        int nextList = this.nextList(0);
        Entry nextEntry = this.nextList == -1 ? null : IntKeyIntChainedHashMap.access$L1000005(IntKeyIntChainedHashMap.this)[this.nextList];

        2() {
        }

        int nextList(int index) {
            while (index < IntKeyIntChainedHashMap.this.data.length && IntKeyIntChainedHashMap.this.data[index] == null) {
                ++index;
            }
            return index < IntKeyIntChainedHashMap.this.data.length ? index : -1;
        }

        public boolean hasNext() {
            return this.nextEntry != null;
        }

        public void next() {
            if (this.nextEntry == null) {
                Exceptions.endOfIterator();
            }
            this.currEntry = this.nextEntry;
            this.nextEntry = this.nextEntry.next;
            if (this.nextEntry == null) {
                this.nextList = this.nextList(this.nextList + 1);
                if (this.nextList != -1) {
                    this.nextEntry = IntKeyIntChainedHashMap.this.data[this.nextList];
                }
            }
        }

        public int getKey() {
            if (this.currEntry == null) {
                Exceptions.noElementToGet();
            }
            return this.currEntry.getKey();
        }

        public int getValue() {
            if (this.currEntry == null) {
                Exceptions.noElementToGet();
            }
            return this.currEntry.getValue();
        }

        public void remove() {
            if (this.currEntry == null) {
                Exceptions.noElementToRemove();
            }
            IntKeyIntChainedHashMap.this.remove(this.currEntry.getKey());
            this.currEntry = null;
        }

        static /* synthetic */ IntKeyIntChainedHashMap access$0(2 var0) {
            return var0.IntKeyIntChainedHashMap.this;
        }
    }
}

