/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.pcj;

import com.uwyn.rife.pcj.CharCollection;
import com.uwyn.rife.pcj.CharIterator;
import com.uwyn.rife.pcj.util.Display;
import com.uwyn.rife.pcj.util.Exceptions;

public abstract class AbstractCharCollection
implements CharCollection {
    protected AbstractCharCollection() {
    }

    public boolean add(char v) {
        Exceptions.unsupported("add");
        return false;
    }

    public boolean addAll(CharCollection c) {
        CharIterator i = c.iterator();
        boolean result = false;
        while (i.hasNext()) {
            result |= this.add(i.next());
        }
        return result;
    }

    public void clear() {
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public boolean contains(char v) {
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            if (i.next() != v) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(CharCollection c) {
        CharIterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean remove(char v) {
        CharIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (i.next() != v) continue;
            i.remove();
            result = true;
            break;
        }
        return result;
    }

    public boolean removeAll(CharCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        CharIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (!c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public boolean retainAll(CharCollection c) {
        if (c == null) {
            Exceptions.nullArgument("collection");
        }
        CharIterator i = this.iterator();
        boolean result = false;
        while (i.hasNext()) {
            if (c.contains(i.next())) continue;
            i.remove();
            result = true;
        }
        return result;
    }

    public int size() {
        CharIterator i = this.iterator();
        int size = 0;
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public char[] toArray() {
        return this.toArray(null);
    }

    public char[] toArray(char[] a) {
        int size = this.size();
        if (a == null || a.length < size) {
            a = new char[size];
        }
        CharIterator i = this.iterator();
        int index = 0;
        while (i.hasNext()) {
            a[index] = i.next();
            ++index;
        }
        return a;
    }

    public void trimToSize() {
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        CharIterator i = this.iterator();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            s.append(Display.display(i.next()));
        }
        s.append(']');
        return s.toString();
    }
}

