/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.mail.dao;

import com.uwyn.rife.site.ConstrainedBean;
import com.uwyn.rife.site.ConstrainedProperty;
import com.uwyn.rife.site.Validation;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
extends Validation<ConstrainedBean, ConstrainedProperty> {
    private int mId = -1;
    private String mFromAddress = null;
    private String mToAddresses = null;
    private String mSubject = null;
    private String mBody = null;
    private String mCcAddresses = null;
    private String mBccAddresses = null;
    private boolean mQueueFlag = false;

    @Override
    protected void activateValidation() {
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("id").notNull(true)).identifier(true));
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("fromAddress").notNull(true)).notEmpty(true)).maxLength(255));
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("toAddresses").notNull(true)).notEmpty(true)).maxLength(255));
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("subject").notNull(true)).notEmpty(true)).maxLength(255));
        this.addConstraint((ConstrainedProperty)((ConstrainedProperty)new ConstrainedProperty("body").notNull(true)).notEmpty(true));
        this.addConstraint((ConstrainedProperty)new ConstrainedProperty("ccAddresses").maxLength(255));
        this.addConstraint((ConstrainedProperty)new ConstrainedProperty("bccAddresses").maxLength(255));
    }

    public Email id(int id) {
        this.mId = id;
        return this;
    }

    public void setId(int id) {
        this.mId = id;
    }

    public int getId() {
        return this.mId;
    }

    public Email from(String from) {
        this.mFromAddress = from;
        return this;
    }

    public void setFromAddress(String from) {
        this.mFromAddress = from;
    }

    public String getFromAddress() {
        return this.mFromAddress;
    }

    public Email to(String toAddress) {
        this.addTo(toAddress);
        return this;
    }

    public void addTo(String toAddress) {
        this.mToAddresses = this.mToAddresses == null ? toAddress : new StringBuffer().append(this.mToAddresses).append(new StringBuffer().append(",").append(toAddress).toString()).toString();
    }

    public Email toAddresses(String toAddresses) {
        this.setToAddresses(toAddresses);
        return this;
    }

    public void setToAddresses(String toAddresses) {
        this.mToAddresses = toAddresses;
    }

    public String getToAddresses() {
        return this.mToAddresses;
    }

    public Email subject(String subject) {
        this.mSubject = subject;
        return this;
    }

    public void setSubject(String subject) {
        this.mSubject = subject;
    }

    public String getSubject() {
        return this.mSubject;
    }

    public Email body(String body) {
        this.mBody = body;
        return this;
    }

    public void setBody(String body) {
        this.mBody = body;
    }

    public String getBody() {
        return this.mBody;
    }

    public Email cc(String ccAddress) {
        this.addCc(ccAddress);
        return this;
    }

    public void addCc(String ccAddress) {
        this.mCcAddresses = this.mCcAddresses == null ? ccAddress : new StringBuffer().append(this.mCcAddresses).append(new StringBuffer().append(",").append(ccAddress).toString()).toString();
    }

    public Email ccAddresses(String ccAddresses) {
        this.setCcAddresses(ccAddresses);
        return this;
    }

    public void setCcAddresses(String ccAddresses) {
        this.mCcAddresses = ccAddresses;
    }

    public String getCcAddresses() {
        return this.mCcAddresses;
    }

    public Email bcc(String bccAddress) {
        this.addBcc(bccAddress);
        return this;
    }

    public void addBcc(String bccAddress) {
        this.mBccAddresses = this.mCcAddresses == null ? bccAddress : new StringBuffer().append(this.mBccAddresses).append(new StringBuffer().append(",").append(bccAddress).toString()).toString();
    }

    public Email bccAddresses(String bccAddresses) {
        this.setBccAddresses(bccAddresses);
        return this;
    }

    public void setBccAddresses(String bccAddresses) {
        this.mBccAddresses = bccAddresses;
    }

    public String getBccAddresses() {
        return this.mBccAddresses;
    }

    public boolean getQueueFlag() {
        return this.mQueueFlag;
    }

    public void setQueueFlag(boolean queueFlag) {
        this.mQueueFlag = queueFlag;
    }

    public int hashCode() {
        int result = 0;
        result = 29 * result + (this.mFromAddress != null ? this.mFromAddress.hashCode() : 0);
        result = 29 * result + (this.mToAddresses != null ? this.mToAddresses.hashCode() : 0);
        result = 29 * result + (this.mSubject != null ? this.mSubject.hashCode() : 0);
        result = 29 * result + (this.mBody != null ? this.mBody.hashCode() : 0);
        result = 29 * result + (this.mCcAddresses != null ? this.mCcAddresses.hashCode() : 0);
        result = 29 * result + (this.mBccAddresses != null ? this.mBccAddresses.hashCode() : 0);
        return result;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof Email)) {
            return false;
        }
        Email other_email = (Email)other;
        if (other_email.getFromAddress() != null || this.getFromAddress() != null) {
            if (other_email.getFromAddress() == null || this.getFromAddress() == null) {
                return false;
            }
            if (!other_email.getFromAddress().equals(this.getFromAddress())) {
                return false;
            }
        }
        if (other_email.getToAddresses() != null || this.getToAddresses() != null) {
            if (other_email.getToAddresses() == null || this.getToAddresses() == null) {
                return false;
            }
            if (!other_email.getToAddresses().equals(this.getToAddresses())) {
                return false;
            }
        }
        if (other_email.getSubject() != null || this.getSubject() != null) {
            if (other_email.getSubject() == null || this.getSubject() == null) {
                return false;
            }
            if (!other_email.getSubject().equals(this.getSubject())) {
                return false;
            }
        }
        if (other_email.getBody() != null || this.getBody() != null) {
            if (other_email.getBody() == null || this.getBody() == null) {
                return false;
            }
            if (!other_email.getBody().equals(this.getBody())) {
                return false;
            }
        }
        if (other_email.getCcAddresses() != null || this.getCcAddresses() != null) {
            if (other_email.getCcAddresses() == null || this.getCcAddresses() == null) {
                return false;
            }
            if (!other_email.getCcAddresses().equals(this.getCcAddresses())) {
                return false;
            }
        }
        if (other_email.getBccAddresses() != null || this.getBccAddresses() != null) {
            if (other_email.getBccAddresses() == null || this.getBccAddresses() == null) {
                return false;
            }
            if (!other_email.getBccAddresses().equals(this.getBccAddresses())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append("Email{").append("mId=").toString()).append(this.mId).toString()).append(", mFromAddress=").toString()).append(this.mFromAddress).toString()).append(", mToAddresses=").toString()).append(this.mToAddresses).toString()).append(", mSubject=").toString()).append(this.mSubject).toString()).append(", mBody=").toString()).append(this.mBody).toString()).append(", mCcAddresses=").toString()).append(this.mCcAddresses).toString()).append(", mBccAddresses=").toString()).append(this.mBccAddresses).toString()).append("}").toString();
    }
}

