/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.mail.dam;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManager;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManagerFactory;
import com.uwyn.rife.mail.MailQueueManager;
import com.uwyn.rife.mail.dao.Email;
import com.uwyn.rife.mail.exceptions.InstallMailQueueErrorException;
import com.uwyn.rife.mail.exceptions.MailQueueManagerException;
import com.uwyn.rife.mail.exceptions.RemoveMailQueueErrorException;
import com.uwyn.rife.site.ConstrainedBean;

public class DatabaseMailQueue
extends DbQueryManager
implements MailQueueManager {
    protected GenericQueryManager<Email> mManager = null;

    protected DatabaseMailQueue(Datasource datasource) {
        super(datasource);
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.mail.dao.Email");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mManager = GenericQueryManagerFactory.getInstance(datasource, clazz);
    }

    public boolean install() {
        try {
            this.mManager.install();
        }
        catch (DatabaseException e) {
            throw new InstallMailQueueErrorException(e);
        }
        return true;
    }

    public boolean remove() {
        try {
            this.mManager.remove();
        }
        catch (DatabaseException e) {
            throw new RemoveMailQueueErrorException(e);
        }
        return true;
    }

    public boolean queue(Email email) {
        if (email == null) {
            return false;
        }
        email.addConstraint((ConstrainedBean)new ConstrainedBean().unique(new String[]{"fromAddress", "toAddresses", "ccAddresses", "bccAddresses", "subject", "body"}));
        if (!email.validate(this.mManager)) {
            return false;
        }
        try {
            this.mManager.save(email);
        }
        catch (DatabaseException e) {
            throw new MailQueueManagerException(e);
        }
        return true;
    }
}

