/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine.elements.axis;

import com.uwyn.rife.resources.ResourceFinderClasspath;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Handler;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.utils.XMLUtils;

public class RifeProvider
implements WSDDEngineConfiguration {
    private WSDDDeployment mDeployment = null;
    private String mWsddPath = null;
    private URL mWsddResource = null;

    public RifeProvider(String wsddPath) {
        if (wsddPath == null) {
            throw new IllegalArgumentException("wsddPath can't be null.");
        }
        this.mWsddPath = wsddPath;
        this.mWsddResource = ResourceFinderClasspath.getInstance().getResource(wsddPath);
    }

    public WSDDDeployment getDeployment() {
        return this.mDeployment;
    }

    public void configureEngine(AxisEngine engine) throws ConfigurationException {
        try {
            InputStream input_stream = null;
            if (this.mWsddResource != null) {
                try {
                    input_stream = this.mWsddResource.openStream();
                }
                catch (IOException e) {
                    input_stream = null;
                }
            }
            if (input_stream == null) {
                throw new ConfigurationException("Unable to find the Axis server configuration file : '" + this.mWsddPath + "'.");
            }
            WSDDDocument document = new WSDDDocument(XMLUtils.newDocument((InputStream)input_stream));
            this.mDeployment = document.getDeployment();
            this.mDeployment.configureEngine(engine);
            engine.refreshGlobalOptions();
            input_stream.close();
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    public void writeEngineConfig(AxisEngine engine) throws ConfigurationException {
    }

    public Handler getHandler(QName qname) throws ConfigurationException {
        return this.mDeployment.getHandler(qname);
    }

    public SOAPService getService(QName qname) throws ConfigurationException {
        return this.mDeployment.getService(qname);
    }

    public SOAPService getServiceByNamespaceURI(String namespace) throws ConfigurationException {
        return this.mDeployment.getServiceByNamespaceURI(namespace);
    }

    public Handler getTransport(QName qname) throws ConfigurationException {
        return this.mDeployment.getTransport(qname);
    }

    public TypeMappingRegistry getTypeMappingRegistry() throws ConfigurationException {
        return this.mDeployment.getTypeMappingRegistry();
    }

    public Handler getGlobalRequest() throws ConfigurationException {
        return this.mDeployment.getGlobalRequest();
    }

    public Handler getGlobalResponse() throws ConfigurationException {
        return this.mDeployment.getGlobalResponse();
    }

    public Hashtable getGlobalOptions() throws ConfigurationException {
        WSDDGlobalConfiguration globalConfig = this.mDeployment.getGlobalConfiguration();
        if (globalConfig != null) {
            return globalConfig.getParametersTable();
        }
        return null;
    }

    public Iterator getDeployedServices() throws ConfigurationException {
        return this.mDeployment.getDeployedServices();
    }
}

