/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine.elements.axis;

import com.uwyn.rife.engine.elements.axis.JwsClassLoader;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.tools.ClasspathUtils;
import com.uwyn.rife.tools.CompilationUtils;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.InnerClassException;
import com.uwyn.rife.tools.InputStreamUser;
import com.uwyn.rife.tools.exceptions.CompilationFailedException;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.apache.axis.utils.ClassUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JwsHandler
extends BasicHandler {
    protected static Log log;
    public static final String SCOPE_REQUEST = "Request";
    public static final String SCOPE_APPLICATION = "Application";
    public static final String SCOPE_SESSION = "Session";
    public static final String SCOPE_DEFAULT = "Request";
    public final String OPTION_JWS_FILE_EXTENSION = "extension";
    public final String DEFAULT_JWS_FILE_EXTENSION = ".jws";
    protected static HashMap<String, SOAPService> soapServices;

    public void invoke(MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: JWSHandler::invoke");
        }
        try {
            this.setupService(msgContext);
        }
        catch (Exception e) {
            log.error((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
            throw AxisFault.makeFault((Exception)e);
        }
    }

    protected void setupService(MessageContext msgContext) throws Exception {
        String filename_jws = msgContext.getStrProp("path");
        String extension = (String)this.getOption("extension");
        if (extension == null) {
            extension = ".jws";
        }
        if (filename_jws != null && filename_jws.endsWith(extension)) {
            ClassLoader cl;
            File package_file;
            if (filename_jws.charAt(0) == '/') {
                filename_jws = filename_jws.substring(1);
            }
            int lastSlash = filename_jws.lastIndexOf(47);
            String dir = null;
            if (lastSlash > 0) {
                dir = filename_jws.substring(0, lastSlash);
            }
            String file = filename_jws.substring(lastSlash + 1);
            String package_path = msgContext.getStrProp("jws.classDir");
            if (package_path == null) {
                package_path = ".";
            }
            if (dir != null) {
                package_path = package_path + File.separator + dir;
            }
            if (!(package_file = new File(package_path)).exists()) {
                package_file.mkdirs();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("jwsFile: " + filename_jws));
            }
            String filename_java = package_path + File.separator + file.substring(0, file.length() - 3) + "java";
            String filename_class = package_path + File.separator + file.substring(0, file.length() - 3) + "class";
            if (log.isDebugEnabled()) {
                log.debug((Object)("jFile: " + filename_java));
                log.debug((Object)("cFile: " + filename_class));
                log.debug((Object)("outdir: " + package_path));
            }
            File file_class = new File(filename_class);
            File file_java = new File(filename_java);
            String classname = filename_jws;
            if (classname.charAt(0) == '/') {
                classname = classname.substring(1);
            }
            classname = classname.substring(0, classname.length() - 4);
            classname = classname.replace('/', '.');
            if (log.isDebugEnabled()) {
                log.debug((Object)("ClsName: " + classname));
            }
            if (!file_class.exists() || ResourceFinderClasspath.getInstance().getModificationTime(filename_jws) > file_class.lastModified()) {
                try {
                    ResourceFinderClasspath.getInstance().useStream(filename_jws, (InputStreamUser)new 1(file_java));
                }
                catch (InnerClassException e) {
                    throw e.getCause();
                }
                log.debug((Object)("javac " + filename_java));
                try {
                    try {
                        CompilationUtils.compile(filename_java, file_class, msgContext.getStrProp("jws.classDir"), ClasspathUtils.getClassPath(this.getClass()));
                    }
                    catch (CompilationFailedException e) {
                        new File(filename_class).delete();
                        Document doc = XMLUtils.newDocument();
                        Element root = doc.createElementNS("", "Errors");
                        StringBuffer message = new StringBuffer("Error compiling ");
                        message.append(filename_java);
                        message.append(":\n");
                        message.append(e.getErrors());
                        root.appendChild(doc.createTextNode(message.toString()));
                        throw new AxisFault("Server.compileError", Messages.getMessage((String)"badCompile00", (String)filename_java), null, new Element[]{root});
                    }
                }
                finally {
                    file_java.delete();
                }
                ClassUtils.removeClassLoader((String)classname);
                soapServices.remove(classname);
            }
            if ((cl = ClassUtils.getClassLoader((String)classname)) == null) {
                cl = new JwsClassLoader(classname, msgContext.getClassLoader(), filename_class);
            }
            msgContext.setClassLoader(cl);
            SOAPService rpc = soapServices.get(classname);
            if (rpc == null) {
                rpc = new SOAPService((Handler)new RPCProvider());
                rpc.setOption("className", (Object)classname);
                rpc.setEngine(msgContext.getAxisEngine());
                String allowed = (String)this.getOption("allowedMethods");
                if (allowed == null) {
                    allowed = "*";
                }
                rpc.setOption("allowedMethods", (Object)allowed);
                String scope = (String)this.getOption("scope");
                if (scope == null) {
                    scope = "Request";
                }
                rpc.setOption("scope", (Object)scope);
                ServiceDesc sd = rpc.getServiceDescription();
                TypeMappingRegistry tmr = msgContext.getAxisEngine().getTypeMappingRegistry();
                sd.setTypeMappingRegistry(tmr);
                sd.setTypeMapping(msgContext.getTypeMapping());
                rpc.getInitializedServiceDesc(msgContext);
                soapServices.put(classname, rpc);
            }
            rpc.setEngine(msgContext.getAxisEngine());
            rpc.init();
            msgContext.setService(rpc);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: JWSHandler::invoke");
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.elements.axis.JwsHandler");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        log = LogFactory.getLog((String)clazz.getName());
        soapServices = new HashMap();
    }

    class 1
    extends InputStreamUser {
        private final /* synthetic */ File val$file_java;

        1(File file) {
            this.val$file_java = file;
        }

        public Object useInputStream(InputStream stream) {
            try {
                FileUtils.copy(stream, this.val$file_java);
            }
            catch (FileUtilsErrorException e) {
                this.throwException(e);
            }
            return null;
        }

        static /* synthetic */ JwsHandler access$0(1 var0) {
            return var0.JwsHandler.this;
        }
    }
}

