/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine.elements;

import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import com.caucho.services.server.Service;
import com.uwyn.rife.engine.ElementDeployer;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.engine.exceptions.PropertyRequiredException;
import com.uwyn.rife.tools.IteratorEnumeration;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public class WebservicesHessianDeployer
extends ElementDeployer {
    private Class mHomeAPI;
    private Object mHomeImpl;
    private Class mObjectAPI;
    private Object mObjectImpl;
    private HessianSkeleton mHomeSkeleton;
    private HessianSkeleton mObjectSkeleton;
    private SerializerFactory mSerializerFactory;

    public void deploy() {
        try {
            String class_name;
            if (this.mHomeImpl == null) {
                Class home_class;
                if (this.getElementInfo().hasProperty("home-class")) {
                    class_name = this.getElementInfo().getPropertyString("home-class");
                    home_class = this.loadClass(class_name);
                    this.mHomeImpl = home_class.newInstance();
                    this.init(this.mHomeImpl);
                } else if (this.getElementInfo().hasProperty("service-class")) {
                    class_name = this.getElementInfo().getPropertyString("service-class");
                    home_class = this.loadClass(class_name);
                    this.mHomeImpl = home_class.newInstance();
                    this.init(this.mHomeImpl);
                } else if (!this.getElementInfo().hasProperty("service-class")) {
                    throw new PropertyRequiredException(this.getElementInfo().getDeclarationName(), "service-class");
                }
            }
            if (this.mHomeAPI == null) {
                if (this.getElementInfo().hasProperty("home-api")) {
                    class_name = this.getElementInfo().getPropertyString("home-api");
                    this.mHomeAPI = this.loadClass(class_name);
                } else if (this.getElementInfo().hasProperty("api-class")) {
                    class_name = this.getElementInfo().getPropertyString("api-class");
                    this.mHomeAPI = this.loadClass(class_name);
                } else if (this.mHomeImpl != null) {
                    this.mHomeAPI = this.findRemoteAPI(this.mHomeImpl.getClass());
                    if (this.mHomeAPI == null) {
                        this.mHomeAPI = this.mHomeImpl.getClass();
                    }
                }
            }
            if (this.mObjectImpl == null && this.getElementInfo().hasProperty("object-class")) {
                class_name = this.getElementInfo().getPropertyString("object-class");
                Class object_class = this.loadClass(class_name);
                this.mObjectImpl = object_class.newInstance();
                this.init(this.mObjectImpl);
            }
            if (this.mObjectAPI == null) {
                if (this.getElementInfo().hasProperty("object-api")) {
                    class_name = this.getElementInfo().getPropertyString("object-api");
                    this.mObjectAPI = this.loadClass(class_name);
                } else if (this.mObjectImpl != null) {
                    this.mObjectAPI = this.mObjectImpl.getClass();
                }
            }
            this.mHomeSkeleton = new HessianSkeleton(this.mHomeImpl, this.mHomeAPI);
            if (this.mObjectAPI != null) {
                this.mHomeSkeleton.setObjectClass(this.mObjectAPI);
            }
            if (this.mObjectImpl != null) {
                this.mObjectSkeleton = new HessianSkeleton(this.mObjectImpl, this.mObjectAPI);
                this.mObjectSkeleton.setHomeClass(this.mHomeAPI);
            } else {
                this.mObjectSkeleton = this.mHomeSkeleton;
            }
        }
        catch (Exception e) {
            throw new EngineException(e);
        }
    }

    private Class findRemoteAPI(Class implClass) {
        block7: {
            block6: {
                Class<?> clazz;
                if (implClass == null) break block6;
                try {
                    clazz = Class.forName("com.caucho.services.server.GenericService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (!implClass.equals(clazz)) break block7;
            }
            return null;
        }
        Class<?>[] interfaces = implClass.getInterfaces();
        if (interfaces.length == 1) {
            return interfaces[0];
        }
        return this.findRemoteAPI(implClass.getSuperclass());
    }

    private Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return Class.forName(className, false, loader);
        }
        return Class.forName(className);
    }

    private void init(Object service) throws ServletException {
        if (service instanceof Service) {
            ((Service)service).init((ServletConfig)new 1());
        }
    }

    public HessianSkeleton getHomeSkeleton() {
        return this.mHomeSkeleton;
    }

    public HessianSkeleton getObjectSkeleton() {
        return this.mObjectSkeleton;
    }

    public void setHomeAPI(Class api) {
        this.mHomeAPI = api;
    }

    public void setHome(Object home) {
        this.mHomeImpl = home;
    }

    Object getHome() {
        return this.mHomeImpl;
    }

    public void setObjectAPI(Class api) {
        this.mObjectAPI = api;
    }

    public void setObject(Object object) {
        this.mObjectImpl = object;
    }

    Object getObject() {
        return this.mObjectImpl;
    }

    public void setService(Object service) {
        this.setHome(service);
    }

    public void setAPIClass(Class api) {
        this.setHomeAPI(api);
    }

    public Class getAPIClass() {
        return this.mHomeAPI;
    }

    public void setSerializerFactory(SerializerFactory factory) {
        this.mSerializerFactory = factory;
    }

    public SerializerFactory getSerializerFactory() {
        if (this.mSerializerFactory == null) {
            this.mSerializerFactory = new SerializerFactory();
        }
        return this.mSerializerFactory;
    }

    public void setSendCollectionType(boolean sendType) {
        this.getSerializerFactory().setSendCollectionType(sendType);
    }

    class 1
    implements ServletConfig {
        1() {
        }

        public String getServletName() {
            return WebservicesHessianDeployer.this.getElementInfo().getDeclarationName();
        }

        public ServletContext getServletContext() {
            return null;
        }

        public String getInitParameter(String key) {
            return WebservicesHessianDeployer.this.getElementInfo().getPropertyString(key);
        }

        public Enumeration getInitParameterNames() {
            return new IteratorEnumeration(WebservicesHessianDeployer.this.getElementInfo().getPropertyNames().iterator());
        }

        static /* synthetic */ WebservicesHessianDeployer access$0(1 var0) {
            return var0.WebservicesHessianDeployer.this;
        }
    }
}

