/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine.elements;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.Element;
import com.uwyn.rife.engine.RequestMethod;
import com.uwyn.rife.engine.elements.SoapAxisDeployer;
import com.uwyn.rife.tools.ExceptionUtils;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.session.Session;
import org.apache.axis.transport.http.AxisHttpSession;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class SoapAxis
extends Element {
    private static Log mLogException;
    private static Log mLogElement;
    private static Log mLogTiming;
    private String mWebinfPath = null;
    private boolean mIsDebug = false;
    private boolean mIsDevelopment = false;
    private String mTransportName = null;
    private ServletSecurityProvider mSecurityProvider = null;

    public void init() {
        ServletContext context = this.getInitConfig().getServletContext();
        this.mWebinfPath = context.getRealPath("/WEB-INF");
        this.mIsDebug = mLogElement.isDebugEnabled();
        if (mLogElement.isDebugEnabled()) {
            mLogElement.debug((Object)"In AxisServletBase init");
        }
        if (this.mIsDebug) {
            mLogElement.debug((Object)"In servlet init");
        }
        this.mTransportName = this.getOption("transport.name", "http");
        if (JavaUtils.isTrueExplicitly((String)this.getOption("use-servlet-security", null))) {
            this.mSecurityProvider = new ServletSecurityProvider();
        }
    }

    public void processElement() {
        this.init();
        ((SoapAxisDeployer)this.getDeployer()).increaseLoadCounter();
        try {
            if (this.getMethod() == RequestMethod.POST) {
                try {
                    this.handleSoap();
                }
                catch (IOException e) {
                    this.print(ExceptionUtils.getExceptionStackTrace(e));
                }
                catch (ServletException e) {
                    this.print(ExceptionUtils.getExceptionStackTrace(e));
                }
            }
        }
        finally {
            ((SoapAxisDeployer)this.getDeployer()).decreaseLoadCounter();
        }
    }

    public Class getDeploymentClass() {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.elements.SoapAxisDeployer");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return clazz;
    }

    public boolean prohibitRawAccess() {
        return false;
    }

    public void handleSoap() throws IOException, ServletException {
        String contentType;
        Message responseMsg;
        MessageContext msgContext;
        String soapAction;
        long t4;
        long t3;
        long t2;
        long t1;
        long t0;
        block22: {
            t0 = 0;
            t1 = 0;
            t2 = 0;
            t3 = 0;
            t4 = 0;
            soapAction = null;
            msgContext = null;
            if (this.mIsDebug) {
                mLogElement.debug((Object)"Enter: doPost()");
            }
            if (mLogTiming.isDebugEnabled()) {
                t0 = System.currentTimeMillis();
            }
            HttpServletRequest request = this.getHttpServletRequest();
            responseMsg = null;
            contentType = null;
            try {
                AxisServer engine = ((SoapAxisDeployer)this.getDeployer()).getEngine();
                if (engine == null) {
                    ServletException se = new ServletException(Messages.getMessage((String)"noEngine00"));
                    mLogElement.debug((Object)"No Engine!", (Throwable)se);
                    throw se;
                }
                msgContext = this.createMessageContext((AxisEngine)engine);
                if (this.mSecurityProvider != null) {
                    if (this.mIsDebug) {
                        mLogElement.debug((Object)("securityProvider:" + this.mSecurityProvider));
                    }
                    msgContext.setProperty("securityProvider", (Object)this.mSecurityProvider);
                }
                Message requestMsg = new Message((Object)request.getInputStream(), false, this.getHeader("Content-Type"), this.getHeader("Content-Location"));
                if (this.mIsDebug) {
                    mLogElement.debug((Object)("Request Message:" + requestMsg));
                }
                msgContext.setRequestMessage(requestMsg);
                String url = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
                msgContext.setProperty("transport.url", (Object)url);
                try {
                    soapAction = this.getSoapAction();
                    if (soapAction != null) {
                        msgContext.setUseSOAPAction(true);
                        msgContext.setSOAPActionURI(soapAction);
                    }
                    msgContext.setSession((Session)new AxisHttpSession(request));
                    if (mLogTiming.isDebugEnabled()) {
                        t1 = System.currentTimeMillis();
                    }
                    if (this.mIsDebug) {
                        mLogElement.debug((Object)"Invoking Axis Engine.");
                    }
                    engine.invoke(msgContext);
                    if (this.mIsDebug) {
                        mLogElement.debug((Object)"Return from Axis Engine.");
                    }
                    if (mLogTiming.isDebugEnabled()) {
                        t2 = System.currentTimeMillis();
                    }
                    if ((responseMsg = msgContext.getResponseMessage()) == null) {
                        throw new Exception(Messages.getMessage((String)"noResponse01"));
                    }
                }
                catch (AxisFault fault) {
                    this.processAxisFault(fault);
                    this.configureResponseFromAxisFault(fault);
                    responseMsg = msgContext.getResponseMessage();
                    if (responseMsg == null) {
                        responseMsg = new Message((Object)fault);
                    }
                }
                catch (Exception e) {
                    responseMsg = msgContext.getResponseMessage();
                    this.setStatus(500);
                    responseMsg = this.convertExceptionToAxisFault(e, responseMsg);
                }
            }
            catch (AxisFault fault) {
                this.processAxisFault(fault);
                this.configureResponseFromAxisFault(fault);
                responseMsg = msgContext.getResponseMessage();
                if (responseMsg != null) break block22;
                responseMsg = new Message((Object)fault);
            }
        }
        contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
        if (mLogTiming.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        if (responseMsg != null) {
            this.sendResponse(contentType, responseMsg);
        }
        if (this.mIsDebug) {
            mLogElement.debug((Object)"Response sent.");
            mLogElement.debug((Object)"Exit: doPost()");
        }
        if (mLogTiming.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            mLogTiming.debug((Object)("axisServlet.doPost: " + soapAction + " pre=" + (t1 - t0) + " invoke=" + (t2 - t1) + " post=" + (t3 - t2) + " send=" + (t4 - t3) + " " + msgContext.getTargetService() + "." + (msgContext.getOperation() == null ? "" : msgContext.getOperation().getName())));
        }
    }

    private void configureResponseFromAxisFault(AxisFault fault) {
        int status = this.getHttpServletResponseStatus(fault);
        if (status == 401) {
            this.setHeader("WWW-Authenticate", "Basic realm=\"AXIS\"");
        }
        this.setStatus(status);
    }

    private Message convertExceptionToAxisFault(Exception exception, Message responseMsg) {
        this.logException(exception);
        if (responseMsg == null) {
            AxisFault fault = AxisFault.makeFault((Exception)exception);
            this.processAxisFault(fault);
            responseMsg = new Message((Object)fault);
        }
        return responseMsg;
    }

    protected int getHttpServletResponseStatus(AxisFault fault) {
        return fault.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String contentType, Message response) throws AxisFault, IOException {
        if (response == null) {
            this.setStatus(204);
            if (this.mIsDebug) {
                mLogElement.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
        } else {
            if (this.mIsDebug) {
                mLogElement.debug((Object)("Returned Content-Type:" + contentType));
            }
            try {
                this.setContentType(contentType);
                response.writeTo(this.getOutputStream());
            }
            catch (SOAPException e) {
                this.logException((Exception)((Object)e));
            }
        }
        this.flush();
    }

    private MessageContext createMessageContext(AxisEngine engine) {
        MessageContext message_context = new MessageContext(engine);
        HttpServletRequest request = this.getHttpServletRequest();
        if (this.mIsDebug) {
            mLogElement.debug((Object)("MessageContext:" + message_context));
            mLogElement.debug((Object)("HEADER_CONTENT_TYPE:" + this.getHeader("Content-Type")));
            mLogElement.debug((Object)("HEADER_CONTENT_LOCATION:" + this.getHeader("Content-Location")));
            mLogElement.debug((Object)("Constants.MC_RELATIVE_PATH:" + request.getServletPath()));
            mLogElement.debug((Object)("HTTPConstants.MC_HTTP_SERVLETPATHINFO:" + this.getPathInfo()));
            mLogElement.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + this.getHeader("Authorization")));
            mLogElement.debug((Object)("Constants.MC_REMOTE_ADDR:" + this.getRemoteAddr()));
            mLogElement.debug((Object)("configPath:" + String.valueOf(this.getWebInfPath())));
        }
        String servicepath = this.getPathInfo();
        message_context.setTransportName(this.mTransportName);
        message_context.setProperty("jws.classDir", (Object)RifeConfig.Axis.getJwsclassesPath(this.getElementInfo().getId()));
        message_context.setProperty("path", (Object)servicepath);
        message_context.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, (Object)this.getPathInfo());
        message_context.setProperty("Authorization", (Object)this.getHeader("Authorization"));
        message_context.setProperty("remoteaddr", (Object)this.getRemoteAddr());
        message_context.setProperty("configPath", (Object)this.getWebInfPath());
        return message_context;
    }

    private String getSoapAction() throws AxisFault {
        String soapAction = this.getHeader("SOAPAction");
        if (this.mIsDebug) {
            mLogElement.debug((Object)("HEADER_SOAP_ACTION:" + soapAction));
        }
        if (soapAction == null) {
            AxisFault af = new AxisFault("Client.NoSOAPAction", Messages.getMessage((String)"noHeader00", (String)"SOAPAction"), null, null);
            mLogException.error((Object)Messages.getMessage((String)"genFault00"), (Throwable)af);
            throw af;
        }
        return soapAction;
    }

    protected String getWebInfPath() {
        return this.mWebinfPath;
    }

    protected String getOption(String param, String defaultValue) {
        String value = AxisProperties.getProperty((String)param);
        if (value == null) {
            value = this.getPropertyString(param);
        }
        return value != null ? value : defaultValue;
    }

    public boolean isDevelopment() {
        return this.mIsDevelopment;
    }

    protected void processAxisFault(AxisFault fault) {
        org.w3c.dom.Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (runtimeException != null) {
            mLogException.info((Object)Messages.getMessage((String)"axisFault00"), (Throwable)fault);
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        } else if (mLogException.isDebugEnabled()) {
            mLogException.debug((Object)Messages.getMessage((String)"axisFault00"), (Throwable)fault);
        }
        if (!this.isDevelopment()) {
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_STACKTRACE);
        }
    }

    protected void logException(Exception e) {
        mLogException.info((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
    }

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        try {
            clazz6 = Class.forName("org.apache.axis.EngineConfigurationFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        AxisProperties.setClassOverrideProperty(clazz6, (String)"axis.EngineConfigFactory");
        try {
            clazz5 = Class.forName("org.apache.axis.EngineConfigurationFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        String[] stringArray = new String[3];
        try {
            clazz4 = Class.forName("com.uwyn.rife.engine.elements.axis.EngineConfigurationFactoryRife");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz4.getName();
        try {
            clazz3 = Class.forName("org.apache.axis.configuration.EngineConfigurationFactoryServlet");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz3.getName();
        try {
            clazz2 = Class.forName("org.apache.axis.configuration.EngineConfigurationFactoryDefault");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[2] = clazz2.getName();
        AxisProperties.setClassDefaults(clazz5, (String[])stringArray);
        mLogException = LogFactory.getLog((String)"org.apache.axis.EXCEPTIONS");
        try {
            clazz = Class.forName("com.uwyn.rife.engine.elements.SoapAxis");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        mLogElement = LogFactory.getLog((String)clazz.getName());
        mLogTiming = LogFactory.getLog((String)"org.apache.axis.TIME");
    }
}

