/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.SiteBuilder;
import com.uwyn.rife.engine.SiteProcessor;
import com.uwyn.rife.engine.XmlElementInfoProcessor;
import com.uwyn.rife.engine.exceptions.NotFoundProcessingErrorException;
import com.uwyn.rife.engine.exceptions.ParsingErrorException;
import com.uwyn.rife.engine.exceptions.ProcessingErrorException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.xml.Xml2Data;
import com.uwyn.rife.xml.exceptions.CantFindResourceException;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.net.URL;
import java.util.ArrayList;
import org.xml.sax.Attributes;

class Xml2Site
implements SiteProcessor {
    Xml2Site() {
    }

    public void processSite(SiteBuilder builder, String declarationName, ResourceFinder resourceFinder) {
        XmlProcessor processor = new XmlProcessor(builder);
        String processed_path = null;
        try {
            try {
                processed_path = declarationName;
                processor.processXml(processed_path, resourceFinder);
            }
            catch (CantFindResourceException e) {
                processed_path = "sites/" + declarationName;
                processor.processXml(processed_path, resourceFinder);
            }
        }
        catch (XmlErrorException e) {
            throw new ProcessingErrorException("site", declarationName, e);
        }
        if (RifeConfig.Engine.getSiteAutoReload()) {
            URL resource = resourceFinder.getResource(processed_path);
            if (resource == null) {
                throw new NotFoundProcessingErrorException("site", processed_path, null);
            }
            try {
                builder.addResourceModificationTime(resource, resourceFinder.getModificationTime(resource));
            }
            catch (ResourceFinderErrorException e) {
                throw new ProcessingErrorException("site", declarationName, "Error while retrieving the modification time.", e);
            }
        }
    }

    private class XmlProcessor
    extends Xml2Data {
        private SiteBuilder mSiteBuilder = null;
        private SiteBuilder mCurrentSubsiteBuilder = null;
        private ElementInfoBuilder mCurrentElementInfoBuilder = null;
        private XmlElementInfoProcessor mCurrentElementInfoProcessor = null;
        private String mCurrentPropertyName = null;
        private String mCurrentGlobalVar = null;
        private ArrayList<String> mCurrentGlobalVarDefaults = null;
        private String mCurrentGlobalCookie = null;
        private String mCurrentGlobalCookieDefault = null;
        private StringBuffer mCharacterData = null;

        XmlProcessor(SiteBuilder builder) {
            this.mSiteBuilder = builder;
        }

        public void startDocument() {
            this.mCurrentPropertyName = null;
            this.mCurrentGlobalVar = null;
            this.mCurrentGlobalVarDefaults = null;
            this.mCurrentGlobalCookie = null;
            this.mCurrentGlobalCookieDefault = null;
            this.mCharacterData = null;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (qName.equals("site")) {
                this.mSiteBuilder.setFallback(atts.getValue("fallbackid"));
            } else if (qName.equals("subsite")) {
                this.mCurrentSubsiteBuilder = this.mSiteBuilder.enterSubsite(atts.getValue("file")).setId(atts.getValue("id")).setUrlPrefix(atts.getValue("urlprefix")).setInherits(atts.getValue("inherits")).setPre(atts.getValue("pre"));
            } else if (qName.equals("group")) {
                String inherits = atts.getValue("inherits");
                String pre = atts.getValue("pre");
                this.mSiteBuilder.enterGroup().setInherits(inherits).setPre(pre);
            } else if (qName.equals("globalvar")) {
                this.mCurrentGlobalVar = atts.getValue("name");
                this.mCurrentGlobalVarDefaults = new ArrayList();
            } else if (qName.equals("globalcookie")) {
                this.mCurrentGlobalCookie = atts.getValue("name");
                this.mCurrentGlobalCookieDefault = null;
            } else if (qName.equals("globalbean")) {
                String classname = atts.getValue("classname");
                String prefix = atts.getValue("prefix");
                String name = atts.getValue("name");
                this.mSiteBuilder.addGlobalBean(classname, prefix, name);
            } else if (qName.equals("globalexit")) {
                String inheritance;
                String name = atts.getValue("name");
                String destid = atts.getValue("destid");
                boolean reflective = false;
                boolean snapback = false;
                boolean cancel_inheritance = false;
                boolean redirect = false;
                if (atts.getValue("reflect") != null && (atts.getValue("reflect").equals("1") || atts.getValue("reflect").equals("t") || atts.getValue("reflect").equals("true"))) {
                    reflective = true;
                }
                if (atts.getValue("snapback") != null && (atts.getValue("snapback").equals("1") || atts.getValue("snapback").equals("t") || atts.getValue("snapback").equals("true"))) {
                    snapback = true;
                }
                if (atts.getValue("redirect") != null && (atts.getValue("redirect").equals("1") || atts.getValue("redirect").equals("t") || atts.getValue("redirect").equals("true"))) {
                    redirect = true;
                }
                if ((inheritance = atts.getValue("inheritance")) != null && inheritance.equals("cancel")) {
                    cancel_inheritance = true;
                }
                this.mSiteBuilder.addGlobalExit(name, destid, reflective, snapback, cancel_inheritance, redirect);
            } else if (qName.equals("arrival")) {
                this.mSiteBuilder.setArrival(atts.getValue("destid"));
            } else if (qName.equals("departure")) {
                this.mSiteBuilder.addDeparture(atts.getValue("srcid"));
            } else if (qName.equals("state")) {
                this.mSiteBuilder.enterState(atts.getValue("store"));
            } else if (qName.equals("element")) {
                this.mCurrentElementInfoBuilder = this.mSiteBuilder.enterElement(atts.getValue("file")).setId(atts.getValue("id")).setUrl(atts.getValue("url")).setInherits(atts.getValue("inherits")).setPre(atts.getValue("pre"));
                this.mCurrentElementInfoProcessor = new XmlElementInfoProcessor(this.mCurrentElementInfoBuilder);
                this.mCurrentElementInfoProcessor.startElement(namespaceURI, localName, qName, atts);
            } else if (qName.equals("datalink")) {
                String srcoutput = atts.getValue("srcoutput");
                String srcoutbean = atts.getValue("srcoutbean");
                String dest_id = atts.getValue("destid");
                boolean snapback = false;
                String destinput = atts.getValue("destinput");
                String destinbean = atts.getValue("destinbean");
                if (atts.getValue("snapback") != null && (atts.getValue("snapback").equals("1") || atts.getValue("snapback").equals("t") || atts.getValue("snapback").equals("true"))) {
                    snapback = true;
                }
                this.mCurrentElementInfoBuilder.addDataLink(srcoutput, srcoutbean, dest_id, snapback, destinput, destinbean);
            } else if (qName.equals("flowlink")) {
                String inheritance;
                String srcexit = atts.getValue("srcexit");
                String destid = atts.getValue("destid");
                boolean snapback = false;
                boolean cancel_inheritance = false;
                boolean redirect = false;
                if (atts.getValue("snapback") != null && (atts.getValue("snapback").equals("1") || atts.getValue("snapback").equals("t") || atts.getValue("snapback").equals("true"))) {
                    snapback = true;
                }
                if (atts.getValue("redirect") != null && (atts.getValue("redirect").equals("1") || atts.getValue("redirect").equals("t") || atts.getValue("redirect").equals("true"))) {
                    redirect = true;
                }
                if ((inheritance = atts.getValue("inheritance")) != null && inheritance.equals("cancel")) {
                    cancel_inheritance = true;
                }
                this.mCurrentElementInfoBuilder.addFlowLink(srcexit, destid, snapback, cancel_inheritance, redirect);
            } else if (qName.equals("property")) {
                this.mCharacterData = new StringBuffer();
                this.mCurrentPropertyName = atts.getValue("name");
            } else if (qName.equals("default")) {
                this.mCharacterData = new StringBuffer();
            } else if (qName.equals("config")) {
                if (this.mCharacterData != null && Config.hasRepInstance()) {
                    this.mCharacterData.append(Config.getRepInstance().getString(atts.getValue("param"), ""));
                }
            } else if (this.mCurrentElementInfoProcessor != null) {
                this.mCurrentElementInfoProcessor.startElement(namespaceURI, localName, qName, atts);
            } else {
                throw new ParsingErrorException("site", this.getXmlPath(), "Unsupport element name '" + qName + "'.", null);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("element")) {
                this.mCurrentElementInfoProcessor = null;
                this.mCurrentElementInfoBuilder.leaveElement();
                this.mCurrentElementInfoBuilder = null;
            } else if (qName.equals("subsite")) {
                this.mCurrentSubsiteBuilder.leaveSubsite();
                this.mCurrentSubsiteBuilder = null;
            } else if (qName.equals("state")) {
                this.mSiteBuilder.leaveState();
            } else if (qName.equals("group")) {
                this.mSiteBuilder.leaveGroup();
            } else if (qName.equals("globalvar")) {
                String[] defaults = null;
                if (this.mCurrentGlobalVarDefaults.size() > 0) {
                    defaults = new String[this.mCurrentGlobalVarDefaults.size()];
                    defaults = this.mCurrentGlobalVarDefaults.toArray(defaults);
                }
                this.mSiteBuilder.addGlobalVar(this.mCurrentGlobalVar, defaults);
                this.mCurrentGlobalVar = null;
                this.mCurrentGlobalVarDefaults = null;
            } else if (qName.equals("globalcookie")) {
                this.mSiteBuilder.addGlobalCookie(this.mCurrentGlobalCookie, this.mCurrentGlobalCookieDefault);
                this.mCurrentGlobalCookie = null;
                this.mCurrentGlobalCookieDefault = null;
            } else if (qName.equals("property")) {
                if (this.mCurrentSubsiteBuilder == null) {
                    this.mCurrentElementInfoBuilder.addProperty(this.mCurrentPropertyName, this.mCharacterData.toString());
                } else {
                    this.mCurrentSubsiteBuilder.addProperty(this.mCurrentPropertyName, this.mCharacterData.toString());
                }
                this.mCharacterData = null;
            } else if (qName.equals("default")) {
                if (this.mCurrentGlobalCookie != null) {
                    this.mCurrentGlobalCookieDefault = this.mCharacterData.toString();
                } else if (this.mCurrentGlobalVar != null) {
                    this.mCurrentGlobalVarDefaults.add(this.mCharacterData.toString());
                }
                this.mCharacterData = null;
            } else if (this.mCurrentElementInfoProcessor != null) {
                this.mCurrentElementInfoProcessor.endElement(namespaceURI, localName, qName);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (length > 0 && this.mCharacterData != null) {
                this.mCharacterData.append(String.copyValueOf(ch, start, length));
            }
        }

        static /* synthetic */ Xml2Site access$0(XmlProcessor xmlProcessor) {
            return xmlProcessor.Xml2Site.this;
        }
    }
}

