/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.ElementInfoProcessor;
import com.uwyn.rife.engine.XmlElementInfoProcessor;
import com.uwyn.rife.engine.exceptions.NotFoundProcessingErrorException;
import com.uwyn.rife.engine.exceptions.ProcessingErrorException;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.resources.exceptions.ResourceFinderErrorException;
import com.uwyn.rife.xml.exceptions.CantFindResourceException;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.net.URL;

class Xml2ElementInfo
implements ElementInfoProcessor {
    Xml2ElementInfo() {
    }

    public void processElementInfo(ElementInfoBuilder builder, String declarationName, ResourceFinder resourceFinder) {
        XmlElementInfoProcessor processor = new XmlElementInfoProcessor(builder);
        String processed_path = null;
        try {
            try {
                processed_path = declarationName;
                processor.processXml(processed_path, resourceFinder);
            }
            catch (CantFindResourceException e) {
                processed_path = "elements/" + declarationName;
                processor.processXml(processed_path, resourceFinder);
            }
        }
        catch (XmlErrorException e) {
            throw new ProcessingErrorException("element", declarationName, e);
        }
        if (RifeConfig.Engine.getSiteAutoReload()) {
            URL resource = resourceFinder.getResource(processed_path);
            if (resource == null) {
                throw new NotFoundProcessingErrorException("element", processed_path, null);
            }
            try {
                builder.addResourceModificationTime(resource, resourceFinder.getModificationTime(resource));
            }
            catch (ResourceFinderErrorException e) {
                throw new ProcessingErrorException("element", declarationName, "Error while retrieving the modification time.", e);
            }
        }
    }
}

