/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.ContinuationDebug;
import com.uwyn.rife.engine.TypesNode;
import com.uwyn.rife.pcj.map.IntKeyOpenHashMap;
import com.uwyn.rife.tools.ExceptionUtils;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypesContext
implements Cloneable {
    public static final String CAT1_BOOLEAN = "1Z";
    public static final String CAT1_CHAR = "1C";
    public static final String CAT1_FLOAT = "1F";
    public static final String CAT1_BYTE = "1B";
    public static final String CAT1_SHORT = "1S";
    public static final String CAT1_INT = "1I";
    public static final String CAT1_ADDRESS = "1A";
    public static final String CAT2_DOUBLE = "2D";
    public static final String CAT2_LONG = "2J";
    public static final String ARRAY_BOOLEAN = "[Z";
    public static final String ARRAY_CHAR = "[C";
    public static final String ARRAY_FLOAT = "[F";
    public static final String ARRAY_BYTE = "[B";
    public static final String ARRAY_SHORT = "[S";
    public static final String ARRAY_INT = "[I";
    public static final String ARRAY_DOUBLE = "[D";
    public static final String ARRAY_LONG = "[J";
    public static final String NULL = "NULL";
    private IntKeyOpenHashMap<String> mVars = null;
    private Stack<String> mStack = null;
    private int mSort = 0;
    private String mDebugIndent = null;

    TypesContext() {
        this.mVars = new IntKeyOpenHashMap();
        this.mStack = new Stack();
    }

    TypesContext(IntKeyOpenHashMap<String> vars, Stack<String> stack) {
        this.mVars = vars;
        this.mStack = stack;
    }

    IntKeyOpenHashMap<String> getVars() {
        return this.mVars;
    }

    Stack<String> getStack() {
        return this.mStack;
    }

    boolean hasVar(int var) {
        return this.mVars.containsKey(var);
    }

    String getVar(int var) {
        return this.mVars.get(var);
    }

    void setVar(int var, String type) {
        this.mVars.put(var, type);
    }

    int getVarType(int var) {
        String type = this.getVar(var);
        if (CAT1_INT == type) {
            return 5;
        }
        if (CAT1_FLOAT == type) {
            return 6;
        }
        if (CAT2_LONG == type) {
            return 7;
        }
        if (CAT2_DOUBLE == type) {
            return 8;
        }
        return 10;
    }

    String peek() {
        return this.mStack.peek();
    }

    String pop() {
        String result = null;
        if (this.mStack.size() > 0) {
            result = this.mStack.pop();
        }
        this.printStack();
        return result;
    }

    void push(String type) {
        this.mStack.push(type);
        this.printStack();
    }

    Stack<String> getStackClone() {
        return (Stack)this.mStack.clone();
    }

    void cloneVars() {
        this.mVars = new IntKeyOpenHashMap(this.mVars);
    }

    void setSort(int type) {
        this.mSort = type;
    }

    int getSort() {
        return this.mSort;
    }

    void printStack() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            if (0 == this.mStack.size()) {
                ContinuationDebug.LOGGER.finest(new StringBuffer().append(this.mDebugIndent).append("  | empty").toString());
            } else {
                int i = 0;
                while (i < this.mStack.size()) {
                    ContinuationDebug.LOGGER.finest(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(new StringBuffer().append(this.mDebugIndent).append("  | ").toString()).append(i).toString()).append(" : ").toString()).append((String)this.mStack.get(i)).toString());
                    ++i;
                }
            }
        }
    }

    void setDebugIndent(String debugIndent) {
        this.mDebugIndent = debugIndent;
    }

    TypesContext clone(TypesNode node) {
        TypesContext new_context = new TypesContext(new IntKeyOpenHashMap<String>(this.mVars), (Stack)this.mStack.clone());
        new_context.setSort(node.getSort());
        return new_context;
    }

    public TypesContext clone() {
        TypesContext new_context = null;
        try {
            new_context = (TypesContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.engine").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        new_context.mVars = new IntKeyOpenHashMap(this.mVars);
        new_context.mStack = (Stack)this.mStack.clone();
        return new_context;
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }
}

