/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.TriggerContext;
import com.uwyn.rife.tools.ArrayUtils;
import com.uwyn.rife.tools.Base64;
import com.uwyn.rife.tools.IntegerUtils;
import com.uwyn.rife.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TriggerListEncoder {
    private static final String SEP_DATAPART = "d\u0000";
    private static final byte[] SEP_DATAPART_BYTES;
    private static final String SEP_DECLARATION_NAME = "x\u0000";
    private static final byte[] SEP_DECLARATION_NAME_BYTES;
    private static final String SEP_TRIGGER_NAME = "t\u0000";
    private static final byte[] SEP_TRIGGER_NAME_BYTES;
    private static final String SEP_PARAMETER_NAME = "n\u0000";
    private static final byte[] SEP_PARAMETER_NAME_BYTES;
    private static final String SEP_PARAMETER_NAMES = "s\u0000";
    private static final byte[] SEP_PARAMETER_NAMES_BYTES;
    private static final String SEP_VALUE = "v\u0000";
    private static final byte[] SEP_VALUE_BYTES;
    private static final String SEP_VALUEARRAY = "a\u0000";
    private static final byte[] SEP_VALUEARRAY_BYTES;
    private static final String SEP_VALUEARRAYS = "y\u0000";
    private static final byte[] SEP_VALUEARRAYS_BYTES;
    private static /* synthetic */ boolean $assertionsDisabled;

    static String encode(ArrayList<TriggerContext> triggerList) {
        if (!$assertionsDisabled && triggerList == null) {
            throw new AssertionError();
        }
        if (0 == triggerList.size()) {
            return "";
        }
        byte[] trigger_list = new byte[4 + triggerList.size() * 4];
        Iterator<TriggerContext> trigger_it = null;
        TriggerContext trigger_context2 = null;
        byte[] hashcode_bytes = new byte[4];
        int counter = 0;
        hashcode_bytes = IntegerUtils.intToBytes(triggerList.size());
        trigger_list[counter++] = hashcode_bytes[0];
        trigger_list[counter++] = hashcode_bytes[1];
        trigger_list[counter++] = hashcode_bytes[2];
        trigger_list[counter++] = hashcode_bytes[3];
        for (TriggerContext trigger_context2 : triggerList) {
            hashcode_bytes = IntegerUtils.intToBytes(trigger_context2.getType());
            trigger_list[counter++] = hashcode_bytes[0];
            trigger_list[counter++] = hashcode_bytes[1];
            trigger_list[counter++] = hashcode_bytes[2];
            trigger_list[counter++] = hashcode_bytes[3];
        }
        byte[] xmlfile_names_encoded = new byte[]{};
        trigger_it = triggerList.iterator();
        while (trigger_it.hasNext()) {
            trigger_context2 = trigger_it.next();
            xmlfile_names_encoded = ArrayUtils.join(xmlfile_names_encoded, trigger_context2.getDeclarationName().getBytes());
            if (!trigger_it.hasNext()) continue;
            xmlfile_names_encoded = ArrayUtils.join(xmlfile_names_encoded, SEP_DECLARATION_NAME_BYTES);
        }
        byte[] trigger_names_encoded = new byte[]{};
        trigger_it = triggerList.iterator();
        while (trigger_it.hasNext()) {
            trigger_context2 = trigger_it.next();
            trigger_names_encoded = ArrayUtils.join(trigger_names_encoded, trigger_context2.getTriggerName().getBytes());
            if (!trigger_it.hasNext()) continue;
            trigger_names_encoded = ArrayUtils.join(trigger_names_encoded, SEP_TRIGGER_NAME_BYTES);
        }
        String[] trigger_values = null;
        byte[] trigger_values_encoded = new byte[]{};
        trigger_it = triggerList.iterator();
        while (trigger_it.hasNext()) {
            trigger_context2 = trigger_it.next();
            trigger_values = trigger_context2.getTriggerValues();
            int i = 0;
            while (i < trigger_values.length) {
                trigger_values_encoded = ArrayUtils.join(trigger_values_encoded, trigger_values[i].getBytes());
                if (i < trigger_values.length - 1) {
                    trigger_list = ArrayUtils.join(trigger_list, SEP_VALUE_BYTES);
                }
                ++i;
            }
            if (!trigger_it.hasNext()) continue;
            trigger_values_encoded = ArrayUtils.join(trigger_values_encoded, SEP_VALUEARRAY_BYTES);
        }
        Set<Map.Entry<String, String[]>> parameter_entries = null;
        Iterator<Map.Entry<String, String[]>> parameter_entries_it = null;
        Map.Entry<String, String[]> parameter_entry = null;
        String[] parameter_values = null;
        byte[] parameter_names_encoded = new byte[]{};
        byte[] parameter_values_encoded = new byte[]{};
        trigger_it = triggerList.iterator();
        while (trigger_it.hasNext()) {
            trigger_context2 = trigger_it.next();
            parameter_entries = trigger_context2.getParameters().entrySet();
            parameter_entries_it = parameter_entries.iterator();
            while (parameter_entries_it.hasNext()) {
                parameter_entry = parameter_entries_it.next();
                parameter_names_encoded = ArrayUtils.join(parameter_names_encoded, parameter_entry.getKey().getBytes());
                parameter_values = parameter_entry.getValue();
                int i = 0;
                while (i < parameter_values.length) {
                    parameter_values_encoded = ArrayUtils.join(parameter_values_encoded, parameter_values[i].getBytes());
                    if (i < parameter_values.length - 1) {
                        trigger_list = ArrayUtils.join(trigger_list, SEP_VALUE_BYTES);
                    }
                    ++i;
                }
                if (!parameter_entries_it.hasNext()) continue;
                parameter_names_encoded = ArrayUtils.join(parameter_names_encoded, SEP_PARAMETER_NAME_BYTES);
                parameter_values_encoded = ArrayUtils.join(parameter_values_encoded, SEP_VALUEARRAY_BYTES);
            }
            if (!trigger_it.hasNext()) continue;
            parameter_names_encoded = ArrayUtils.join(parameter_names_encoded, SEP_PARAMETER_NAMES_BYTES);
            parameter_values_encoded = ArrayUtils.join(parameter_values_encoded, SEP_VALUEARRAYS_BYTES);
        }
        trigger_list = ArrayUtils.join(trigger_list, xmlfile_names_encoded);
        trigger_list = ArrayUtils.join(trigger_list, SEP_DATAPART_BYTES);
        trigger_list = ArrayUtils.join(trigger_list, trigger_names_encoded);
        trigger_list = ArrayUtils.join(trigger_list, SEP_DATAPART_BYTES);
        trigger_list = ArrayUtils.join(trigger_list, trigger_values_encoded);
        trigger_list = ArrayUtils.join(trigger_list, SEP_DATAPART_BYTES);
        trigger_list = ArrayUtils.join(trigger_list, parameter_names_encoded);
        trigger_list = ArrayUtils.join(trigger_list, SEP_DATAPART_BYTES);
        trigger_list = ArrayUtils.join(trigger_list, parameter_values_encoded);
        return Base64.encodeToString(trigger_list, false);
    }

    static ArrayList<TriggerContext> decode(String[] triggerListValues) {
        if (triggerListValues != null && triggerListValues.length > 0 && triggerListValues[0] != null && triggerListValues[0].length() > 0) {
            TriggerContext[] trigger_list = null;
            byte[] hashcode_bytes = new byte[4];
            byte[] decoded_bytes = null;
            decoded_bytes = Base64.decode(triggerListValues[0]);
            System.arraycopy(decoded_bytes, 0, hashcode_bytes, 0, 4);
            int number_of_triggers = IntegerUtils.bytesToInt(hashcode_bytes);
            trigger_list = new TriggerContext[number_of_triggers];
            int triggers_types_offset = 4;
            int i = 0;
            while (i < number_of_triggers) {
                System.arraycopy(decoded_bytes, triggers_types_offset + i * 4, hashcode_bytes, 0, 4);
                trigger_list[i] = new TriggerContext();
                trigger_list[i].setType(IntegerUtils.bytesToInt(hashcode_bytes));
                ++i;
            }
            int triggers_names_offset = 4 + number_of_triggers * 4;
            String triggers_data = new String(decoded_bytes, triggers_names_offset, decoded_bytes.length - triggers_names_offset);
            ArrayList<String> triggers_data_parts = StringUtils.split(triggers_data, SEP_DATAPART);
            ArrayList<String> elementinfo_names = StringUtils.split(triggers_data_parts.get(0), SEP_DECLARATION_NAME);
            int i2 = 0;
            while (i2 < number_of_triggers) {
                trigger_list[i2].setDeclarationName(elementinfo_names.get(i2));
                ++i2;
            }
            ArrayList<String> triggers_names = StringUtils.split(triggers_data_parts.get(1), SEP_TRIGGER_NAME);
            int i3 = 0;
            while (i3 < number_of_triggers) {
                trigger_list[i3].setTriggerName(triggers_names.get(i3));
                ++i3;
            }
            ArrayList<String> trigger_values_list = StringUtils.split(triggers_data_parts.get(2), SEP_VALUEARRAY);
            ArrayList<String> trigger_values = null;
            String[] trigger_values_array = null;
            int i4 = 0;
            while (i4 < number_of_triggers) {
                trigger_values = StringUtils.split(trigger_values_list.get(i4), SEP_VALUE);
                trigger_values_array = new String[trigger_values.size()];
                trigger_values_array = trigger_values.toArray(trigger_values_array);
                trigger_list[i4].setTriggerValues(trigger_values_array);
                ++i4;
            }
            ArrayList<String> parameter_names_list = StringUtils.split(triggers_data_parts.get(3), SEP_PARAMETER_NAMES);
            ArrayList<String> parameter_values_list = StringUtils.split(triggers_data_parts.get(4), SEP_VALUEARRAYS);
            ArrayList<String> parameter_names = null;
            ArrayList<String> parameter_valuearrays = null;
            ArrayList<String> parameter_values = null;
            String[] parameter_values_array = null;
            HashMap<String, String[]> parameters = null;
            int i5 = 0;
            while (i5 < number_of_triggers) {
                parameters = new HashMap<String, String[]>();
                if (parameter_names_list.get(i5).length() > 0) {
                    parameter_names = StringUtils.split(parameter_names_list.get(i5), SEP_PARAMETER_NAME);
                    parameter_valuearrays = StringUtils.split(parameter_values_list.get(i5), SEP_VALUEARRAY);
                    int j = 0;
                    while (j < parameter_names.size()) {
                        parameter_values = StringUtils.split(parameter_valuearrays.get(j), SEP_VALUE);
                        parameter_values_array = new String[parameter_values.size()];
                        parameter_values_array = parameter_values.toArray(parameter_values_array);
                        parameters.put(parameter_names.get(j), parameter_values_array);
                        ++j;
                    }
                }
                trigger_list[i5].setParameters(parameters);
                ++i5;
            }
            return new ArrayList<TriggerContext>(Arrays.asList(trigger_list));
        }
        return new ArrayList<TriggerContext>();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.TriggerListEncoder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        SEP_DATAPART_BYTES = SEP_DATAPART.getBytes();
        SEP_DECLARATION_NAME_BYTES = SEP_DECLARATION_NAME.getBytes();
        SEP_TRIGGER_NAME_BYTES = SEP_TRIGGER_NAME.getBytes();
        SEP_PARAMETER_NAME_BYTES = SEP_PARAMETER_NAME.getBytes();
        SEP_PARAMETER_NAMES_BYTES = SEP_PARAMETER_NAMES.getBytes();
        SEP_VALUE_BYTES = SEP_VALUE.getBytes();
        SEP_VALUEARRAY_BYTES = SEP_VALUEARRAY.getBytes();
        SEP_VALUEARRAYS_BYTES = SEP_VALUEARRAYS.getBytes();
    }
}

