/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.GroupDeclaration;
import com.uwyn.rife.engine.SiteBuilder;
import com.uwyn.rife.engine.StateStore;
import com.uwyn.rife.engine.exceptions.SubsiteIdInvalidException;
import java.util.Stack;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubsiteDeclaration {
    private SiteBuilder mSiteBuilder = null;
    private String mId = null;
    private String mDeclarationName = null;
    private String mUrlPrefix = null;
    private GroupDeclaration mGroup = null;
    private Stack<StateStore> mStateStores = null;

    SubsiteDeclaration(String declarationName, GroupDeclaration group, Stack<StateStore> stateStores) {
        this.mDeclarationName = declarationName;
        this.mUrlPrefix = "";
        this.mGroup = group;
        this.mStateStores = (Stack)stateStores.clone();
    }

    void setId(String id) {
        if (id == null) {
            id = SiteBuilder.generateId(this.mDeclarationName);
        }
        if (id.indexOf(".") != -1 || id.indexOf("^") != -1) {
            throw new SubsiteIdInvalidException(id);
        }
        this.mId = id;
    }

    String getId() {
        if (this.mId == null) {
            this.setId(null);
        }
        return this.mId;
    }

    void setUrlPrefix(String urlPrefix) {
        this.mUrlPrefix = urlPrefix == null ? "" : urlPrefix;
    }

    void setSiteBuilder(SiteBuilder siteBuilder) {
        this.mSiteBuilder = siteBuilder;
    }

    SiteBuilder getSiteBuilder() {
        return this.mSiteBuilder;
    }

    String getDeclarationName() {
        return this.mDeclarationName;
    }

    String getUrlPrefix() {
        return this.mUrlPrefix;
    }

    GroupDeclaration getGroupDeclaration() {
        return this.mGroup;
    }

    Stack<StateStore> getStateStores() {
        return this.mStateStores;
    }
}

