/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.BeanDeclaration;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementInfoBuilder;
import com.uwyn.rife.engine.Scope;
import com.uwyn.rife.engine.Submission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class SubmissionBuilder {
    private ElementInfoBuilder mElementInfoBuilder = null;
    private String mName = null;
    private LinkedHashMap<String, String[]> mParameters = null;
    private ArrayList<String> mParametersRegexp = null;
    private LinkedHashMap<BeanDeclaration, String> mBeans = null;
    private ArrayList<String> mFiles = null;
    private Scope mScope = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    SubmissionBuilder(ElementInfoBuilder elementInfoBuilder, String name) {
        if (!$assertionsDisabled && elementInfoBuilder == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.mElementInfoBuilder = elementInfoBuilder;
        this.mName = name;
    }

    Submission getSubmission(ElementInfo elementInfo) {
        Iterator iterator;
        Submission submission = new Submission();
        elementInfo.addSubmission(this.mName, submission);
        submission.setScope(this.mScope);
        if (this.mParameters != null) {
            iterator = ((Collection)this.mParameters.entrySet()).iterator();
            while (iterator.hasNext()) {
                Map.Entry parameter = (Map.Entry)iterator.next();
                submission.addParameter((String)parameter.getKey(), (String[])parameter.getValue());
            }
        }
        if (this.mParametersRegexp != null) {
            iterator = ((Collection)this.mParametersRegexp).iterator();
            while (iterator.hasNext()) {
                String pattern = (String)iterator.next();
                submission.addParameterRegexp(pattern);
            }
        }
        if (this.mBeans != null) {
            iterator = ((Collection)this.mBeans.entrySet()).iterator();
            while (iterator.hasNext()) {
                Map.Entry bean = (Map.Entry)iterator.next();
                submission.addBean((BeanDeclaration)bean.getKey(), (String)bean.getValue());
            }
        }
        if (this.mFiles != null) {
            iterator = ((Collection)this.mFiles).iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                submission.addFile(name);
            }
        }
        return submission;
    }

    public void setScope(Scope scope) {
        this.mScope = scope;
    }

    public SubmissionBuilder addParameter(String name) {
        return this.addParameter(name, null);
    }

    public SubmissionBuilder addParameter(String name, String[] defaultValues) {
        if (this.mParameters == null) {
            this.mParameters = new LinkedHashMap();
        }
        this.mParameters.put(name, defaultValues);
        return this;
    }

    public SubmissionBuilder addParameterRegexp(String pattern) {
        if (this.mParametersRegexp == null) {
            this.mParametersRegexp = new ArrayList();
        }
        this.mParametersRegexp.add(pattern);
        return this;
    }

    public SubmissionBuilder addBean(String classname) {
        return this.addBean(classname, null, null);
    }

    public SubmissionBuilder addBean(String classname, String prefix, String name) {
        if (this.mBeans == null) {
            this.mBeans = new LinkedHashMap();
        }
        this.mBeans.put(new BeanDeclaration(classname, prefix), name);
        return this;
    }

    public SubmissionBuilder addFile(String name) {
        if (this.mFiles == null) {
            this.mFiles = new ArrayList();
        }
        this.mFiles.add(name);
        return this;
    }

    public ElementInfoBuilder leaveSubmission() {
        return this.mElementInfoBuilder;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.SubmissionBuilder");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

