/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.engine;

import com.uwyn.rife.engine.BeanDeclaration;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.Scope;
import com.uwyn.rife.engine.exceptions.FileExistsException;
import com.uwyn.rife.engine.exceptions.FileGlobalCookieConflictException;
import com.uwyn.rife.engine.exceptions.FileGlobalVarConflictException;
import com.uwyn.rife.engine.exceptions.FileIncookieConflictException;
import com.uwyn.rife.engine.exceptions.FileInputConflictException;
import com.uwyn.rife.engine.exceptions.FileParameterConflictException;
import com.uwyn.rife.engine.exceptions.FileParameterRegexpConflictException;
import com.uwyn.rife.engine.exceptions.FilePropertyConflictException;
import com.uwyn.rife.engine.exceptions.NamedSubmissionBeanClassnameErrorException;
import com.uwyn.rife.engine.exceptions.NamedSubmissionBeanExistsException;
import com.uwyn.rife.engine.exceptions.NamedSubmissionBeanPropertiesErrorException;
import com.uwyn.rife.engine.exceptions.NamedSubmissionBeanUnknownException;
import com.uwyn.rife.engine.exceptions.ParameterExistsException;
import com.uwyn.rife.engine.exceptions.ParameterFileConflictException;
import com.uwyn.rife.engine.exceptions.ParameterGlobalCookieConflictException;
import com.uwyn.rife.engine.exceptions.ParameterGlobalVarConflictException;
import com.uwyn.rife.engine.exceptions.ParameterIncookieConflictException;
import com.uwyn.rife.engine.exceptions.ParameterInputConflictException;
import com.uwyn.rife.engine.exceptions.ParameterPropertyConflictException;
import com.uwyn.rife.engine.exceptions.ParameterRegexpConflictException;
import com.uwyn.rife.engine.exceptions.ParameterRegexpFileConflictException;
import com.uwyn.rife.engine.exceptions.ParameterRegexpGlobalCookieConflictException;
import com.uwyn.rife.engine.exceptions.ParameterRegexpGlobalVarConflictException;
import com.uwyn.rife.engine.exceptions.ParameterRegexpInputConflictException;
import com.uwyn.rife.engine.exceptions.ParameterRegexpInvalidException;
import com.uwyn.rife.engine.exceptions.SubmissionBeanClassnameErrorException;
import com.uwyn.rife.engine.exceptions.SubmissionBeanPropertiesErrorException;
import com.uwyn.rife.site.Constrained;
import com.uwyn.rife.site.ConstrainedUtils;
import com.uwyn.rife.tools.BeanUtils;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.BeanUtilsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Submission
implements Cloneable {
    private String mName = null;
    private ElementInfo mElementInfo = null;
    private HashMap<String, String[]> mParameters = new HashMap();
    private ArrayList<String> mParameterDefaults = new ArrayList();
    private ArrayList<Pattern> mParameterRegexps = new ArrayList();
    private ArrayList<String> mFiles = new ArrayList();
    private boolean mHasParameterDefaults = false;
    private ArrayList<BeanDeclaration> mBeans = new ArrayList();
    private HashMap<String, BeanDeclaration> mNamedBeans = new HashMap();
    private Scope mScope = Scope.LOCAL;
    private static /* synthetic */ boolean $assertionsDisabled;

    Submission() {
    }

    void setName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    void setScope(Scope scope) {
        if (scope == null) {
            scope = Scope.LOCAL;
        }
        this.mScope = scope;
    }

    public Scope getScope() {
        return this.mScope;
    }

    void setElementInfo(ElementInfo elementInfo) {
        this.mElementInfo = elementInfo;
    }

    public ElementInfo getElementInfo() {
        return this.mElementInfo;
    }

    public Collection<String> getParameterNames() {
        return this.mParameters.keySet();
    }

    public Collection<Pattern> getParameterRegexps() {
        return this.mParameterRegexps;
    }

    public boolean containsParameter(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mParameters.containsKey(name)) {
            return true;
        }
        return StringUtils.getMatchingRegexp(name, this.mParameterRegexps) != null;
    }

    public boolean hasParameterDefaults() {
        return this.mHasParameterDefaults;
    }

    public Collection<String> getParameterDefaultNames() {
        return this.mParameterDefaults;
    }

    public String[] getParameterDefaultValues(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        return this.mParameters.get(name);
    }

    public boolean hasParameterDefaultValues(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        return this.mParameters.get(name) != null;
    }

    public Collection<BeanDeclaration> getBeans() {
        return this.mBeans;
    }

    public Collection<String> getBeanNames() {
        return this.mNamedBeans.keySet();
    }

    public BeanDeclaration getNamedBean(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        this.validateBeanName(name);
        return this.mNamedBeans.get(name);
    }

    public boolean containsNamedBean(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null.");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty.");
        }
        return this.mNamedBeans.containsKey(name);
    }

    void validateBeanName(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (!this.containsNamedBean(name)) {
            throw new NamedSubmissionBeanUnknownException(this.mElementInfo.getDeclarationName(), this.mName, name);
        }
    }

    void addParameter(String name, String[] defaultValues) {
        if (!$assertionsDisabled && this.mElementInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mParameters.containsKey(name)) {
            throw new ParameterExistsException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsInput(name)) {
            throw new ParameterInputConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsIncookie(name)) {
            throw new ParameterIncookieConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mFiles.contains(name)) {
            throw new ParameterFileConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsProperty(name)) {
            throw new ParameterPropertyConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsGlobalVar(name)) {
            throw new ParameterGlobalVarConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsGlobalCookie(name)) {
            throw new ParameterGlobalCookieConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        Matcher match = StringUtils.getMatchingRegexp(name, this.mParameterRegexps);
        if (match != null) {
            throw new ParameterRegexpConflictException(this.mElementInfo.getDeclarationName(), name, this.mName, match.pattern().pattern());
        }
        if (defaultValues != null) {
            this.mHasParameterDefaults = true;
            this.mParameterDefaults.add(name);
            if (this.mElementInfo != null) {
                this.mElementInfo.setHasSubmissionDefaults(true);
            }
        }
        this.mParameters.put(name, defaultValues);
    }

    void addParameterRegexp(String pattern) {
        if (!$assertionsDisabled && this.mElementInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pattern == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && pattern.length() <= 0) {
            throw new AssertionError();
        }
        if (!pattern.startsWith("^")) {
            pattern = new StringBuffer().append("^").append(pattern).toString();
        }
        if (!pattern.endsWith("$")) {
            pattern = new StringBuffer().append(pattern).append("$").toString();
        }
        Pattern compiled_pattern = null;
        try {
            compiled_pattern = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ParameterRegexpInvalidException(this.mElementInfo.getDeclarationName(), pattern, this.mName, e);
        }
        Matcher matcher = null;
        matcher = StringUtils.getRegexpMatch(this.mElementInfo.getInputNames(), compiled_pattern);
        if (matcher != null) {
            throw new ParameterRegexpInputConflictException(this.mElementInfo.getDeclarationName(), pattern, this.mName, matcher.group());
        }
        matcher = StringUtils.getRegexpMatch(this.mElementInfo.getIncookieNames(), compiled_pattern);
        if (matcher != null) {
            throw new ParameterRegexpInputConflictException(this.mElementInfo.getDeclarationName(), pattern, this.mName, matcher.group());
        }
        matcher = StringUtils.getRegexpMatch(this.mParameters.keySet(), compiled_pattern);
        if (matcher != null) {
            throw new ParameterRegexpConflictException(this.mElementInfo.getDeclarationName(), pattern, this.mName, matcher.group());
        }
        matcher = StringUtils.getRegexpMatch(this.mFiles, compiled_pattern);
        if (matcher != null) {
            throw new ParameterRegexpFileConflictException(this.mElementInfo.getDeclarationName(), pattern, this.mName, matcher.group());
        }
        matcher = StringUtils.getRegexpMatch(this.mElementInfo.getPropertyNames(), compiled_pattern);
        if (matcher != null) {
            throw new ParameterRegexpGlobalVarConflictException(this.mElementInfo.getDeclarationName(), pattern, this.mName, matcher.group());
        }
        matcher = StringUtils.getRegexpMatch(this.mElementInfo.getGlobalVarNames(), compiled_pattern);
        if (matcher != null) {
            throw new ParameterRegexpGlobalVarConflictException(this.mElementInfo.getDeclarationName(), pattern, this.mName, matcher.group());
        }
        matcher = StringUtils.getRegexpMatch(this.mElementInfo.getGlobalCookieNames(), compiled_pattern);
        if (matcher != null) {
            throw new ParameterRegexpGlobalCookieConflictException(this.mElementInfo.getDeclarationName(), pattern, this.mName, matcher.group());
        }
        this.mParameterRegexps.add(compiled_pattern);
    }

    void addBean(BeanDeclaration bean, String name) {
        if (!$assertionsDisabled && bean == null) {
            throw new AssertionError();
        }
        Class<?> bean_class = null;
        try {
            bean_class = Class.forName(bean.getClassname());
        }
        catch (ClassNotFoundException e) {
            if (name == null) {
                throw new SubmissionBeanClassnameErrorException(this.mElementInfo.getDeclarationName(), this.mName, bean.getClassname(), e);
            }
            throw new NamedSubmissionBeanClassnameErrorException(this.mElementInfo.getDeclarationName(), this.mName, name, bean.getClassname(), e);
        }
        if (name != null) {
            if (this.mNamedBeans.containsKey(name)) {
                throw new NamedSubmissionBeanExistsException(this.mElementInfo.getDeclarationName(), this.mName, name);
            }
            this.mNamedBeans.put(name, bean);
        }
        this.mBeans.add(bean);
        try {
            Constrained constrained = ConstrainedUtils.getConstrainedInstance(bean_class);
            SortedSet<String> properties = BeanUtils.getPropertyNames(bean_class, null, null, bean.getPrefix());
            for (String property : (Collection)properties) {
                if (!ConstrainedUtils.editConstrainedProperty(constrained, property, bean.getPrefix())) continue;
                if (ConstrainedUtils.fileConstrainedProperty(constrained, property, bean.getPrefix())) {
                    if (this.containsFile(property)) continue;
                    this.addFile(property);
                    continue;
                }
                if (this.containsParameter(property)) continue;
                this.addParameter(property, null);
            }
        }
        catch (BeanUtilsException e) {
            if (name == null) {
                throw new SubmissionBeanPropertiesErrorException(this.mElementInfo.getDeclarationName(), this.mName, bean.getClassname(), e);
            }
            throw new NamedSubmissionBeanPropertiesErrorException(this.mElementInfo.getDeclarationName(), this.mName, name, bean.getClassname(), e);
        }
    }

    void addFile(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        if (this.mFiles.contains(name)) {
            throw new FileExistsException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsInput(name)) {
            throw new FileInputConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsIncookie(name)) {
            throw new FileIncookieConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mParameters.containsKey(name)) {
            throw new FileParameterConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsProperty(name)) {
            throw new FilePropertyConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsGlobalVar(name)) {
            throw new FileGlobalVarConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        if (this.mElementInfo.containsGlobalCookie(name)) {
            throw new FileGlobalCookieConflictException(this.mElementInfo.getDeclarationName(), name, this.mName);
        }
        Matcher match = StringUtils.getMatchingRegexp(name, this.mParameterRegexps);
        if (match != null) {
            throw new FileParameterRegexpConflictException(this.mElementInfo.getDeclarationName(), name, this.mName, match.pattern().pattern());
        }
        this.mFiles.add(name);
    }

    public Collection<String> getFileNames() {
        return this.mFiles;
    }

    public boolean containsFile(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name.length() <= 0) {
            throw new AssertionError();
        }
        return this.mFiles.contains(name);
    }

    public synchronized Submission clone() {
        Submission new_submission = null;
        try {
            new_submission = (Submission)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.engine").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        new_submission.mElementInfo = null;
        if (this.mParameters != null) {
            new_submission.mParameters = new HashMap<String, String[]>(this.mParameters);
        }
        if (this.mFiles != null) {
            new_submission.mFiles = new ArrayList<String>(this.mFiles);
        }
        if (this.mBeans != null) {
            new_submission.mBeans = new ArrayList<BeanDeclaration>(this.mBeans);
        }
        if (this.mNamedBeans != null) {
            new_submission.mNamedBeans = new HashMap<String, BeanDeclaration>(this.mNamedBeans);
        }
        return new_submission;
    }

    public synchronized /* synthetic */ Object clone() {
        return this.clone();
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.engine.Submission");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

